/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.RemoveAllSearchesAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.ShowSearchAction;
import org.eclipse.search2.internal.ui.ShowSearchesAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class SearchDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private Menu fMenu;
    private SearchView fSearchView;

    public SearchDropDownAction(SearchView searchView) {
        this.setText(SearchMessages.getString("SearchDropDownAction.label"));
        this.setToolTipText(SearchMessages.getString("SearchDropDownAction.tooltip"));
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_history.gif");
        this.fSearchView = searchView;
        this.setMenuCreator(this);
    }

    public void dispose() {
        this.disposeMenu();
    }

    void disposeMenu() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        ISearchQuery currentQuery = null;
        ISearchResult currentSearch = this.fSearchView.getCurrentSearchResult();
        if (currentSearch != null) {
            currentQuery = currentSearch.getQuery();
        }
        this.disposeMenu();
        this.fMenu = new Menu(parent);
        ISearchQuery[] searches = InternalSearchUI.getInstance().getSearchManager().getQueries();
        int i = 0;
        while (i < searches.length) {
            ISearchResult search = searches[i].getSearchResult();
            String label = search.getLabel();
            String tooltip = search.getTooltip();
            ImageDescriptor image = search.getImageDescriptor();
            if (InternalSearchUI.getInstance().isQueryRunning(search.getQuery())) {
                label = String.valueOf(label) + SearchMessages.getString("SearchDropDownAction.running.message");
            }
            ShowSearchAction action = new ShowSearchAction(this.fSearchView, search, label, image, tooltip);
            if (searches[i].equals(currentQuery)) {
                action.setChecked(true);
            }
            this.addActionToMenu(this.fMenu, action);
            ++i;
        }
        if (searches.length > 0) {
            new MenuItem(this.fMenu, 2);
            this.addActionToMenu(this.fMenu, new RemoveAllSearchesAction());
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowSearchesAction(this.fSearchView).run();
    }
}

