/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search.internal.ui.text;

import java.text.MessageFormat;
import java.util.HashMap;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.search.internal.ui.SearchMessages;
import org.eclipse.search.internal.ui.SearchPlugin;
import org.eclipse.search.internal.ui.text.EditorOpener;
import org.eclipse.search.internal.ui.text.FileContentProvider;
import org.eclipse.search.internal.ui.text.FileLabelProvider;
import org.eclipse.search.internal.ui.text.FileSearchQuery;
import org.eclipse.search.internal.ui.text.FileTableContentProvider;
import org.eclipse.search.internal.ui.text.FileTreeContentProvider;
import org.eclipse.search.internal.ui.text.NameSorter;
import org.eclipse.search.internal.ui.text.NewTextSearchActionGroup;
import org.eclipse.search.internal.ui.text.PathSorter;
import org.eclipse.search.internal.ui.text.ReplaceAction2;
import org.eclipse.search.internal.ui.text.SortAction;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.text.AbstractTextSearchResult;
import org.eclipse.search.ui.text.AbstractTextSearchViewPage;
import org.eclipse.search.ui.text.Match;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.part.IShowInTargetList;
import org.eclipse.ui.texteditor.ITextEditor;

public class FileSearchPage
extends AbstractTextSearchViewPage
implements IAdaptable {
    private static final String KEY_SORTING = "org.eclipse.search.resultpage.sorting";
    private ActionGroup fActionGroup;
    private FileContentProvider fContentProvider;
    private int fCurrentSortOrder;
    private SortAction fSortByNameAction;
    private SortAction fSortByPathAction;
    private EditorOpener fEditorOpener = new EditorOpener();
    private static final String[] SHOW_IN_TARGETS = new String[]{"org.eclipse.ui.views.ResourceNavigator"};
    private static final IShowInTargetList SHOW_IN_TARGET_LIST = new IShowInTargetList(){

        public String[] getShowInTargetIds() {
            return SHOW_IN_TARGETS;
        }
    };
    private IPropertyChangeListener fPropertyChangeListener;
    static /* synthetic */ Class class$0;

    public FileSearchPage() {
        this.fSortByNameAction = new SortAction(SearchMessages.getString("FileSearchPage.sort_name.label"), this, 2);
        this.fSortByPathAction = new SortAction(SearchMessages.getString("FileSearchPage.sort_path.label"), this, 3);
        this.fPropertyChangeListener = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (("org.eclipse.search.limitTable".equals(event.getProperty()) || "org.eclipse.search.limitTableTo".equals(event.getProperty())) && FileSearchPage.this.getViewer() instanceof TableViewer) {
                    FileSearchPage.this.getViewPart().updateLabel();
                    FileSearchPage.this.getViewer().refresh();
                }
            }
        };
        SearchPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.fPropertyChangeListener);
    }

    public StructuredViewer getViewer() {
        return super.getViewer();
    }

    protected void configureTableViewer(TableViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new FileLabelProvider(this, 1), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTableContentProvider(this));
        this.setSortOrder(this.fCurrentSortOrder);
        this.fContentProvider = (FileContentProvider)viewer.getContentProvider();
    }

    protected void configureTreeViewer(TreeViewer viewer) {
        viewer.setUseHashlookup(true);
        viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new FileLabelProvider(this, 1), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        viewer.setContentProvider((IContentProvider)new FileTreeContentProvider((AbstractTreeViewer)viewer));
        this.fContentProvider = (FileContentProvider)viewer.getContentProvider();
    }

    protected void showMatch(Match match, int offset, int length, boolean activate) throws PartInitException {
        IFile file = (IFile)match.getElement();
        IEditorPart editor = this.fEditorOpener.open(match);
        if (editor != null && activate) {
            editor.getEditorSite().getPage().activate((IWorkbenchPart)editor);
        }
        if (editor instanceof ITextEditor) {
            ITextEditor textEditor = (ITextEditor)editor;
            textEditor.selectAndReveal(offset, length);
        } else if (editor != null) {
            this.showWithMarker(editor, file, offset, length);
        }
    }

    private void showWithMarker(IEditorPart editor, IFile file, int offset, int length) throws PartInitException {
        try {
            IMarker marker = file.createMarker("org.eclipse.search.searchmarker");
            HashMap<String, Integer> attributes = new HashMap<String, Integer>(4);
            attributes.put("charStart", new Integer(offset));
            attributes.put("charEnd", new Integer(offset + length));
            marker.setAttributes(attributes);
            IDE.gotoMarker((IEditorPart)editor, (IMarker)marker);
            marker.delete();
        }
        catch (CoreException e) {
            throw new PartInitException(SearchMessages.getString("FileSearchPage.error.marker"), (Throwable)e);
        }
    }

    protected void fillContextMenu(IMenuManager mgr) {
        super.fillContextMenu(mgr);
        this.addSortActions(mgr);
        this.fActionGroup.setContext(new ActionContext(this.getSite().getSelectionProvider().getSelection()));
        this.fActionGroup.fillContextMenu(mgr);
        FileSearchQuery query = (FileSearchQuery)this.getInput().getQuery();
        if (!"".equals(query.getSearchString())) {
            ReplaceAction2 replaceAll;
            ReplaceAction2 replaceAction = new ReplaceAction2(this, (IStructuredSelection)this.getViewer().getSelection());
            if (replaceAction.isEnabled()) {
                mgr.appendToGroup("group.reorganize", (IAction)replaceAction);
            }
            if ((replaceAll = new ReplaceAction2(this)).isEnabled()) {
                mgr.appendToGroup("group.reorganize", (IAction)replaceAll);
            }
        }
    }

    private void addSortActions(IMenuManager mgr) {
        if (this.getLayout() != 1) {
            return;
        }
        MenuManager sortMenu = new MenuManager(SearchMessages.getString("FileSearchPage.sort_by.label"));
        sortMenu.add((IAction)this.fSortByNameAction);
        sortMenu.add((IAction)this.fSortByPathAction);
        this.fSortByNameAction.setChecked(this.fCurrentSortOrder == this.fSortByNameAction.getSortOrder());
        this.fSortByPathAction.setChecked(this.fCurrentSortOrder == this.fSortByPathAction.getSortOrder());
        mgr.appendToGroup("group.viewerSetup", (IContributionItem)sortMenu);
    }

    public void setViewPart(ISearchResultViewPart part) {
        super.setViewPart(part);
        this.fActionGroup = new NewTextSearchActionGroup(part);
    }

    public void dispose() {
        this.fActionGroup.dispose();
        SearchPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.fPropertyChangeListener);
        super.dispose();
    }

    protected void elementsChanged(Object[] objects) {
        if (this.fContentProvider != null) {
            this.fContentProvider.elementsChanged(objects);
        }
    }

    protected void clear() {
        if (this.fContentProvider != null) {
            this.fContentProvider.clear();
        }
    }

    public void setSortOrder(int sortOrder) {
        this.fCurrentSortOrder = sortOrder;
        StructuredViewer viewer = this.getViewer();
        DecoratingLabelProvider lpWrapper = (DecoratingLabelProvider)viewer.getLabelProvider();
        ((FileLabelProvider)lpWrapper.getLabelProvider()).setOrder(sortOrder);
        if (sortOrder == 2) {
            viewer.setSorter((ViewerSorter)new NameSorter());
        } else {
            viewer.setSorter((ViewerSorter)new PathSorter());
        }
        this.getSettings().put(KEY_SORTING, this.fCurrentSortOrder);
    }

    public void restoreState(IMemento memento) {
        Integer value;
        super.restoreState(memento);
        try {
            this.fCurrentSortOrder = this.getSettings().getInt(KEY_SORTING);
        }
        catch (NumberFormatException numberFormatException) {
            this.fCurrentSortOrder = this.fSortByNameAction.getSortOrder();
        }
        if (memento != null && (value = memento.getInteger(KEY_SORTING)) != null) {
            this.fCurrentSortOrder = value;
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putInteger(KEY_SORTING, this.fCurrentSortOrder);
    }

    public Object getAdapter(Class adapter) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.part.IShowInTargetList");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(adapter)) {
            return SHOW_IN_TARGET_LIST;
        }
        return null;
    }

    public String getLabel() {
        String label = super.getLabel();
        StructuredViewer viewer = this.getViewer();
        if (viewer instanceof TableViewer) {
            int fileCount;
            int itemCount;
            TableViewer tv = (TableViewer)viewer;
            AbstractTextSearchResult result = this.getInput();
            if (result != null && (itemCount = ((IStructuredContentProvider)tv.getContentProvider()).getElements((Object)this.getInput()).length) < (fileCount = this.getInput().getElements().length)) {
                String format = SearchMessages.getString("FileSearchPage.limited.format");
                return MessageFormat.format(format, label, new Integer(itemCount), new Integer(fileCount));
            }
        }
        return label;
    }
}

