/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.junit.refactoring;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.junit.refactoring.JUnitRenameParticipant;
import org.eclipse.jdt.internal.junit.refactoring.LaunchConfigTypeChange;
import org.eclipse.jdt.internal.junit.ui.JUnitMessages;
import org.eclipse.jdt.internal.junit.util.TestSearchEngine;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;

public class TypeRenameParticipant
extends JUnitRenameParticipant {
    private IType fType;

    protected boolean initialize(Object element) {
        this.fType = (IType)element;
        try {
            return TestSearchEngine.isTestOrTestSuite(this.fType);
        }
        catch (JavaModelException javaModelException) {
            return false;
        }
    }

    public String getName() {
        return JUnitMessages.getString("TypeRenameParticipant.name");
    }

    protected void createChangeForConfigs(List changes, ILaunchConfiguration[] configs) throws CoreException {
        String typeName = this.fType.getFullyQualifiedName();
        int i = 0;
        while (i < configs.length) {
            String mainType = configs[i].getAttribute(IJavaLaunchConfigurationConstants.ATTR_MAIN_TYPE_NAME, null);
            if (typeName.equals(mainType)) {
                changes.add(new LaunchConfigTypeChange(this.fType, configs[i], this.getArguments().getNewName()));
            }
            ++i;
        }
    }
}

