/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff.compare.rangedifferencer;

import java.util.List;
import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.internal.texteditor.quickdiff.DiffRegion;

public class RangeDifference {
    public static final int NOCHANGE = 0;
    public static final int CHANGE = 2;
    public static final int CONFLICT = 1;
    public static final int RIGHT = 2;
    public static final int LEFT = 3;
    public static final int ANCESTOR = 4;
    public static final int ERROR = 5;
    int fKind;
    int fLeftStart;
    int fLeftLength;
    int fRightStart;
    int fRightLength;
    int lAncestorStart;
    int lAncestorLength;
    private DiffRegion fRegion;

    public RangeDifference(int changeKind) {
        this.fKind = changeKind;
    }

    public RangeDifference(int kind, int rightStart, int rightLength, int leftStart, int leftLength) {
        this.fKind = kind;
        this.fRightStart = rightStart;
        this.fRightLength = rightLength;
        this.fLeftStart = leftStart;
        this.fLeftLength = leftLength;
    }

    public RangeDifference(int kind, int rightStart, int rightLength, int leftStart, int leftLength, int ancestorStart, int ancestorLength) {
        this(kind, rightStart, rightLength, leftStart, leftLength);
        this.lAncestorStart = ancestorStart;
        this.lAncestorLength = ancestorLength;
    }

    public int kind() {
        return this.fKind;
    }

    public int ancestorStart() {
        return this.lAncestorStart;
    }

    public int ancestorLength() {
        return this.lAncestorLength;
    }

    public int ancestorEnd() {
        return this.lAncestorStart + this.lAncestorLength;
    }

    public int rightStart() {
        return this.fRightStart;
    }

    public int rightLength() {
        return this.fRightLength;
    }

    public int rightEnd() {
        return this.fRightStart + this.fRightLength;
    }

    public int leftStart() {
        return this.fLeftStart;
    }

    public int leftLength() {
        return this.fLeftLength;
    }

    public int leftEnd() {
        return this.fLeftStart + this.fLeftLength;
    }

    public int maxLength() {
        return Math.max(this.fRightLength, Math.max(this.fLeftLength, this.lAncestorLength));
    }

    public void shiftLeft(int shift) {
        Assert.isTrue((shift + this.fLeftStart >= 0 ? 1 : 0) != 0);
        this.fLeftStart += shift;
    }

    public void shiftRight(int shift) {
        Assert.isTrue((shift + this.fRightStart >= 0 ? 1 : 0) != 0);
        this.fRightStart += shift;
    }

    public void extendStart(int shift) {
        Assert.isTrue((shift + this.fRightStart >= 0 ? 1 : 0) != 0);
        Assert.isTrue((shift + this.fLeftStart >= 0 ? 1 : 0) != 0);
        this.fRightStart += shift;
        this.fRightLength -= shift;
        this.fLeftStart += shift;
        this.fLeftLength -= shift;
    }

    public void extendEnd(int shift) {
        Assert.isTrue((shift + this.fRightLength >= 0 ? 1 : 0) != 0);
        Assert.isTrue((shift + this.fLeftLength >= 0 ? 1 : 0) != 0);
        this.fRightLength += shift;
        this.fLeftLength += shift;
    }

    public boolean equals(Object obj) {
        if (obj instanceof RangeDifference) {
            RangeDifference d = (RangeDifference)obj;
            return this.fKind == d.fKind && this.fRightStart == d.fRightStart && this.fRightLength == d.fRightLength && this.fLeftStart == d.fLeftStart && this.fLeftLength == d.fLeftLength;
        }
        return false;
    }

    public DiffRegion getDiffRegion(List differences, IDocument source) {
        if (this.fRegion == null) {
            this.fRegion = new DiffRegion(this, 0, differences, source);
        }
        return this.fRegion;
    }
}

