/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.operations;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.InstallConfiguration;
import org.eclipse.update.internal.operations.OperationFactory;
import org.eclipse.update.internal.operations.OperationValidator;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.operations.IFeatureOperation;
import org.eclipse.update.operations.IInstallFeatureOperation;
import org.eclipse.update.operations.IOperation;
import org.eclipse.update.operations.IOperationFactory;
import org.eclipse.update.operations.IOperationValidator;
import org.eclipse.update.operations.IUpdateModelChangedListener;

public class OperationsManager {
    private static IOperationValidator validator;
    private static IOperationFactory operationFactory;
    private static Vector listeners;
    private static Vector pendingOperations;
    private static boolean inProgress;

    static {
        listeners = new Vector();
        pendingOperations = new Vector();
    }

    private OperationsManager() {
    }

    public static IOperationFactory getOperationFactory() {
        if (operationFactory == null) {
            operationFactory = new OperationFactory();
        }
        return operationFactory;
    }

    public static IFeatureOperation findPendingOperation(IFeature feature) {
        int i = 0;
        while (i < pendingOperations.size()) {
            IFeatureOperation operation = (IFeatureOperation)pendingOperations.elementAt(i);
            if (operation.getFeature().equals(feature)) {
                return operation;
            }
            ++i;
        }
        return null;
    }

    public static void addPendingOperation(IOperation operation) {
        pendingOperations.add(operation);
    }

    public static void removePendingOperation(IOperation operation) {
        pendingOperations.remove(operation);
    }

    public static void addUpdateModelChangedListener(IUpdateModelChangedListener listener) {
        if (!listeners.contains(listener)) {
            listeners.add(listener);
        }
    }

    public static void removeUpdateModelChangedListener(IUpdateModelChangedListener listener) {
        if (listeners.contains(listener)) {
            listeners.remove(listener);
        }
    }

    public static void fireObjectsAdded(Object parent, Object[] children) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectsAdded(parent, children);
        }
    }

    public static void fireObjectsRemoved(Object parent, Object[] children) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectsRemoved(parent, children);
        }
    }

    public static void fireObjectChanged(Object object, String property) {
        Iterator iter = listeners.iterator();
        while (iter.hasNext()) {
            IUpdateModelChangedListener listener = (IUpdateModelChangedListener)iter.next();
            listener.objectChanged(object, property);
        }
    }

    public static boolean hasSelectedJobsWithLicenses(IInstallFeatureOperation[] jobs) {
        int i = 0;
        while (i < jobs.length) {
            if (UpdateUtils.hasLicense(jobs[i].getFeature())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean hasSelectedJobsWithOptionalFeatures(IInstallFeatureOperation[] jobs) {
        int i = 0;
        while (i < jobs.length) {
            if (UpdateUtils.hasOptionalFeatures(jobs[i].getFeature())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static IInstallFeatureOperation[] getSelectedJobsWithLicenses(IInstallFeatureOperation[] jobs) {
        ArrayList<IInstallFeatureOperation> list = new ArrayList<IInstallFeatureOperation>();
        int i = 0;
        while (i < jobs.length) {
            if (UpdateUtils.hasLicense(jobs[i].getFeature())) {
                list.add(jobs[i]);
            }
            ++i;
        }
        return list.toArray(new IInstallFeatureOperation[list.size()]);
    }

    public static IInstallFeatureOperation[] getSelectedJobsWithOptionalFeatures(IInstallFeatureOperation[] jobs) {
        ArrayList<IInstallFeatureOperation> list = new ArrayList<IInstallFeatureOperation>();
        int i = 0;
        while (i < jobs.length) {
            if (UpdateUtils.hasOptionalFeatures(jobs[i].getFeature())) {
                list.add(jobs[i]);
            }
            ++i;
        }
        return list.toArray(new IInstallFeatureOperation[list.size()]);
    }

    public static synchronized void setInProgress(boolean inProgress) {
        OperationsManager.inProgress = inProgress;
    }

    public static synchronized boolean isInProgress() {
        return inProgress;
    }

    public static IOperationValidator getValidator() {
        if (validator == null) {
            validator = new OperationValidator();
        }
        return validator;
    }

    public static void setValidator(IOperationValidator validator) {
        OperationsManager.validator = validator;
    }

    public static void applyChangesNow() {
        InstallConfiguration.applyChanges();
    }
}

