/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core.plugin;

import org.eclipse.core.runtime.PlatformObject;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.internal.core.PDECore;

public class PluginReference
extends PlatformObject {
    private String id;
    private transient IPlugin plugin;

    public PluginReference() {
    }

    public PluginReference(String id) {
        this.id = id;
        if (id != null) {
            this.plugin = PDECore.getDefault().findPlugin(id);
        }
    }

    public PluginReference(IPlugin plugin) {
        this.id = plugin.getId();
        this.plugin = plugin;
    }

    public String getId() {
        return this.id;
    }

    public IPlugin getPlugin() {
        if (this.plugin == null && this.id != null) {
            this.plugin = PDECore.getDefault().findPlugin(this.id);
        }
        return this.plugin;
    }

    public String toString() {
        if (this.plugin != null) {
            return this.plugin.getTranslatedName();
        }
        return this.id != null ? this.id : "?";
    }

    public boolean isResolved() {
        return this.plugin != null;
    }
}

