/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.TreeMap;
import java.util.Vector;
import org.eclipse.core.boot.BootLoader;
import org.eclipse.core.boot.IPlatformConfiguration;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.IEnvironmentVariables;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.PlatformConfiguration;
import org.eclipse.pde.internal.core.PluginModelManager;
import org.eclipse.pde.internal.core.bundle.BundlePluginModelBase;
import org.eclipse.pde.internal.core.feature.ExternalFeatureModel;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;

public class TargetPlatform
implements IEnvironmentVariables {
    private static final String BOOT_ID = "org.eclipse.core.boot";

    public static File createPropertiesFile() throws CoreException {
        return TargetPlatform.createPropertiesFile(TargetPlatform.getVisibleModels(), null);
    }

    public static String[] createPluginPath() throws CoreException {
        return TargetPlatform.createPluginPath(TargetPlatform.getVisibleModels());
    }

    public static String[] createPluginPath(IPluginModelBase[] models) throws CoreException {
        String[] paths = new String[models.length];
        int i = 0;
        while (i < models.length) {
            IPluginModelBase model = models[i];
            paths[i] = TargetPlatform.createURL(model);
            ++i;
        }
        return paths;
    }

    private static IPluginModelBase[] getVisibleModels() {
        Vector result = new Vector();
        PluginModelManager manager = PDECore.getDefault().getModelManager();
        TargetPlatform.addFromList(result, manager.getPlugins());
        IPluginModelBase[] array = result.toArray(new IPluginModelBase[result.size()]);
        return array;
    }

    private static void addFromList(Vector result, IPluginModelBase[] list) {
        int i = 0;
        while (i < list.length) {
            IPluginModelBase model = list[i];
            if (model.isEnabled()) {
                result.add(list[i]);
            }
            ++i;
        }
    }

    /*
     * Exception decompiling
     */
    public static File createPropertiesFile(IPluginModelBase[] plugins, IPath data) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [1 : 180->183)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void createPlatformConfigurationArea(TreeMap pluginMap, File configDir, String primaryFeatureId, HashMap autoStartPlugins) throws CoreException {
        try {
            if (PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                TargetPlatform.createConfigIniFile(configDir, pluginMap, primaryFeatureId, autoStartPlugins);
                if (pluginMap.containsKey("org.eclipse.update.configurator")) {
                    TargetPlatform.savePlatformConfiguration(BootLoader.getPlatformConfiguration(null), configDir, pluginMap, primaryFeatureId);
                }
            } else {
                TargetPlatform.savePlatformConfiguration(new PlatformConfiguration(null), new File(configDir, "platform.cfg"), pluginMap, primaryFeatureId);
            }
        }
        catch (CoreException e) {
            throw e;
        }
        catch (Exception e) {
            String message = e.getMessage();
            if (message == null || message.length() == 0) {
                message = PDECore.getResourceString("TargetPlatform.exceptionThrown");
            }
            throw new CoreException((IStatus)new Status(4, PDECore.getPluginId(), 4, message, (Throwable)e));
        }
    }

    private static void createConfigIniFile(File configDir, TreeMap pluginMap, String primaryFeatureId, HashMap autoStartPlugins) {
        if (!configDir.exists()) {
            configDir.mkdirs();
        }
        File file = new File(configDir, "config.ini");
        try {
            String url;
            String id;
            Properties properties = new Properties();
            properties.put("osgi.install.area", "file:" + ExternalModelManager.getEclipseHome().toString());
            if (primaryFeatureId != null) {
                int index;
                String splashPath = TargetPlatform.getBundleURL(primaryFeatureId, pluginMap);
                if (splashPath == null && (index = primaryFeatureId.lastIndexOf(46)) != -1) {
                    id = primaryFeatureId.substring(0, index);
                    splashPath = TargetPlatform.getBundleURL(id, pluginMap);
                }
                if (splashPath != null) {
                    properties.put("osgi.splashPath", splashPath);
                }
            }
            properties.put("osgi.configuration.cascaded", "false");
            properties.put("osgi.framework", TargetPlatform.getBundleURL("org.eclipse.osgi", pluginMap));
            Iterator iter = autoStartPlugins.keySet().iterator();
            StringBuffer buffer = new StringBuffer();
            while (iter.hasNext()) {
                id = iter.next().toString();
                url = TargetPlatform.getBundleURL(id, pluginMap);
                if (url == null) continue;
                buffer.append("reference:" + url);
                Integer integer = (Integer)autoStartPlugins.get(id);
                if (integer > 0) {
                    buffer.append("@" + integer + ":start");
                }
                if (!iter.hasNext()) continue;
                buffer.append(",");
            }
            if (!autoStartPlugins.containsKey("org.eclipse.update.configurator") || !pluginMap.containsKey("org.eclipse.update.configurator")) {
                iter = pluginMap.keySet().iterator();
                while (iter.hasNext()) {
                    id = iter.next().toString();
                    if ("org.eclipse.osgi".equals(id) || autoStartPlugins.containsKey(id) || (url = TargetPlatform.getBundleURL(id, pluginMap)) == null) continue;
                    if (buffer.length() > 0) {
                        buffer.append(",");
                    }
                    buffer.append("reference:" + url);
                }
            }
            if (buffer.length() > 0) {
                properties.put("osgi.bundles", buffer.toString());
            }
            properties.put("osgi.bundles.defaultStartLevel", "4");
            FileOutputStream stream = new FileOutputStream(file);
            properties.store(stream, "Eclipse Runtime Configuration File");
            stream.flush();
            stream.close();
        }
        catch (IOException e) {
            PDECore.logException(e);
        }
    }

    private static String getBundleURL(String id, TreeMap pluginMap) {
        IPluginModelBase model = (IPluginModelBase)pluginMap.get(id);
        if (model == null) {
            return null;
        }
        String location = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            location = model instanceof IBundlePluginModelBase ? resource.getLocation().removeLastSegments(2).toString() : resource.getLocation().removeLastSegments(1).toString();
        }
        return "file:" + new Path(location).addTrailingSeparator().toString();
    }

    private static void savePlatformConfiguration(IPlatformConfiguration platformConfiguration, File configFile, TreeMap pluginMap, String primaryFeatureId) throws IOException, CoreException, MalformedURLException {
        PluginVersionIdentifier bootVid;
        PluginVersionIdentifier breakVid;
        String version;
        ArrayList sites = new ArrayList();
        Iterator iter = pluginMap.values().iterator();
        while (iter.hasNext()) {
            IPluginModelBase model = (IPluginModelBase)iter.next();
            IPath sitePath = TargetPlatform.getTransientSitePath(model);
            TargetPlatform.addToSite(sitePath, model, sites);
        }
        IPluginModelBase bootModel = (IPluginModelBase)pluginMap.get(BOOT_ID);
        URL configURL = new URL("file:" + configFile.getPath());
        TargetPlatform.createConfigurationEntries(platformConfiguration, bootModel, sites);
        TargetPlatform.createFeatureEntries(platformConfiguration, pluginMap, primaryFeatureId);
        platformConfiguration.refresh();
        platformConfiguration.save(configURL);
        if (bootModel != null && (version = bootModel.getPluginBase().getVersion()) != null && (breakVid = new PluginVersionIdentifier("2.0.3")).isGreaterThan(bootVid = new PluginVersionIdentifier(version))) {
            TargetPlatform.repairConfigurationVersion(configURL);
        }
    }

    private static IPath getTransientSitePath(IPluginModelBase model) {
        IResource resource;
        boolean bundle = false;
        if (model instanceof BundlePluginModelBase) {
            bundle = true;
        }
        if ((resource = model.getUnderlyingResource()) != null) {
            IPath realPath = resource.getLocation();
            return realPath.removeLastSegments(bundle ? 4 : 3);
        }
        Path path = new Path(model.getInstallLocation());
        return path.removeLastSegments(2);
    }

    private static void repairConfigurationVersion(URL url) throws IOException {
        File file = new File(url.getFile());
        if (file.exists()) {
            Properties p = new Properties();
            FileInputStream fis = new FileInputStream(file);
            p.load(fis);
            p.setProperty("version", "1.0");
            fis.close();
            FileOutputStream fos = new FileOutputStream(file);
            p.store(fos, new Date().toString());
            fos.close();
        }
    }

    private static void addToSite(IPath path, IPluginModelBase model, ArrayList sites) {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            if (localSite.getPath().equals((Object)path)) {
                localSite.add(model);
                return;
            }
            ++i;
        }
        LocalSite localSite = new LocalSite(path);
        localSite.add(model);
        sites.add(localSite);
    }

    private static void createConfigurationEntries(IPlatformConfiguration config, IPluginModelBase bootModel, ArrayList sites) throws CoreException, MalformedURLException {
        int i = 0;
        while (i < sites.size()) {
            LocalSite localSite = (LocalSite)sites.get(i);
            String[] plugins = localSite.getRelativePluginList();
            int policy = 0;
            IPlatformConfiguration.ISitePolicy sitePolicy = config.createSitePolicy(policy, plugins);
            IPlatformConfiguration.ISiteEntry siteEntry = config.createSiteEntry(localSite.getURL(), sitePolicy);
            config.configureSite(siteEntry);
            ++i;
        }
        if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
            IPath bootPath = TargetPlatform.getPluginLocation(bootModel);
            URL bootURL = new URL("file:" + bootPath.toOSString());
            config.setBootstrapPluginLocation(BOOT_ID, bootURL);
        }
        config.isTransient(true);
    }

    private static IPath getPluginLocation(IPluginModelBase model) {
        String location = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            location = model instanceof IBundlePluginModelBase ? resource.getLocation().removeLastSegments(2).toOSString() : resource.getLocation().removeLastSegments(1).toOSString();
        }
        return new Path(location).addTrailingSeparator();
    }

    private static void createFeatureEntries(IPlatformConfiguration config, TreeMap pluginMap, String primaryFeatureId) throws MalformedURLException {
        IPath targetPath = ExternalModelManager.getEclipseHome();
        if (primaryFeatureId == null) {
            return;
        }
        IFeatureModel featureModel = TargetPlatform.loadPrimaryFeatureModel(targetPath, primaryFeatureId);
        if (featureModel == null) {
            return;
        }
        IFeature feature = featureModel.getFeature();
        String featureVersion = feature.getVersion();
        String pluginId = primaryFeatureId;
        IPluginModelBase primaryPlugin = (IPluginModelBase)pluginMap.get(pluginId);
        if (primaryPlugin == null) {
            return;
        }
        IPath pluginPath = TargetPlatform.getPluginLocation(primaryPlugin);
        URL pluginURL = new URL("file:" + pluginPath.toString());
        URL[] root = new URL[]{pluginURL};
        IPlatformConfiguration.IFeatureEntry featureEntry = config.createFeatureEntry(primaryFeatureId, featureVersion, pluginId, primaryPlugin.getPluginBase().getVersion(), true, null, root);
        config.configureFeatureEntry(featureEntry);
        featureModel.dispose();
    }

    private static IFeatureModel loadPrimaryFeatureModel(IPath targetPath, String featureId) {
        File mainFeatureDir = targetPath.append("features").toFile();
        if (!mainFeatureDir.exists() || !mainFeatureDir.isDirectory()) {
            return null;
        }
        File[] featureDirs = mainFeatureDir.listFiles();
        PluginVersionIdentifier bestVid = null;
        File bestDir = null;
        int i = 0;
        while (i < featureDirs.length) {
            int loc;
            File featureDir = featureDirs[i];
            String name = featureDir.getName();
            if (featureDir.isDirectory() && name.startsWith(featureId) && (loc = name.lastIndexOf("_")) != -1) {
                String version = name.substring(loc + 1);
                PluginVersionIdentifier vid = new PluginVersionIdentifier(version);
                if (bestVid == null || vid.isGreaterThan(bestVid)) {
                    bestVid = vid;
                    bestDir = featureDir;
                }
            }
            ++i;
        }
        if (bestVid == null) {
            return null;
        }
        File manifest = new File(bestDir, "feature.xml");
        ExternalFeatureModel model = new ExternalFeatureModel();
        model.setInstallLocation(bestDir.getAbsolutePath());
        FileInputStream stream = null;
        boolean error = false;
        try {
            stream = new FileInputStream(manifest);
            model.load(stream, false);
        }
        catch (Exception exception) {
            error = true;
        }
        if (stream != null) {
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        if (error || !model.isLoaded()) {
            return null;
        }
        return model;
    }

    private static String getKey(IPluginModelBase model) {
        if (model.isLoaded()) {
            return model.getPluginBase().getId();
        }
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            return resource.getProject().getName();
        }
        return model.getInstallLocation();
    }

    private static String createDataSuffix(IPath data) {
        if (data == null) {
            return "";
        }
        String suffix = data.toOSString();
        suffix = suffix.replace(File.separatorChar, '_');
        return suffix.replace(':', '_');
    }

    private static String createURL(IPluginModelBase model) {
        return TargetPlatform.getPluginLocation(model).addTrailingSeparator().toString();
    }

    public static String getOS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.os");
    }

    public static String getWS() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.ws");
    }

    public static String getNL() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.nl");
    }

    public static String getOSArch() {
        return TargetPlatform.getProperty("org.eclipse.pde.ui.arch");
    }

    private static String getProperty(String key) {
        return PDECore.getDefault().getPluginPreferences().getString(key);
    }

    private static Choice[] getKnownChoices(String[] values) {
        Choice[] choices = new Choice[values.length];
        int i = 0;
        while (i < choices.length) {
            choices[i] = new Choice(values[i], values[i]);
            ++i;
        }
        return choices;
    }

    public static Choice[] getOSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSValues());
    }

    public static Choice[] getWSChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownWSValues());
    }

    public static Choice[] getNLChoices() {
        Locale[] locales = Locale.getAvailableLocales();
        Choice[] choices = new Choice[locales.length];
        int i = 0;
        while (i < locales.length) {
            Locale locale = locales[i];
            choices[i] = new Choice(locale.toString(), String.valueOf(locale.toString()) + " - " + locale.getDisplayName());
            ++i;
        }
        return choices;
    }

    public static Choice[] getArchChoices() {
        return TargetPlatform.getKnownChoices(BootLoader.knownOSArchValues());
    }

    static class LocalSite {
        private ArrayList plugins;
        private IPath path;

        public LocalSite(IPath path) {
            this.path = path;
            this.plugins = new ArrayList();
        }

        public IPath getPath() {
            return this.path;
        }

        public URL getURL() throws MalformedURLException {
            return new URL("file:" + this.path.addTrailingSeparator().toString());
        }

        public void add(IPluginModelBase model) {
            this.plugins.add(model);
        }

        public String[] getRelativePluginList() {
            String[] list = new String[this.plugins.size()];
            int i = 0;
            while (i < this.plugins.size()) {
                IPluginModelBase model = (IPluginModelBase)this.plugins.get(i);
                IPath location = TargetPlatform.getPluginLocation(model);
                if (location.segmentCount() > 2) {
                    location = location.removeFirstSegments(location.segmentCount() - 2);
                }
                if (!PDECore.getDefault().getModelManager().isOSGiRuntime()) {
                    location = location.append(model.isFragmentModel() ? "fragment.xml" : "plugin.xml");
                }
                list[i] = location.setDevice(null).makeRelative().toString();
                ++i;
            }
            return list;
        }
    }
}

