/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Properties;
import org.eclipse.core.runtime.Path;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.update.configurator.ConfiguratorUtils;
import org.eclipse.update.configurator.IPlatformConfiguration;

public class PluginPathFinder {
    private static String getPath(String platformHome, File file) {
        String prefix = new Path(platformHome).removeLastSegments(1).toString();
        Properties properties = new Properties();
        try {
            FileInputStream fis = new FileInputStream(file);
            properties.load(fis);
            fis.close();
            String path = properties.getProperty("path");
            if (path != null) {
                if (!new Path(path).isAbsolute()) {
                    path = String.valueOf(prefix) + '/' + path;
                }
                if (new File(path = String.valueOf(path) + "/eclipse/plugins").exists()) {
                    return path;
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    private static File[] getSites(String platformHome) {
        ArrayList<File> sites = new ArrayList<File>();
        sites.add(new File(platformHome, "plugins"));
        File[] linkFiles = new File(String.valueOf(platformHome) + '/' + "links").listFiles();
        if (linkFiles != null) {
            int i = 0;
            while (i < linkFiles.length) {
                String path = PluginPathFinder.getPath(platformHome, linkFiles[i]);
                if (path != null) {
                    sites.add(new File(path));
                }
                ++i;
            }
        }
        return sites.toArray(new File[sites.size()]);
    }

    public static URL[] getPluginPaths(String platformHome) {
        if (ExternalModelManager.isTargetEqualToHost(platformHome) && !PDECore.isDevLaunchMode()) {
            return ConfiguratorUtils.getCurrentPlatformConfiguration().getPluginPath();
        }
        File file = new File(platformHome, "configuration/org.eclipse.update/platform.xml");
        if (file.exists()) {
            try {
                IPlatformConfiguration config = ConfiguratorUtils.getPlatformConfiguration((URL)file.toURL());
                return PluginPathFinder.getConfiguredSites(platformHome, config);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return PluginPathFinder.scanLocations(PluginPathFinder.getSites(platformHome));
    }

    private static URL[] getConfiguredSites(String platformHome, IPlatformConfiguration configuration) {
        URL[] installPlugins = PluginPathFinder.scanLocations(new File[]{new File(platformHome, "plugins")});
        URL[] extensionPlugins = PluginPathFinder.getExtensionURLs(configuration);
        URL[] all = new URL[installPlugins.length + extensionPlugins.length];
        System.arraycopy(installPlugins, 0, all, 0, installPlugins.length);
        System.arraycopy(extensionPlugins, 0, all, installPlugins.length, extensionPlugins.length);
        return all;
    }

    private static URL[] getExtensionURLs(IPlatformConfiguration config) {
        ArrayList<URL> extensionPlugins = new ArrayList<URL>();
        IPlatformConfiguration.ISiteEntry[] sites = config.getConfiguredSites();
        int i = 0;
        while (i < sites.length) {
            URL url = sites[i].getURL();
            if ("file".equalsIgnoreCase(url.getProtocol())) {
                String[] plugins = sites[i].getPlugins();
                int j = 0;
                while (j < plugins.length) {
                    try {
                        extensionPlugins.add(new File(url.getFile(), plugins[j]).toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++j;
                }
            }
            ++i;
        }
        return extensionPlugins.toArray(new URL[extensionPlugins.size()]);
    }

    public static URL[] scanLocations(File[] sites) {
        ArrayList<URL> result = new ArrayList<URL>();
        int i = 0;
        while (i < sites.length) {
            File[] children;
            if (sites[i].exists() && (children = sites[i].listFiles()) != null) {
                int j = 0;
                while (j < children.length) {
                    try {
                        result.add(children[j].toURL());
                    }
                    catch (MalformedURLException malformedURLException) {}
                    ++j;
                }
            }
            ++i;
        }
        return result.toArray(new URL[result.size()]);
    }
}

