/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.expressions;

import org.eclipse.core.expressions.ElementHandler;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.internal.expressions.Assert;
import org.eclipse.core.internal.expressions.CompositeExpression;
import org.eclipse.core.internal.expressions.ExpressionMessages;
import org.eclipse.core.internal.expressions.ExpressionPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public final class ExpressionConverter {
    private ElementHandler[] fHandlers;
    private static final ExpressionConverter INSTANCE = new ExpressionConverter(new ElementHandler[]{ElementHandler.getDefault()});

    public static ExpressionConverter getDefault() {
        return INSTANCE;
    }

    public ExpressionConverter(ElementHandler[] handlers) {
        Assert.isNotNull(handlers);
        this.fHandlers = handlers;
    }

    public Expression perform(IConfigurationElement root) throws CoreException {
        int i = 0;
        while (i < this.fHandlers.length) {
            ElementHandler handler = this.fHandlers[i];
            Expression result = handler.create(this, root);
            if (result != null) {
                return result;
            }
            ++i;
        }
        return null;
    }

    void processChildren(IConfigurationElement element, CompositeExpression result) throws CoreException {
        IConfigurationElement[] children = element.getChildren();
        if (children != null) {
            int i = 0;
            while (i < children.length) {
                Expression child = this.perform(children[i]);
                if (child == null) {
                    throw new CoreException((IStatus)new Status(4, ExpressionPlugin.getPluginId(), 4, ExpressionMessages.getFormattedString("Expression.unknown_element", children[i].getName()), null));
                }
                result.add(child);
                ++i;
            }
        }
    }
}

