/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.site;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.internal.core.isite.ISite;
import org.eclipse.pde.internal.core.isite.ISiteArchive;
import org.eclipse.pde.internal.core.isite.ISiteBuild;
import org.eclipse.pde.internal.core.isite.ISiteBuildFeature;
import org.eclipse.pde.internal.core.isite.ISiteBuildModel;
import org.eclipse.pde.internal.core.isite.ISiteCategory;
import org.eclipse.pde.internal.core.isite.ISiteCategoryDefinition;
import org.eclipse.pde.internal.core.isite.ISiteFeature;
import org.eclipse.pde.internal.core.isite.ISiteModel;
import org.eclipse.pde.internal.core.isite.ISiteObject;
import org.eclipse.pde.internal.core.site.SiteBuildObject;
import org.eclipse.pde.internal.core.site.SiteObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.site.SiteEditor;

public class SiteUndoManager
extends ModelUndoManager {
    public SiteUndoManager(SiteEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    public void connect(IModelChangeProvider provider) {
        ISiteModel model = (ISiteModel)provider;
        ISiteBuildModel buildModel = model.getBuildModel();
        super.connect(provider);
        super.connect((IModelChangeProvider)buildModel);
    }

    public void disconnect(IModelChangeProvider provider) {
        ISiteModel model = (ISiteModel)provider;
        ISiteBuildModel buildModel = model.getBuildModel();
        super.disconnect(provider);
        super.disconnect((IModelChangeProvider)buildModel);
    }

    protected String getPageId(Object obj) {
        return "features";
    }

    protected void execute(IModelChangedEvent event, boolean undo) {
        IModelChangeProvider model = event.getChangeProvider();
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(model, elements);
                    break;
                }
                this.executeAdd(model, elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(model, elements);
                    break;
                }
                this.executeRemove(model, elements);
                break;
            }
            case 3: {
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(IModelChangeProvider model, Object[] elements) {
        ISiteModel siteModel = model instanceof ISiteModel ? (ISiteModel)model : null;
        ISite site = siteModel != null ? siteModel.getSite() : null;
        ISiteBuild siteBuild = null;
        ISiteBuildModel siteBuildModel = null;
        if (siteModel != null) {
            siteBuildModel = siteModel.getBuildModel();
        } else if (model instanceof ISiteBuildModel) {
            siteBuildModel = (ISiteBuildModel)model;
        }
        if (siteBuildModel != null) {
            siteBuild = siteBuildModel.getSiteBuild();
        }
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.addFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBuildFeature) {
                    siteBuild.addFeatures(new ISiteBuildFeature[]{(ISiteBuildFeature)element});
                } else if (element instanceof ISiteArchive) {
                    site.addArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.addCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteFeature feature = (ISiteFeature)category.getParent();
                    feature.addCategories(new ISiteCategory[]{category});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(IModelChangeProvider model, Object[] elements) {
        ISiteModel siteModel = model instanceof ISiteModel ? (ISiteModel)model : null;
        ISite site = siteModel != null ? siteModel.getSite() : null;
        ISiteBuild siteBuild = null;
        ISiteBuildModel siteBuildModel = null;
        if (siteModel != null) {
            siteBuildModel = siteModel.getBuildModel();
        } else if (model instanceof ISiteBuildModel) {
            siteBuildModel = (ISiteBuildModel)model;
        }
        if (siteBuildModel != null) {
            siteBuild = siteBuildModel.getSiteBuild();
        }
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof ISiteFeature) {
                    site.removeFeatures(new ISiteFeature[]{(ISiteFeature)element});
                } else if (element instanceof ISiteBuildFeature) {
                    siteBuild.removeFeatures(new ISiteBuildFeature[]{(ISiteBuildFeature)element});
                } else if (element instanceof ISiteArchive) {
                    site.removeArchives(new ISiteArchive[]{(ISiteArchive)element});
                } else if (element instanceof ISiteCategoryDefinition) {
                    site.removeCategoryDefinitions(new ISiteCategoryDefinition[]{(ISiteCategoryDefinition)element});
                } else if (element instanceof ISiteCategory) {
                    ISiteCategory category = (ISiteCategory)element;
                    ISiteFeature feature = (ISiteFeature)category.getParent();
                    feature.removeCategories(new ISiteCategory[]{category});
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        SiteObject sobj;
        if (element instanceof SiteObject) {
            sobj = (SiteObject)element;
            try {
                sobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
        if (element instanceof SiteBuildObject) {
            sobj = (SiteBuildObject)element;
            try {
                sobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        ISiteObject obj;
        Object object;
        if (event.getChangeType() == 3 && (object = event.getChangedObjects()[0]) instanceof ISiteObject && !((obj = (ISiteObject)object) instanceof ISite) && !obj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

