/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.plugin;

import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDEDetails;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.pde.internal.ui.search.FindReferencesAction;
import org.eclipse.pde.internal.ui.search.ShowDescriptionAction;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewSchemaFileWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.forms.IFormPart;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ExtensionPointDetails
extends PDEDetails {
    private IPluginExtensionPoint fInput;
    private FormEntry fIdEntry;
    private FormEntry fNameEntry;
    private FormEntry fSchemaEntry;
    private FormText fRichText;
    private String fRichTextData;
    private static final String SCHEMA_RTEXT_DATA = PDEPlugin.getResourceString("ExtensionPointDetails.schemaLinks");
    private static final String NO_SCHEMA_RTEXT_DATA = PDEPlugin.getResourceString("ExtensionPointDetails.noSchemaLinks");

    public String getContextId() {
        return "plugin-context";
    }

    public void fireSaveNeeded() {
        this.markDirty();
        this.getPage().getPDEEditor().fireSaveNeeded(this.getContextId(), false);
    }

    public PDEFormPage getPage() {
        return (PDEFormPage)((Object)this.getManagedForm().getContainer());
    }

    public boolean isEditable() {
        return this.getPage().getPDEEditor().getAggregateModel().isEditable();
    }

    public void createContents(Composite parent) {
        TableWrapLayout layout = new TableWrapLayout();
        layout.topMargin = 0;
        layout.leftMargin = 5;
        layout.rightMargin = 0;
        layout.bottomMargin = 0;
        parent.setLayout((Layout)layout);
        FormToolkit toolkit = this.getManagedForm().getToolkit();
        Section section = toolkit.createSection(parent, 384);
        section.clientVerticalSpacing = 4;
        section.marginHeight = 5;
        section.marginWidth = 5;
        section.setText(PDEPlugin.getResourceString("ExtensionPointDetails.title"));
        section.setDescription(PDEPlugin.getResourceString("ExtensionPointDetails.desc"));
        TableWrapData td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        section.setLayoutData((Object)td);
        Composite client = toolkit.createComposite((Composite)section);
        GridLayout glayout = new GridLayout();
        boolean paintedBorder = toolkit.getBorderStyle() != 2048;
        glayout.marginHeight = 2;
        glayout.marginWidth = 2;
        glayout.numColumns = 3;
        if (paintedBorder) {
            glayout.verticalSpacing = 7;
        }
        client.setLayout((Layout)glayout);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        this.fIdEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionPointDetails.id"), null, false);
        this.fIdEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setId(ExtensionPointDetails.this.fIdEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        this.fNameEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionPointDetails.name"), null, false);
        this.fNameEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setName(ExtensionPointDetails.this.fNameEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
        boolean editable = this.getPage().getModel().isEditable();
        this.fSchemaEntry = new FormEntry(client, toolkit, PDEPlugin.getResourceString("ExtensionPointDetails.schema"), PDEPlugin.getResourceString("ExtensionPointDetails.browse"), editable);
        this.fSchemaEntry.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry entry) {
                if (ExtensionPointDetails.this.fInput != null) {
                    try {
                        ExtensionPointDetails.this.fInput.setSchema(ExtensionPointDetails.this.fSchemaEntry.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                    ExtensionPointDetails.this.updateRichText();
                }
            }

            public void linkActivated(HyperlinkEvent e) {
                IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                if (ExtensionPointDetails.this.fSchemaEntry.getValue() == null || ExtensionPointDetails.this.fSchemaEntry.getValue().length() == 0) {
                    ExtensionPointDetails.this.generateSchema();
                    return;
                }
                IFile file = project.getFile(ExtensionPointDetails.this.fSchemaEntry.getValue());
                if (file.exists()) {
                    ExtensionPointDetails.this.openSchemaFile(file);
                } else {
                    ExtensionPointDetails.this.generateSchema();
                }
            }

            public void browseButtonSelected(FormEntry entry) {
                Object[] elements;
                IProject project = ExtensionPointDetails.this.getPage().getPDEEditor().getCommonProject();
                ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (ILabelProvider)new WorkbenchLabelProvider(), (ITreeContentProvider)new WorkbenchContentProvider());
                dialog.setTitle(PDEPlugin.getResourceString("ManifestEditor.ExtensionPointDetails.schemaLocation.title"));
                dialog.setMessage(PDEPlugin.getResourceString("ManifestEditor.ExtensionPointDetails.schemaLocation.desc"));
                dialog.setDoubleClickSelects(false);
                dialog.setAllowMultiple(false);
                dialog.addFilter(new ViewerFilter(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public boolean select(Viewer viewer, Object parent, Object element) {
                        if (element instanceof IFile) {
                            String ext = ((IFile)element).getFullPath().getFileExtension();
                            return ext.equals("exsd") || ext.equals("mxsd");
                        }
                        if (element instanceof IContainer) {
                            try {
                                IResource[] resources = ((IContainer)element).members();
                                int i = 0;
                                while (i < resources.length) {
                                    if (this.select(viewer, parent, resources[i])) {
                                        return true;
                                    }
                                    ++i;
                                }
                            }
                            catch (CoreException e) {
                                PDEPlugin.logException(e);
                            }
                        }
                        return false;
                    }
                });
                dialog.setValidator(new ISelectionStatusValidator(this){
                    final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public IStatus validate(Object[] selection) {
                        IPluginModelBase model = (IPluginModelBase)3.access$0(this.this$1).getPage().getPDEEditor().getAggregateModel();
                        String pluginName = model.getPluginBase().getId();
                        if (selection == null || selection.length != 1 || !(selection[0] instanceof IFile)) {
                            return new Status(4, pluginName, 4, PDEPlugin.getResourceString("ManifestEditor.ExtensionPointDetails.validate.errorStatus"), null);
                        }
                        IFile file = (IFile)selection[0];
                        String ext = file.getFullPath().getFileExtension();
                        if (ext.equals("exsd") || ext.equals("mxsd")) {
                            return new Status(0, pluginName, 0, "", null);
                        }
                        return new Status(4, pluginName, 4, PDEPlugin.getResourceString("ManifestEditor.ExtensionPointDetails.validate.errorStatus"), null);
                    }
                });
                dialog.setDoubleClickSelects(true);
                dialog.setStatusLineAboveButtons(true);
                dialog.setInput((Object)project);
                dialog.setSorter((ViewerSorter)new ResourceSorter(1));
                String filePath = ExtensionPointDetails.this.fSchemaEntry.getValue();
                if (filePath != null && filePath.length() != 0 && project.exists((IPath)new Path(filePath))) {
                    dialog.setInitialSelection((Object)project.getFile((IPath)new Path(filePath)));
                } else {
                    dialog.setInitialSelection(null);
                }
                if (dialog.open() == 0 && (elements = dialog.getResult()).length > 0) {
                    IResource elem = (IResource)elements[0];
                    ExtensionPointDetails.this.fSchemaEntry.setValue(elem.getProjectRelativePath().toString());
                }
            }

            static /* synthetic */ ExtensionPointDetails access$0(3 var0) {
                return var0.ExtensionPointDetails.this;
            }
        });
        this.createSpacer(toolkit, client, 2);
        this.fRichText = toolkit.createFormText(parent, true);
        td = new TableWrapData(128, 16);
        td.grabHorizontal = true;
        td.indent = 10;
        this.fRichText.setLayoutData((Object)td);
        this.fRichText.setImage("schema", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_SCHEMA_OBJ));
        this.fRichText.setImage("desc", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_DOC_SECTION_OBJ));
        this.fRichText.setImage("search", PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_PSEARCH_OBJ));
        this.fRichText.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                if (e.getHref().equals("search")) {
                    FindReferencesAction pluginReferencesAction = new FindReferencesAction(ExtensionPointDetails.this.fInput);
                    pluginReferencesAction.run();
                } else {
                    ShowDescriptionAction showDescAction = new ShowDescriptionAction(ExtensionPointDetails.this.fInput);
                    showDescAction.run();
                }
            }
        });
        this.fIdEntry.setEditable(this.isEditable());
        this.fNameEntry.setEditable(this.isEditable());
        this.fSchemaEntry.setEditable(this.isEditable());
        toolkit.paintBordersFor(client);
        section.setClient((Control)client);
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.markDetailsPart((Control)section);
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]).equals(this.fInput)) {
            this.refresh();
        }
    }

    private void update() {
        this.fIdEntry.setValue(this.fInput != null && this.fInput.getId() != null ? this.fInput.getId() : "", true);
        this.fNameEntry.setValue(this.fInput != null && this.fInput.getName() != null ? this.fInput.getName() : "", true);
        this.fSchemaEntry.setValue(this.fInput != null && this.fInput.getSchema() != null ? this.fInput.getSchema() : "", true);
        this.updateRichText();
    }

    public void cancelEdit() {
        this.fIdEntry.cancelEdit();
        this.fNameEntry.cancelEdit();
        this.fSchemaEntry.cancelEdit();
        this.updateRichText();
        super.cancelEdit();
    }

    private void updateRichText() {
        boolean hasSchema;
        boolean bl = hasSchema = this.fSchemaEntry.getValue().length() > 0;
        if (hasSchema && this.fRichTextData == SCHEMA_RTEXT_DATA) {
            return;
        }
        if (!hasSchema && this.fRichTextData == NO_SCHEMA_RTEXT_DATA) {
            return;
        }
        this.fRichTextData = hasSchema ? SCHEMA_RTEXT_DATA : NO_SCHEMA_RTEXT_DATA;
        this.fRichText.setText(this.fRichTextData, true, false);
        this.getManagedForm().getForm().reflow(true);
    }

    private void openSchemaFile(final IFile file) {
        final IWorkbenchWindow ww = PDEPlugin.getActiveWorkbenchWindow();
        Display d = ww.getShell().getDisplay();
        d.asyncExec(new Runnable(){

            public void run() {
                try {
                    String editorId = "org.eclipse.pde.ui.schemaEditor";
                    ww.getActivePage().openEditor((IEditorInput)new FileEditorInput(file), editorId);
                }
                catch (PartInitException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
    }

    private void generateSchema() {
        final IProject project = this.getPage().getPDEEditor().getCommonProject();
        BusyIndicator.showWhile((Display)this.getPage().getPartControl().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewSchemaFileWizard wizard = new NewSchemaFileWizard(project, ExtensionPointDetails.this.fInput, true);
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 400, 450);
                if (dialog.open() == 0) {
                    ExtensionPointDetails.this.update();
                }
            }
        });
    }

    public void selectionChanged(IFormPart masterPart, ISelection selection) {
        IStructuredSelection ssel = (IStructuredSelection)selection;
        this.fInput = ssel.size() == 1 ? (IPluginExtensionPoint)ssel.getFirstElement() : null;
        this.update();
    }

    public void commit(boolean onSave) {
        this.fIdEntry.commit();
        this.fNameEntry.commit();
        this.fSchemaEntry.commit();
        super.commit(onSave);
    }

    public void setFocus() {
        this.fIdEntry.getText().setFocus();
    }

    public void refresh() {
        this.update();
        super.refresh();
    }
}

