/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.FormEntryAdapter;
import org.eclipse.pde.internal.ui.editor.PDESection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.pde.internal.ui.parts.FormEntry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.RTFTransfer;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;

public class HandlerSection
extends PDESection {
    public static final String SECTION_TITLE = "FeatureEditor.HandlerSection.title";
    public static final String SECTION_DESC = "FeatureEditor.HandlerSection.desc";
    public static final String SECTION_URL = "FeatureEditor.HandlerSection.url";
    public static final String SECTION_LIBRARY = "FeatureEditor.HandlerSection.library";
    public static final String SECTION_HANDLER = "FeatureEditor.HandlerSection.handler";
    private FormEntry urlText;
    private FormEntry libraryText;
    private FormEntry handlerText;

    public HandlerSection(FeatureAdvancedPage page, Composite parent) {
        super(page, parent, 128);
        this.getSection().setText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.getSection().setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        this.createClient(this.getSection(), page.getManagedForm().getToolkit());
    }

    public boolean canPaste(Clipboard clipboard) {
        TransferData[] types = clipboard.getAvailableTypes();
        Transfer[] transfers = new Transfer[]{TextTransfer.getInstance(), RTFTransfer.getInstance()};
        int i = 0;
        while (i < types.length) {
            int j = 0;
            while (j < transfers.length) {
                if (transfers[j].isSupportedType(types[i])) {
                    return true;
                }
                ++j;
            }
            ++i;
        }
        return false;
    }

    public void commit(boolean onSave) {
        this.urlText.commit();
        this.libraryText.commit();
        this.handlerText.commit();
        super.commit(onSave);
    }

    public void createClient(Section section, FormToolkit toolkit) {
        Composite container = toolkit.createComposite((Composite)section);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        final IFeature feature = model.getFeature();
        this.urlText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_URL), null, false);
        this.urlText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setURL(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.libraryText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_LIBRARY), null, false);
        this.libraryText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setLibrary(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        this.handlerText = new FormEntry(container, toolkit, PDEPlugin.getResourceString(SECTION_HANDLER), null, false);
        this.handlerText.setFormEntryListener(new FormEntryAdapter(this){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setHandler(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        });
        toolkit.paintBordersFor(container);
        section.setClient((Control)container);
        this.initialize();
    }

    private void setURL(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        try {
            URL url = new URL(value);
            handler.setURL(url);
        }
        catch (MalformedURLException malformedURLException) {
            MessageDialog.openError((Shell)this.getPage().getEditor().getEditorSite().getShell(), (String)PDEPlugin.getResourceString("HandlerSection.featureEditor"), (String)PDEPlugin.getFormattedMessage("HandlerSection.invalid", value));
            this.setIfDefined(this.urlText, handler.getURL());
        }
    }

    private void setLibrary(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setLibrary(value);
    }

    private void setHandler(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setHandlerName(value);
    }

    private IFeatureInstallHandler getHandler(IFeature feature) throws CoreException {
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler == null) {
            handler = feature.getModel().getFactory().createInstallHandler();
            feature.setInstallHandler(handler);
        }
        return handler;
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        if (model != null) {
            model.removeModelChangedListener((IModelChangedListener)this);
        }
        super.dispose();
    }

    public void initialize() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        this.refresh();
        if (!model.isEditable()) {
            this.urlText.getText().setEditable(false);
            this.libraryText.getText().setEditable(false);
            this.handlerText.getText().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.markStale();
        }
    }

    public void setFocus() {
        if (this.urlText != null) {
            this.urlText.getText().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, Object value) {
        if (value != null) {
            formText.setValue(value.toString(), true);
        } else {
            formText.setValue(null, true);
        }
    }

    public void refresh() {
        IFeatureModel model = (IFeatureModel)this.getPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler != null) {
            this.setIfDefined(this.urlText, handler.getURL());
            this.setIfDefined(this.libraryText, handler.getLibrary());
            this.setIfDefined(this.handlerText, handler.getHandlerName());
        }
        super.refresh();
    }

    public void cancelEdit() {
        this.urlText.cancelEdit();
        this.libraryText.cancelEdit();
        this.handlerText.cancelEdit();
        super.cancelEdit();
    }
}

