/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ltk.internal.ui.refactoring;

import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.ControlEnableState;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IMessageProvider;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.jface.util.Assert;
import org.eclipse.jface.wizard.IWizardContainer;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.ProgressMonitorPart;
import org.eclipse.ltk.internal.ui.refactoring.ErrorWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.InternalAPI;
import org.eclipse.ltk.internal.ui.refactoring.PreviewWizardPage;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringPluginImages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringStatusDialog;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIMessages;
import org.eclipse.ltk.internal.ui.refactoring.RefactoringUIPlugin;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class RefactoringWizardDialog2
extends Dialog
implements IWizardContainer {
    private RefactoringWizard fWizard;
    private IWizardPage fCurrentPage;
    private IWizardPage fVisiblePage;
    private boolean fMakeNextButtonDefault;
    private PageBook fPageContainer;
    private PageBook fStatusContainer;
    private MessageBox fMessageBox;
    private ProgressMonitorPart fProgressMonitorPart;
    private int fActiveRunningOperations;
    private Cursor fWaitCursor;
    private Cursor fArrowCursor;
    private static final int PREVIEW_ID = 1025;
    private int fPreviewWidth;
    private int fPreviewHeight;
    private IDialogSettings fSettings;
    private static final String DIALOG_SETTINGS = "RefactoringWizard.preview";
    private static final String WIDTH = "width";
    private static final String HEIGHT = "height";
    private static final Image INFO = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringinfo_obj.gif");
    private static final Image WARNING = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringwarning_obj.gif");
    private static final Image ERROR = RefactoringPluginImages.get("org.eclipse.ltk.ui.refactoringerror_obj.gif");

    public RefactoringWizardDialog2(Shell shell, RefactoringWizard wizard) {
        super(shell);
        Assert.isNotNull((Object)((Object)wizard));
        this.setShellStyle(this.getShellStyle() | 0x10);
        wizard.setDialogSettings(RefactoringUIPlugin.getDefault().getDialogSettings());
        this.fWizard = wizard;
        this.fWizard.setContainer(this);
        this.fWizard.addPages();
        this.initSize();
    }

    private void initSize() {
        IDialogSettings settings = RefactoringUIPlugin.getDefault().getDialogSettings();
        this.fSettings = settings.getSection(DIALOG_SETTINGS);
        if (this.fSettings == null) {
            this.fSettings = new DialogSettings(DIALOG_SETTINGS);
            settings.addSection(this.fSettings);
            this.fSettings.put(WIDTH, 600);
            this.fSettings.put(HEIGHT, 400);
        }
        this.fPreviewWidth = 600;
        this.fPreviewHeight = 400;
        try {
            this.fPreviewWidth = this.fSettings.getInt(WIDTH);
            this.fPreviewHeight = this.fSettings.getInt(HEIGHT);
        }
        catch (NumberFormatException numberFormatException) {}
    }

    private void saveSize() {
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            Composite control = this.fCurrentPage.getControl().getParent();
            Point size = control.getSize();
            this.fSettings.put(WIDTH, size.x);
            this.fSettings.put(HEIGHT, size.y);
        }
    }

    public Button getCancelButton() {
        return this.getButton(1);
    }

    public void makeNextButtonDefault() {
        this.fMakeNextButtonDefault = true;
    }

    public void showPage(IWizardPage page) {
        this.fCurrentPage = page;
    }

    public void updateButtons() {
        Button okButton;
        boolean previewPage = this.isPreviewPageActive();
        boolean ok = this.fWizard.canFinish();
        boolean canFlip = this.fCurrentPage.canFlipToNextPage();
        Button previewButton = this.getButton(1025);
        Button defaultButton = null;
        if (previewButton != null && !previewButton.isDisposed()) {
            previewButton.setEnabled(!previewPage);
            if (!previewPage) {
                previewButton.setEnabled(canFlip);
            }
            if (previewButton.isEnabled()) {
                defaultButton = previewButton;
            }
        }
        if ((okButton = this.getButton(0)) != null && !okButton.isDisposed()) {
            okButton.setEnabled(ok);
            if (ok) {
                defaultButton = okButton;
            }
        }
        if (defaultButton != null) {
            defaultButton.getShell().setDefaultButton(defaultButton);
        }
    }

    public void updateMessage() {
        if (this.fStatusContainer == null || this.fStatusContainer.isDisposed()) {
            return;
        }
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.fMessageBox.setMessage(this.fCurrentPage);
    }

    public void updateTitleBar() {
    }

    public void updateWindowTitle() {
        this.getShell().setText(this.fWizard.getWindowTitle());
    }

    public IWizardPage getCurrentPage() {
        return this.fCurrentPage;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(boolean fork, boolean cancelable, IRunnableWithProgress runnable) throws InvocationTargetException, InterruptedException {
        if (this.fProgressMonitorPart == null) {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)false, (IProgressMonitor)new NullProgressMonitor(), (Display)this.getShell().getDisplay());
            return;
        }
        Object state = null;
        if (this.fActiveRunningOperations == 0) {
            state = this.aboutToStart(fork && cancelable);
        }
        ++this.fActiveRunningOperations;
        try {
            ModalContext.run((IRunnableWithProgress)runnable, (boolean)fork, (IProgressMonitor)this.fProgressMonitorPart, (Display)this.getShell().getDisplay());
        }
        catch (Throwable throwable) {
            Object var5_6 = null;
            --this.fActiveRunningOperations;
            if (state == null) throw throwable;
            this.stopped(state);
            throw throwable;
        }
        {
            Object var5_7 = null;
            --this.fActiveRunningOperations;
            if (state == null) return;
            this.stopped(state);
            return;
        }
    }

    private Object aboutToStart(boolean cancelable) {
        Map savedState = null;
        Shell shell = this.getShell();
        if (shell != null) {
            Control focusControl = this.getShell().getDisplay().getFocusControl();
            if (focusControl != null && focusControl.getShell() != this.getShell()) {
                focusControl = null;
            }
            Button cancelButton = this.getButton(1);
            Display d = this.getShell().getDisplay();
            this.fWaitCursor = new Cursor((Device)d, 1);
            this.setDisplayCursor(d, this.fWaitCursor);
            this.fArrowCursor = new Cursor((Device)d, 0);
            cancelButton.setCursor(this.fArrowCursor);
            boolean hasProgressMonitor = this.fProgressMonitorPart != null;
            savedState = this.saveUIState(hasProgressMonitor && cancelable);
            if (focusControl != null) {
                savedState.put("focus", focusControl);
            }
            if (hasProgressMonitor) {
                this.fProgressMonitorPart.attachToCancelComponent((Control)cancelButton);
                this.fStatusContainer.showPage((Control)this.fProgressMonitorPart);
            }
            this.fStatusContainer.update();
        }
        return savedState;
    }

    private Map saveUIState(boolean keepCancelEnabled) {
        HashMap<String, ControlEnableState> savedState = new HashMap<String, ControlEnableState>(10);
        this.saveEnableStateAndSet((Control)this.getButton(1025), savedState, "preview", false);
        this.saveEnableStateAndSet((Control)this.getButton(0), savedState, "ok", false);
        this.saveEnableStateAndSet((Control)this.getButton(1), savedState, "cancel", keepCancelEnabled);
        savedState.put("page", ControlEnableState.disable((Control)this.fVisiblePage.getControl()));
        return savedState;
    }

    private void saveEnableStateAndSet(Control w, Map h, String key, boolean enabled) {
        if (w != null) {
            h.put(key, new Boolean(w.getEnabled()));
            w.setEnabled(enabled);
        }
    }

    private void setDisplayCursor(Display d, Cursor c) {
        Shell[] shells = d.getShells();
        int i = 0;
        while (i < shells.length) {
            shells[i].setCursor(c);
            ++i;
        }
    }

    private void stopped(Object savedState) {
        Shell shell = this.getShell();
        if (shell != null) {
            Button cancelButton = this.getButton(1);
            if (this.fProgressMonitorPart != null) {
                this.fProgressMonitorPart.removeFromCancelComponent((Control)cancelButton);
            }
            this.fStatusContainer.showPage((Control)this.fMessageBox);
            Map state = (Map)savedState;
            this.restoreUIState(state);
            this.setDisplayCursor(shell.getDisplay(), null);
            cancelButton.setCursor(null);
            this.fWaitCursor.dispose();
            this.fWaitCursor = null;
            this.fArrowCursor.dispose();
            this.fArrowCursor = null;
            Control focusControl = (Control)state.get("focus");
            if (focusControl != null) {
                focusControl.setFocus();
            }
        }
    }

    private void restoreUIState(Map state) {
        this.restoreEnableState((Control)this.getButton(1025), state, "preview");
        this.restoreEnableState((Control)this.getButton(0), state, "ok");
        this.restoreEnableState((Control)this.getButton(1), state, "cancel");
        ControlEnableState pageState = (ControlEnableState)state.get("page");
        pageState.restore();
    }

    private void restoreEnableState(Control w, Map h, String key) {
        Boolean b;
        if (w != null && (b = (Boolean)h.get(key)) != null) {
            w.setEnabled(b.booleanValue());
        }
    }

    public boolean close() {
        this.fWizard.dispose();
        return super.close();
    }

    protected void cancelPressed() {
        if (this.fActiveRunningOperations == 0 && this.fWizard.performCancel()) {
            super.cancelPressed();
        }
    }

    protected void okPressed() {
        IWizardPage current = this.fCurrentPage;
        if (this.fWizard.performFinish()) {
            this.saveSize();
            super.okPressed();
            return;
        }
        if (this.fCurrentPage == current) {
            return;
        }
        Assert.isTrue((boolean)"ErrorPage".equals(this.fCurrentPage.getName()));
        if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage) && this.fWizard.performFinish()) {
            super.okPressed();
            return;
        }
        this.fCurrentPage = current;
    }

    protected void handleShellCloseEvent() {
        if (this.fActiveRunningOperations == 0 && this.fWizard.performCancel()) {
            super.handleShellCloseEvent();
        }
    }

    private boolean isPreviewPageActive() {
        return "PreviewPage".equals(this.fCurrentPage.getName());
    }

    private void previewPressed() {
        IWizardPage current = this.fCurrentPage;
        this.fCurrentPage = this.fCurrentPage.getNextPage();
        if (current == this.fCurrentPage) {
            return;
        }
        String pageName = this.fCurrentPage.getName();
        if ("ErrorPage".equals(pageName)) {
            if (this.showErrorDialog((ErrorWizardPage)this.fCurrentPage)) {
                this.fCurrentPage = this.fCurrentPage.getNextPage();
                pageName = this.fCurrentPage.getName();
            } else {
                return;
            }
        }
        if ("PreviewPage".equals(pageName)) {
            this.fCurrentPage.createControl((Composite)this.fPageContainer);
            this.makeVisible(this.fCurrentPage);
            this.updateButtons();
            if (((PreviewWizardPage)this.fCurrentPage).hasChanges()) {
                this.resize();
            } else {
                this.getButton(0).setEnabled(false);
            }
        } else {
            this.fCurrentPage = current;
        }
    }

    private boolean showErrorDialog(ErrorWizardPage page) {
        RefactoringStatusDialog dialog = new RefactoringStatusDialog(this.getShell(), page, this.fWizard.internalShowBackButtonOnStatusDialog(InternalAPI.INSTANCE));
        switch (dialog.open()) {
            case 0: {
                return true;
            }
            case 14: {
                this.fCurrentPage = this.fCurrentPage.getPreviousPage();
                break;
            }
            case 1: {
                super.cancelPressed();
            }
        }
        return false;
    }

    private void resize() {
        int ye;
        Control control = this.fPageContainer.getTopPage();
        Point size = control.getSize();
        int dw = Math.max(0, this.fPreviewWidth - size.x);
        int dh = Math.max(0, this.fPreviewHeight - size.y);
        int dx = dw / 2;
        int dy = dh / 2;
        Shell shell = this.getShell();
        Rectangle rect = shell.getBounds();
        Rectangle display = shell.getDisplay().getClientArea();
        rect.x = Math.max(0, rect.x - dx);
        rect.y = Math.max(0, rect.y - dy);
        rect.width = Math.min(rect.width + dw, display.width);
        rect.height = Math.min(rect.height + dh, display.height);
        int xe = rect.x + rect.width;
        if (xe > display.width) {
            rect.x -= xe - display.width;
        }
        if ((ye = rect.y + rect.height) > display.height) {
            rect.y -= ye - display.height;
        }
        shell.setBounds(rect);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(this.fWizard.getDefaultPageTitle());
        this.fWizard.getRefactoring().setValidationContext((Object)newShell);
    }

    protected Control createContents(Composite parent) {
        Composite result = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        result.setLayout((Layout)layout);
        result.setLayoutData((Object)new GridData(1808));
        this.initializeDialogUnits((Control)result);
        this.fPageContainer = new PageBook(result, 0);
        GridData gd = new GridData(1808);
        this.fPageContainer.setLayoutData(gd);
        this.fCurrentPage = this.fWizard.getStartingPage();
        this.dialogArea = this.fPageContainer;
        if (this.fCurrentPage instanceof PreviewWizardPage) {
            gd.widthHint = this.fPreviewWidth;
            gd.heightHint = this.fPreviewHeight;
        }
        this.fStatusContainer = new PageBook(result, 0);
        gd = new GridData(768);
        gd.widthHint = this.convertWidthInCharsToPixels(this.fWizard.getMessageLineWidthInChars());
        this.fStatusContainer.setLayoutData(gd);
        if (this.fWizard.needsProgressMonitor()) {
            this.createProgressMonitorPart();
        }
        this.createMessageBox();
        this.fStatusContainer.showPage((Control)this.fMessageBox);
        this.buttonBar = this.createButtonBar(result);
        this.fCurrentPage.createControl((Composite)this.fPageContainer);
        this.makeVisible(this.fCurrentPage);
        this.updateMessage();
        this.updateButtons();
        Dialog.applyDialogFont((Control)result);
        return result;
    }

    private void createProgressMonitorPart() {
        GridLayout pmlayout = new GridLayout();
        pmlayout.numColumns = 1;
        pmlayout.marginHeight = 0;
        this.fProgressMonitorPart = new ProgressMonitorPart((Composite)this.fStatusContainer, (Layout)pmlayout);
    }

    private void createMessageBox() {
        this.fMessageBox = new MessageBox(this.fStatusContainer, 0);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (!(this.fCurrentPage instanceof PreviewWizardPage) && this.fWizard.internalHasPreviewPage(InternalAPI.INSTANCE)) {
            Button preview = this.createButton(parent, 1025, RefactoringUIMessages.getString("RefactoringWizardDialog2.buttons.preview.label"), false);
            if (this.fMakeNextButtonDefault) {
                preview.getShell().setDefaultButton(preview);
            }
            preview.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    RefactoringWizardDialog2.this.previewPressed();
                }
            });
        }
        String OK_LABEL = IDialogConstants.OK_LABEL;
        String CANCEL_LABEL = IDialogConstants.CANCEL_LABEL;
        if (this.fWizard.internalIsYesNoStyle(InternalAPI.INSTANCE)) {
            OK_LABEL = IDialogConstants.YES_LABEL;
            CANCEL_LABEL = IDialogConstants.NO_LABEL;
        }
        this.createButton(parent, 0, OK_LABEL, true);
        this.createButton(parent, 1, CANCEL_LABEL, false);
        Button okButton = this.getButton(0);
        okButton.setFocus();
    }

    private void makeVisible(IWizardPage page) {
        if (this.fVisiblePage == page) {
            return;
        }
        if (this.fVisiblePage != null) {
            this.fVisiblePage.setVisible(false);
        }
        this.fVisiblePage = page;
        this.fPageContainer.showPage(page.getControl());
        this.fVisiblePage.setVisible(true);
    }

    private static class MessageBox
    extends Composite {
        private Label fImage;
        private Label fText;

        public MessageBox(Composite parent, int style) {
            super(parent, style);
            GridLayout layout = new GridLayout();
            layout.numColumns = 2;
            this.setLayout((Layout)layout);
            this.fImage = new Label((Composite)this, 0);
            this.fImage.setImage(INFO);
            Point size = this.fImage.computeSize(-1, -1);
            GridData gd = new GridData();
            gd.verticalAlignment = 128;
            gd.widthHint = size.x;
            gd.heightHint = size.y;
            this.fImage.setLayoutData((Object)gd);
            this.fImage.setImage(null);
            this.fText = new Label((Composite)this, 64);
            this.fText.setText(" \n ");
            size = this.fText.computeSize(-1, -1);
            gd = new GridData(768);
            gd.heightHint = size.y;
            gd.verticalAlignment = 128;
            this.fText.setLayoutData((Object)gd);
        }

        public void setMessage(IWizardPage page) {
            String msg = page.getErrorMessage();
            int type = 3;
            if (msg == null || msg.length() == 0) {
                msg = page.getMessage();
                type = 0;
                if (msg != null && page instanceof IMessageProvider) {
                    type = ((IMessageProvider)page).getMessageType();
                }
            }
            Image image = null;
            switch (type) {
                case 1: {
                    image = INFO;
                    break;
                }
                case 2: {
                    image = WARNING;
                    break;
                }
                case 3: {
                    image = ERROR;
                }
            }
            if (msg == null) {
                msg = "";
            }
            this.fText.setText(msg);
            if (image == null && msg.length() > 0) {
                image = INFO;
            }
            this.fImage.setImage(image);
        }
    }

    private static class PageBook
    extends Composite {
        private StackLayout fLayout = new StackLayout();

        public PageBook(Composite parent, int style) {
            super(parent, style);
            this.setLayout((Layout)this.fLayout);
            this.fLayout.marginWidth = 5;
            this.fLayout.marginHeight = 5;
        }

        public void showPage(Control page) {
            this.fLayout.topControl = page;
            this.layout();
        }

        public Control getTopPage() {
            return this.fLayout.topControl;
        }
    }
}

