/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.search.matching;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.search.MethodDeclarationMatch;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.MessageSend;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.core.ClassFile;
import org.eclipse.jdt.internal.core.search.matching.DeclarationOfReferencedMethodsPattern;
import org.eclipse.jdt.internal.core.search.matching.MatchLocator;
import org.eclipse.jdt.internal.core.search.matching.MatchingNodeSet;
import org.eclipse.jdt.internal.core.search.matching.MethodPattern;
import org.eclipse.jdt.internal.core.search.matching.PatternLocator;
import org.eclipse.jdt.internal.core.search.matching.SuperTypeNamesCollector;
import org.eclipse.jdt.internal.core.util.SimpleSet;

public class MethodLocator
extends PatternLocator {
    protected MethodPattern pattern;
    protected boolean isDeclarationOfReferencedMethodsPattern;
    public char[][][] allSuperDeclaringTypeNames;

    public MethodLocator(MethodPattern pattern) {
        super(pattern);
        this.pattern = pattern;
        this.isDeclarationOfReferencedMethodsPattern = this.pattern instanceof DeclarationOfReferencedMethodsPattern;
    }

    public void initializePolymorphicSearch(MatchLocator locator) {
        try {
            this.allSuperDeclaringTypeNames = new SuperTypeNamesCollector(this.pattern, this.pattern.declaringSimpleName, this.pattern.declaringQualification, locator, this.pattern.declaringType, locator.progressMonitor).collect();
        }
        catch (JavaModelException javaModelException) {}
    }

    protected boolean isVirtualInvoke(MethodBinding method, MessageSend messageSend) {
        return !method.isStatic() && !method.isPrivate() && !messageSend.isSuperAccess();
    }

    public int match(MethodDeclaration node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findDeclarations) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Argument[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
            int i = 0;
            while (i < argsLength) {
                if (!this.matchesTypeReference(this.pattern.parameterSimpleNames[i], args[i].type)) {
                    return 0;
                }
                ++i;
            }
        }
        if (!this.matchesTypeReference(this.pattern.returnSimpleName, node.returnType)) {
            return 0;
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    public int match(MessageSend node, MatchingNodeSet nodeSet) {
        if (!this.pattern.findReferences) {
            return 0;
        }
        if (!this.matchesName(this.pattern.selector, node.selector)) {
            return 0;
        }
        if (this.pattern.parameterSimpleNames != null) {
            int argsLength;
            int length = this.pattern.parameterSimpleNames.length;
            Expression[] args = node.arguments;
            int n = argsLength = args == null ? 0 : args.length;
            if (length != argsLength) {
                return 0;
            }
        }
        return nodeSet.addMatch(node, this.pattern.mustResolve ? 2 : 3);
    }

    protected int matchContainer() {
        if (this.pattern.findReferences) {
            return 14;
        }
        return 2;
    }

    protected int matchMethod(MethodBinding method) {
        int parameterCount;
        int newLevel;
        if (!this.matchesName(this.pattern.selector, method.selector)) {
            return 0;
        }
        int level = 3;
        if (this.pattern.declaringSimpleName == null && level > (newLevel = this.resolveLevelForType(this.pattern.returnSimpleName, this.pattern.returnQualification, method.returnType))) {
            if (newLevel == 0) {
                return 0;
            }
            level = newLevel;
        }
        int n = parameterCount = this.pattern.parameterSimpleNames == null ? -1 : this.pattern.parameterSimpleNames.length;
        if (parameterCount > -1) {
            if (method.parameters == null) {
                return 1;
            }
            if (parameterCount != method.parameters.length) {
                return 0;
            }
            int i = 0;
            while (i < parameterCount) {
                int newLevel2 = this.resolveLevelForType(this.pattern.parameterSimpleNames[i], this.pattern.parameterQualifications[i], method.parameters[i]);
                if (level > newLevel2) {
                    if (newLevel2 == 0) {
                        return 0;
                    }
                    level = newLevel2;
                }
                ++i;
            }
        }
        return level;
    }

    protected void matchReportReference(ASTNode reference, IJavaElement element, int accuracy, MatchLocator locator) throws CoreException {
        if (this.isDeclarationOfReferencedMethodsPattern) {
            if (accuracy != 0) {
                return;
            }
            DeclarationOfReferencedMethodsPattern declPattern = (DeclarationOfReferencedMethodsPattern)this.pattern;
            while (element != null && !declPattern.enclosingElement.equals(element)) {
                element = element.getParent();
            }
            if (element != null) {
                this.reportDeclaration(((MessageSend)reference).binding, locator, declPattern.knownMethods);
            }
        } else if (this.pattern.findReferences && reference instanceof MessageSend) {
            int offset = (int)(((MessageSend)reference).nameSourcePosition >>> 32);
            SearchMatch match = locator.newMethodReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            locator.report(match);
        } else {
            int offset = reference.sourceStart;
            SearchMatch match = locator.newMethodReferenceMatch(element, accuracy, offset, reference.sourceEnd - offset + 1, reference);
            locator.report(match);
        }
    }

    protected int referenceType() {
        return 9;
    }

    protected void reportDeclaration(MethodBinding methodBinding, MatchLocator locator, SimpleSet knownMethods) throws CoreException {
        ReferenceBinding declaringClass = methodBinding.declaringClass;
        IType type = locator.lookupType(declaringClass);
        if (type == null) {
            return;
        }
        char[] bindingSelector = methodBinding.selector;
        TypeBinding[] parameters = methodBinding.parameters;
        int parameterLength = parameters.length;
        String[] parameterTypes = new String[parameterLength];
        int i = 0;
        while (i < parameterLength) {
            parameterTypes[i] = Signature.createTypeSignature(parameters[i].sourceName(), false);
            ++i;
        }
        IMethod method = type.getMethod(new String(bindingSelector), parameterTypes);
        if (knownMethods.includes(method)) {
            return;
        }
        knownMethods.add(method);
        IResource resource = type.getResource();
        boolean isBinary = type.isBinary();
        IBinaryType info = null;
        if (isBinary) {
            if (resource == null) {
                resource = type.getJavaProject().getProject();
            }
            info = locator.getBinaryInfo((ClassFile)type.getClassFile(), resource);
            locator.reportBinaryMemberDeclaration(resource, method, info, 0);
        } else {
            ClassScope scope = ((SourceTypeBinding)declaringClass).scope;
            if (scope != null) {
                TypeDeclaration typeDecl = scope.referenceContext;
                AbstractMethodDeclaration methodDecl = null;
                AbstractMethodDeclaration[] methodDecls = typeDecl.methods;
                int i2 = 0;
                int length = methodDecls.length;
                while (i2 < length) {
                    if (CharOperation.equals(bindingSelector, methodDecls[i2].selector)) {
                        methodDecl = methodDecls[i2];
                        break;
                    }
                    ++i2;
                }
                if (methodDecl != null) {
                    int offset = methodDecl.sourceStart;
                    MethodDeclarationMatch match = new MethodDeclarationMatch(method, 0, offset, methodDecl.sourceEnd - offset + 1, locator.getParticipant(), resource);
                    locator.report(match);
                }
            }
        }
    }

    public int resolveLevel(ASTNode possibleMatchingNode) {
        if (this.pattern.findReferences && possibleMatchingNode instanceof MessageSend) {
            return this.resolveLevel((MessageSend)possibleMatchingNode);
        }
        if (this.pattern.findDeclarations && possibleMatchingNode instanceof MethodDeclaration) {
            return this.resolveLevel(((MethodDeclaration)possibleMatchingNode).binding);
        }
        return 0;
    }

    public int resolveLevel(Binding binding) {
        if (binding == null) {
            return 1;
        }
        if (!(binding instanceof MethodBinding)) {
            return 0;
        }
        MethodBinding method = (MethodBinding)binding;
        int methodLevel = this.matchMethod(method);
        if (methodLevel == 0) {
            return 0;
        }
        char[] qualifiedPattern = PatternLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification);
        if (qualifiedPattern == null) {
            return methodLevel;
        }
        int declaringLevel = !method.isStatic() && !method.isPrivate() ? this.resolveLevelAsSubtype(qualifiedPattern, method.declaringClass) : this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevel(MessageSend messageSend) {
        int declaringLevel;
        MethodBinding method = messageSend.binding;
        if (method == null) {
            return 1;
        }
        int methodLevel = this.matchMethod(method);
        if (methodLevel == 0) {
            return 0;
        }
        char[] qualifiedPattern = PatternLocator.qualifiedPattern(this.pattern.declaringSimpleName, this.pattern.declaringQualification);
        if (qualifiedPattern == null) {
            return methodLevel;
        }
        if (this.isVirtualInvoke(method, messageSend) && !(messageSend.receiverType instanceof ArrayBinding)) {
            declaringLevel = this.resolveLevelAsSubtype(qualifiedPattern, method.declaringClass);
            if (declaringLevel == 0) {
                if (method.declaringClass == null || this.allSuperDeclaringTypeNames == null) {
                    declaringLevel = 1;
                } else {
                    char[][] compoundName = method.declaringClass.compoundName;
                    int i = 0;
                    int max = this.allSuperDeclaringTypeNames.length;
                    while (i < max) {
                        if (CharOperation.equals(this.allSuperDeclaringTypeNames[i], compoundName)) {
                            return methodLevel;
                        }
                        ++i;
                    }
                }
            }
        } else {
            declaringLevel = this.resolveLevelForType(qualifiedPattern, method.declaringClass);
        }
        return methodLevel > declaringLevel ? declaringLevel : methodLevel;
    }

    protected int resolveLevelAsSubtype(char[] qualifiedPattern, ReferenceBinding type) {
        if (type == null) {
            return 1;
        }
        int level = this.resolveLevelForType(qualifiedPattern, type);
        if (level != 0) {
            return level;
        }
        if (!type.isInterface() && !CharOperation.equals(type.compoundName, TypeConstants.JAVA_LANG_OBJECT) && (level = this.resolveLevelAsSubtype(qualifiedPattern, type.superclass())) != 0) {
            return level;
        }
        ReferenceBinding[] interfaces = type.superInterfaces();
        if (interfaces == null) {
            return 1;
        }
        int i = 0;
        while (i < interfaces.length) {
            level = this.resolveLevelAsSubtype(qualifiedPattern, interfaces[i]);
            if (level != 0) {
                return level;
            }
            ++i;
        }
        return 0;
    }

    public String toString() {
        return "Locator for " + this.pattern.toString();
    }
}

