/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.intro.impl.model;

import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IRegistryChangeEvent;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroElement;
import org.eclipse.ui.internal.intro.impl.model.AbstractIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.model.IntroHead;
import org.eclipse.ui.internal.intro.impl.model.IntroModelRoot;
import org.eclipse.ui.internal.intro.impl.model.loader.ModelLoaderUtil;
import org.eclipse.ui.internal.intro.impl.presentations.BrowserIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.presentations.FormIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.presentations.TextIntroPartImplementation;
import org.eclipse.ui.internal.intro.impl.util.Log;
import org.eclipse.ui.internal.intro.impl.util.Util;
import org.eclipse.ui.intro.IIntroPart;

public class IntroPartPresentation
extends AbstractIntroElement {
    protected static final String TAG_PRESENTATION = "presentation";
    private static final String TAG_IMPLEMENTATION = "implementation";
    private static final String ATT_KIND = "kind";
    private static final String ATT_STYLE = "style";
    private static final String ATT_OS = "os";
    private static final String ATT_WS = "ws";
    protected static final String ATT_HOME_PAGE_ID = "home-page-id";
    protected static final String ATT_STANDBY_PAGE_ID = "standby-page-id";
    private static final String BROWSER_IMPL_KIND = "html";
    private static final String FORMS_IMPL_KIND = "swt";
    private static final String TEXT_IMPL_KIND = "text";
    private String title;
    private String implementationStyle;
    private String implementationKind;
    private String homePageId;
    private String standbyPageId;
    private IntroHead head;
    private AbstractIntroPartImplementation implementation;
    private IIntroPart introPart;
    private IMemento memento;

    IntroPartPresentation(IConfigurationElement element) {
        super(element);
        this.homePageId = element.getAttribute(ATT_HOME_PAGE_ID);
        this.standbyPageId = element.getAttribute(ATT_STANDBY_PAGE_ID);
    }

    private void updatePresentationAttributes(IConfigurationElement element) {
        if (element != null) {
            this.implementationStyle = element.getAttribute(ATT_STYLE);
            this.implementationKind = element.getAttribute(ATT_KIND);
            this.head = this.getHead(element);
            this.implementationStyle = IntroModelRoot.resolveURL(this.implementationStyle, element);
        }
    }

    public String getImplementationStyle() {
        return this.implementationStyle;
    }

    public String getImplementationKind() {
        return this.implementationKind;
    }

    private IntroHead getHead(IConfigurationElement element) {
        try {
            IConfigurationElement[] headElements = element.getChildren("head");
            if (headElements.length == 0) {
                return null;
            }
            IntroHead head = new IntroHead(headElements[0]);
            head.setParent(this);
            return head;
        }
        catch (Exception e) {
            Util.handleException(e.getMessage(), e);
            return null;
        }
    }

    public void init(IIntroPart introPart, IMemento memento) throws PartInitException {
        this.introPart = introPart;
        this.memento = memento;
    }

    public void createPartControl(Composite parent) {
        Vector validImplementations = this.getValidImplementationElements(this.getCfgElement());
        IConfigurationElement implementationElement = null;
        int i = 0;
        while (i < validImplementations.size()) {
            implementationElement = (IConfigurationElement)validImplementations.elementAt(i);
            this.updatePresentationAttributes(implementationElement);
            try {
                this.implementation = this.createIntroPartImplementation(this.getImplementationKind());
                if (this.implementation != null) {
                    this.implementation.init(this.introPart, this.memento);
                    this.implementation.createPartControl(parent);
                    Log.info("Loaded config implementation from: " + ModelLoaderUtil.getLogString(implementationElement, "class"));
                    break;
                }
            }
            catch (SWTError e) {
                Log.error("Failed to create implementation from: " + ModelLoaderUtil.getLogString(implementationElement, "class"), e);
                this.implementation = null;
                implementationElement = null;
            }
            catch (Exception e) {
                Log.error("Failed to create implementation from: " + ModelLoaderUtil.getLogString(implementationElement, "class"), e);
                this.implementation = null;
                implementationElement = null;
            }
            ++i;
        }
        if (implementationElement == null) {
            this.implementation = new FormIntroPartImplementation();
            try {
                this.implementation.init(this.introPart, this.memento);
            }
            catch (Exception e) {
                Log.error(e.getMessage(), e);
                return;
            }
            this.implementation.createPartControl(parent);
            Log.warning("Loaded UI Forms implementation as a default Welcome.");
        }
    }

    private Vector getValidImplementationElements(IConfigurationElement configElement) {
        String ws;
        String os;
        Vector<IConfigurationElement> validList = new Vector<IConfigurationElement>();
        IConfigurationElement[] implementationElements = configElement.getChildren(TAG_IMPLEMENTATION);
        if (implementationElements.length == 0) {
            return validList;
        }
        String currentOS = Platform.getOS();
        String currentWS = Platform.getWS();
        int i = 0;
        while (i < implementationElements.length) {
            os = implementationElements[i].getAttribute(ATT_OS);
            if (os != null && this.listValueHasValue(os, currentOS)) {
                ws = implementationElements[i].getAttribute(ATT_WS);
                if (ws == null) {
                    validList.add(implementationElements[i]);
                } else if (this.listValueHasValue(ws, currentWS)) {
                    validList.add(implementationElements[i]);
                }
            }
            ++i;
        }
        i = 0;
        while (i < implementationElements.length) {
            os = implementationElements[i].getAttribute(ATT_OS);
            if (os == null) {
                ws = implementationElements[i].getAttribute(ATT_WS);
                if (ws == null) {
                    validList.add(implementationElements[i]);
                } else if (this.listValueHasValue(ws, currentWS)) {
                    validList.add(implementationElements[i]);
                }
            }
            ++i;
        }
        return validList;
    }

    private boolean listValueHasValue(String stringValue, String value) {
        String[] attributeValues = stringValue.split(",");
        int i = 0;
        while (i < attributeValues.length) {
            if (attributeValues[i].equalsIgnoreCase(value)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public String getSharedStyle(String kind) {
        IConfigurationElement[] implementationElements = this.getCfgElement().getChildren(TAG_IMPLEMENTATION);
        if (implementationElements.length == 0) {
            return null;
        }
        int i = 0;
        while (i < implementationElements.length) {
            String aKind = implementationElements[i].getAttribute(ATT_KIND);
            if (aKind.equals(kind)) {
                String style = implementationElements[i].getAttribute(ATT_STYLE);
                return IntroModelRoot.resolveURL(style, this.getCfgElement());
            }
            ++i;
        }
        return null;
    }

    private AbstractIntroPartImplementation createIntroPartImplementation(IConfigurationElement configElement) {
        if (configElement == null) {
            return null;
        }
        AbstractIntroPartImplementation implementation = null;
        try {
            implementation = (AbstractIntroPartImplementation)configElement.createExecutableExtension("class");
        }
        catch (Exception e) {
            Util.handleException("Could not instantiate implementation class " + configElement.getAttribute("class"), e);
        }
        return implementation;
    }

    private AbstractIntroPartImplementation createIntroPartImplementation(String implementationType) {
        if (implementationType == null) {
            return null;
        }
        if (!(implementationType.equals(BROWSER_IMPL_KIND) || implementationType.equals(FORMS_IMPL_KIND) || implementationType.equals(TEXT_IMPL_KIND))) {
            return null;
        }
        AbstractIntroPartImplementation implementation = null;
        try {
            implementation = implementationType.equals(BROWSER_IMPL_KIND) ? new BrowserIntroPartImplementation() : (implementationType.equals(FORMS_IMPL_KIND) ? new FormIntroPartImplementation() : new TextIntroPartImplementation());
        }
        catch (Exception e) {
            Util.handleException("Could not instantiate implementation " + implementationType, e);
        }
        return implementation;
    }

    public IIntroPart getIntroPart() {
        return this.introPart;
    }

    public void saveState(IMemento memento) {
        if (this.implementation != null) {
            this.implementation.saveState(memento);
        }
    }

    public void setFocus() {
        if (this.implementation != null) {
            this.implementation.setFocus();
        }
    }

    public void standbyStateChanged(boolean standby, boolean isStandbyPartNeeded) {
        if (this.implementation != null) {
            this.implementation.standbyStateChanged(standby, isStandbyPartNeeded);
        }
    }

    public void updateHistory(String location) {
        if (this.implementation != null) {
            this.implementation.updateHistory(location);
        }
    }

    public boolean navigateForward() {
        if (this.implementation != null) {
            return this.implementation.navigateForward();
        }
        return false;
    }

    public boolean navigateBackward() {
        if (this.implementation != null) {
            return this.implementation.navigateBackward();
        }
        return false;
    }

    public boolean navigateHome() {
        if (this.implementation != null) {
            return this.implementation.navigateHome();
        }
        return false;
    }

    public void dispose() {
        if (this.implementation != null) {
            this.implementation.dispose();
        }
    }

    public void registryChanged(IRegistryChangeEvent event) {
        if (this.implementation != null) {
            this.implementation.registryChanged(event);
        }
    }

    public String getHomePageId() {
        return this.homePageId;
    }

    public String getStandbyPageId() {
        return this.standbyPageId;
    }

    public int getType() {
        return 2;
    }

    public IntroHead getHead() {
        return this.head;
    }
}

