/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.cheatsheets.dialogs;

import java.util.ArrayList;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.internal.cheatsheets.CheatSheetPlugin;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetCollectionElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetElement;
import org.eclipse.ui.internal.cheatsheets.registry.CheatSheetRegistryReader;

public class CheatSheetSelectionDialog
extends SelectionDialog {
    private static final int LIST_WIDTH = 60;
    private static final int LIST_HEIGHT = 10;
    private ListViewer listViewer;

    public CheatSheetSelectionDialog(Shell shell) {
        super(shell);
        this.setTitle(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_SELECTION_DIALOG_TITLE"));
        this.setMessage(CheatSheetPlugin.getResourceString("%CHEAT_SHEET_SELECTION_DIALOG_MSG"));
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    private void addCheatSheets(ArrayList list, CheatSheetCollectionElement cheatSheetsCollection) {
        Object[] cheatSheets = cheatSheetsCollection.getCheatSheets();
        int i = 0;
        while (i < cheatSheets.length) {
            if (!list.contains(cheatSheets[i])) {
                list.add(cheatSheets[i]);
            }
            ++i;
        }
        Object[] cheatSheetsFromCollection = cheatSheetsCollection.getChildren();
        int nX = 0;
        while (nX < cheatSheetsFromCollection.length) {
            CheatSheetCollectionElement collection = (CheatSheetCollectionElement)((Object)cheatSheetsFromCollection[nX]);
            this.addCheatSheets(list, collection);
            ++nX;
        }
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        ArrayList list = new ArrayList(10);
        CheatSheetCollectionElement cheatSheetsCollection = (CheatSheetCollectionElement)CheatSheetRegistryReader.getInstance().getCheatSheets();
        this.addCheatSheets(list, cheatSheetsCollection);
        Composite composite = (Composite)super.createDialogArea(parent);
        this.createMessageArea(composite);
        this.listViewer = new ListViewer(composite, 2820);
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(10);
        data.widthHint = this.convertWidthInCharsToPixels(60);
        this.listViewer.getList().setLayoutData((Object)data);
        this.listViewer.setLabelProvider((IBaseLabelProvider)new LabelProvider(){

            public String getText(Object element) {
                return element == null ? "" : ((CheatSheetElement)((Object)element)).getLabel(null);
            }
        });
        SimpleListContentProvider cp = new SimpleListContentProvider();
        cp.setElements(list.toArray());
        this.listViewer.setContentProvider((IContentProvider)cp);
        this.listViewer.setInput(new Object());
        if (this.getInitialElementSelections() != null) {
            this.listViewer.setSelection((ISelection)new StructuredSelection(this.getInitialElementSelections()), true);
        }
        this.listViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                CheatSheetSelectionDialog.this.getOkButton().setEnabled(!event.getSelection().isEmpty());
            }
        });
        this.listViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                CheatSheetSelectionDialog.this.okPressed();
            }
        });
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.listViewer.getSelection();
        this.setResult(selection.toList());
        super.okPressed();
    }

    public class SimpleListContentProvider
    implements IStructuredContentProvider {
        private Object[] elements;

        public void dispose() {
        }

        public Object[] getElements(Object inputElement) {
            return this.elements;
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public void setElements(Object[] items) {
            this.elements = items;
        }
    }
}

