/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.launcher;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.launcher.JREResolution;
import org.eclipse.jdt.internal.debug.ui.launcher.LauncherMessages;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.ui.PlatformUI;

public class SelectDefaultSystemLibraryQuickFix
extends JREResolution {
    public void run(IMarker marker) {
        try {
            String title = LauncherMessages.getString("SelectDefaultSystemLibraryQuickFix.Select_Default_System_Library_1");
            String message = LauncherMessages.getString("SelectDefaultSystemLibraryQuickFix.&Select_the_system_library_to_use_by_default_for_building_and_running_Java_projects._2");
            final IVMInstall vm = this.chooseVMInstall(title, message);
            if (vm == null) {
                return;
            }
            IRunnableWithProgress runnable = new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        JavaRuntime.setDefaultVMInstall((IVMInstall)vm, (IProgressMonitor)monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            };
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(runnable);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() instanceof CoreException) {
                    throw (CoreException)e.getTargetException();
                }
                throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, LauncherMessages.getString("SelectDefaultSystemLibraryQuickFix.An_exception_occurred_while_updating_the_default_system_library._3"), e.getTargetException()));
            }
            catch (InterruptedException interruptedException) {
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.errorDialog(LauncherMessages.getString("SelectDefaultSystemLibraryQuickFix.Unable_to_update_the_default_system_library._4"), e.getStatus());
        }
    }

    public String getLabel() {
        return LauncherMessages.getString("SelectDefaultSystemLibraryQuickFix.Select_default_system_library_5");
    }
}

