/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.util.HashMap;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.IBreakpointManagerListener;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.ISuspendResume;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.debug.ui.actions.IRunToLineTarget;
import org.eclipse.jdt.core.dom.ASTParser;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.debug.core.IJavaDebugTarget;
import org.eclipse.jdt.debug.core.IJavaLineBreakpoint;
import org.eclipse.jdt.debug.core.JDIDebugModel;
import org.eclipse.jdt.internal.debug.ui.BreakpointUtils;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ValidBreakpointLocationLocator;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class RunToLineAdapter
implements IRunToLineTarget {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public void runToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) throws CoreException {
        IEditorPart editorPart = (IEditorPart)part;
        IEditorInput input = editorPart.getEditorInput();
        String errorMessage = null;
        if (input == null) {
            errorMessage = ActionMessages.getString("RunToLineAdapter.0");
        } else {
            ITextEditor textEditor = (ITextEditor)editorPart;
            final IDocument document = textEditor.getDocumentProvider().getDocument((Object)input);
            if (document == null) {
                errorMessage = ActionMessages.getString("RunToLineAdapter.1");
            } else {
                final int[] validLine = new int[1];
                final String[] typeName = new String[1];
                final int[] lineNumber = new int[1];
                final ITextSelection textSelection = (ITextSelection)selection;
                Runnable r = new Runnable(){

                    public void run() {
                        lineNumber[0] = textSelection.getStartLine() + 1;
                        ASTParser parser = ASTParser.newParser((int)2);
                        parser.setSource(document.get().toCharArray());
                        CompilationUnit compilationUnit = (CompilationUnit)parser.createAST(null);
                        ValidBreakpointLocationLocator locator = new ValidBreakpointLocationLocator(compilationUnit, lineNumber[0]);
                        compilationUnit.accept((ASTVisitor)locator);
                        validLine[0] = locator.getValidLocation();
                        typeName[0] = locator.getFullyQualifiedTypeName();
                    }
                };
                BusyIndicator.showWhile((Display)JDIDebugUIPlugin.getStandardDisplay(), (Runnable)r);
                if (validLine[0] == lineNumber[0]) {
                    IJavaLineBreakpoint breakpoint = null;
                    HashMap attributes = new HashMap(4);
                    BreakpointUtils.addRunToLineAttributes(attributes);
                    breakpoint = JDIDebugModel.createLineBreakpoint((IResource)ResourcesPlugin.getWorkspace().getRoot(), (String)typeName[0], (int)lineNumber[0], (int)-1, (int)-1, (int)1, (boolean)false, attributes);
                    errorMessage = ActionMessages.getString("RunToLineAdapter.2");
                    if (target instanceof IAdaptable) {
                        IDebugTarget debugTarget;
                        IAdaptable iAdaptable = (IAdaptable)target;
                        Class<?> clazz = class$0;
                        if (clazz == null) {
                            try {
                                clazz = class$0 = Class.forName("org.eclipse.debug.core.model.IDebugTarget");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        if ((debugTarget = (IDebugTarget)iAdaptable.getAdapter((Class)clazz)) != null) {
                            this.prepareSkipBreakpoints(debugTarget, (IBreakpoint)breakpoint);
                            debugTarget.getDebugTarget().breakpointAdded((IBreakpoint)breakpoint);
                            target.resume();
                            return;
                        }
                    }
                } else {
                    errorMessage = textSelection.getLength() > 0 ? ActionMessages.getString("RunToLineAdapter.3") : ActionMessages.getString("RunToLineAdapter.4");
                }
            }
        }
        throw new CoreException((IStatus)new Status(4, JDIDebugUIPlugin.getUniqueIdentifier(), 150, errorMessage, null));
    }

    protected void prepareSkipBreakpoints(IDebugTarget target, final IBreakpoint breakpoint) {
        final DebugPlugin plugin = DebugPlugin.getDefault();
        final IBreakpointManager manager = plugin.getBreakpointManager();
        if (!manager.isEnabled() || !DebugUIPlugin.getDefault().getPluginPreferences().getBoolean(IDebugUIConstants.PREF_SKIP_BREAKPOINTS_DURING_RUN_TO_LINE)) {
            return;
        }
        manager.setEnabled(false);
        final IDebugEventSetListener debugEventListener = new IDebugEventSetListener(){

            public void handleDebugEvents(DebugEvent[] events) {
                int i = 0;
                while (i < events.length) {
                    DebugEvent event = events[i];
                    Object source = event.getSource();
                    if (source instanceof IThread && event.getKind() == 2 && event.getDetail() == 16) {
                        IBreakpoint[] breakpoints = ((IThread)source).getBreakpoints();
                        int j = 0;
                        while (j < breakpoints.length) {
                            if (breakpoints[j] == breakpoint) {
                                manager.setEnabled(true);
                            }
                            ++j;
                        }
                    } else if (source instanceof IDebugTarget && event.getKind() == 8) {
                        manager.setEnabled(true);
                    }
                    ++i;
                }
            }
        };
        plugin.addDebugEventListener(debugEventListener);
        manager.addBreakpointManagerListener(new IBreakpointManagerListener(){

            public void breakpointManagerEnablementChanged(boolean enabled) {
                plugin.removeDebugEventListener(debugEventListener);
            }
        });
    }

    public boolean canRunToLine(IWorkbenchPart part, ISelection selection, ISuspendResume target) {
        if (target instanceof IDebugElement) {
            IJavaDebugTarget adapter;
            IDebugElement element = (IDebugElement)target;
            IDebugTarget iDebugTarget = element.getDebugTarget();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.debug.core.IJavaDebugTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            return (adapter = (IJavaDebugTarget)iDebugTarget.getAdapter((Class)clazz)) != null;
        }
        return false;
    }
}

