/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jdt.debug.core.IJavaBreakpoint;
import org.eclipse.jdt.debug.core.IJavaClassType;
import org.eclipse.jdt.debug.core.IJavaExceptionBreakpoint;
import org.eclipse.jdt.debug.core.IJavaFieldVariable;
import org.eclipse.jdt.debug.core.IJavaObject;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.debug.core.IJavaWatchpoint;
import org.eclipse.jdt.internal.debug.ui.IJavaDebugHelpContextIds;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.actions.ActionMessages;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class InstanceFiltersAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection == null || selection.size() > 1) {
            return;
        }
        Object o = selection.getFirstElement();
        if (o instanceof IJavaVariable) {
            final IJavaVariable var = (IJavaVariable)o;
            try {
                IValue value = var.getValue();
                if (value instanceof IJavaObject) {
                    Object[] selectedBreakpoints;
                    final IJavaObject object = (IJavaObject)value;
                    final List breakpoints = this.getApplicableBreakpoints(var, object);
                    IStructuredContentProvider content = new IStructuredContentProvider(){

                        public void dispose() {
                        }

                        public Object[] getElements(Object input) {
                            return breakpoints.toArray();
                        }

                        public void inputChanged(Viewer viewer, Object a, Object b) {
                        }
                    };
                    final IDebugModelPresentation modelPresentation = DebugUITools.newDebugModelPresentation();
                    InstanceFilterDialog dialog = new InstanceFilterDialog(JDIDebugUIPlugin.getActiveWorkbenchShell(), breakpoints, content, (ILabelProvider)modelPresentation, MessageFormat.format(ActionMessages.getString("InstanceFiltersAction.1"), var.getName())){

                        public void okPressed() {
                            Object[] checkBreakpoint = this.getViewer().getCheckedElements();
                            int k = 0;
                            while (k < checkBreakpoint.length) {
                                block7: {
                                    IJavaBreakpoint breakpoint = (IJavaBreakpoint)checkBreakpoint[k];
                                    try {
                                        IJavaObject[] instanceFilters = breakpoint.getInstanceFilters();
                                        boolean sameTarget = false;
                                        int i = 0;
                                        while (i < instanceFilters.length) {
                                            IJavaObject instanceFilter = instanceFilters[i];
                                            if (instanceFilter.getDebugTarget().equals(object.getDebugTarget())) {
                                                sameTarget = true;
                                                break;
                                            }
                                            ++i;
                                        }
                                        if (!sameTarget) break block7;
                                        MessageDialog messageDialog = new MessageDialog(JDIDebugUIPlugin.getActiveWorkbenchShell(), ActionMessages.getString("InstanceFiltersAction.2"), null, MessageFormat.format(ActionMessages.getString("InstanceFiltersAction.3"), modelPresentation.getText((Object)breakpoint), var.getName()), 3, new String[]{ActionMessages.getString("InstanceFiltersAction.Yes_2"), ActionMessages.getString("InstanceFiltersAction.Cancel_3")}, 0);
                                        if (messageDialog.open() == 0) {
                                            int i2 = 0;
                                            while (i2 < instanceFilters.length) {
                                                breakpoint.removeInstanceFilter(instanceFilters[i2]);
                                                ++i2;
                                            }
                                            break block7;
                                        }
                                        return;
                                    }
                                    catch (CoreException e) {
                                        JDIDebugUIPlugin.log(e);
                                    }
                                }
                                ++k;
                            }
                            super.okPressed();
                        }
                    };
                    dialog.setTitle(ActionMessages.getString("InstanceFiltersAction.2"));
                    ArrayList<IJavaBreakpoint> existing = new ArrayList<IJavaBreakpoint>();
                    Iterator iter = breakpoints.iterator();
                    block2: while (iter.hasNext()) {
                        IJavaBreakpoint bp = (IJavaBreakpoint)iter.next();
                        IJavaObject[] filters = bp.getInstanceFilters();
                        int i = 0;
                        while (i < filters.length) {
                            if (filters[i].equals(object)) {
                                existing.add(bp);
                                continue block2;
                            }
                            ++i;
                        }
                    }
                    dialog.setInitialSelections(existing.toArray());
                    if (dialog.open() == 0 && (selectedBreakpoints = dialog.getResult()) != null) {
                        int i = 0;
                        while (i < selectedBreakpoints.length) {
                            IJavaBreakpoint bp = (IJavaBreakpoint)selectedBreakpoints[i];
                            bp.addInstanceFilter(object);
                            existing.remove(bp);
                            ++i;
                        }
                        iter = existing.iterator();
                        while (iter.hasNext()) {
                            IJavaBreakpoint bp = (IJavaBreakpoint)iter.next();
                            bp.removeInstanceFilter(object);
                        }
                    }
                }
            }
            catch (CoreException e) {
                JDIDebugUIPlugin.log(e);
            }
        }
    }

    protected List getApplicableBreakpoints(IJavaVariable variable, IJavaObject object) {
        ArrayList<IJavaBreakpoint> breakpoints = new ArrayList<IJavaBreakpoint>();
        try {
            ArrayList<String> superTypeNames = new ArrayList<String>();
            IJavaType type = object.getJavaType();
            while (type instanceof IJavaClassType) {
                superTypeNames.add(type.getName());
                type = ((IJavaClassType)type).getSuperclass();
            }
            IBreakpoint[] allBreakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints();
            int i = 0;
            while (i < allBreakpoints.length) {
                if (allBreakpoints[i] instanceof IJavaBreakpoint) {
                    IJavaBreakpoint jbp = (IJavaBreakpoint)allBreakpoints[i];
                    IJavaBreakpoint valid = null;
                    if (jbp instanceof IJavaWatchpoint && variable instanceof IJavaFieldVariable) {
                        IJavaWatchpoint wp = (IJavaWatchpoint)jbp;
                        IJavaFieldVariable fv = (IJavaFieldVariable)variable;
                        if (variable.getName().equals(wp.getFieldName()) && fv.getDeclaringType().getName().equals(wp.getTypeName())) {
                            valid = wp;
                        }
                    } else if (superTypeNames.contains(jbp.getTypeName()) || jbp instanceof IJavaExceptionBreakpoint) {
                        valid = jbp;
                    }
                    if (valid != null && valid.supportsInstanceFilters()) {
                        breakpoints.add(valid);
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            JDIDebugUIPlugin.log(e);
        }
        return breakpoints;
    }

    class InstanceFilterDialog
    extends ListSelectionDialog {
        public InstanceFilterDialog(Shell parentShell, Object input, IStructuredContentProvider contentProvider, ILabelProvider labelProvider, String message) {
            super(parentShell, input, contentProvider, labelProvider, message);
        }

        protected Control createDialogArea(Composite parent) {
            Control control = super.createDialogArea(parent);
            WorkbenchHelp.setHelp((Control)parent, (String)IJavaDebugHelpContextIds.INSTANCE_BREAKPOINT_SELECTION_DIALOG);
            return control;
        }
    }
}

