/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.ui.actions;

import org.eclipse.debug.core.DebugException;
import org.eclipse.jdt.debug.core.IJavaType;
import org.eclipse.jdt.debug.core.IJavaValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.ui.DetailFormatter;
import org.eclipse.jdt.internal.debug.ui.DetailFormatterDialog;
import org.eclipse.jdt.internal.debug.ui.JDIDebugUIPlugin;
import org.eclipse.jdt.internal.debug.ui.JavaDetailFormattersManager;
import org.eclipse.jdt.internal.debug.ui.actions.ObjectActionDelegate;
import org.eclipse.jdt.internal.debug.ui.display.JavaInspectExpression;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;

public class EditDetailFormatterAction
extends ObjectActionDelegate {
    public void run(IAction action) {
        IJavaType type;
        IStructuredSelection selection = this.getCurrentSelection();
        if (selection.size() != 1) {
            return;
        }
        Object element = selection.getFirstElement();
        try {
            IJavaValue value;
            if (element instanceof IJavaVariable) {
                value = (IJavaValue)((IJavaVariable)element).getValue();
            } else if (element instanceof JavaInspectExpression) {
                value = (IJavaValue)((JavaInspectExpression)((Object)element)).getValue();
            } else {
                return;
            }
            type = value.getJavaType();
        }
        catch (DebugException debugException) {
            return;
        }
        JavaDetailFormattersManager detailFormattersManager = JavaDetailFormattersManager.getDefault();
        DetailFormatter detailFormatter = detailFormattersManager.getAssociatedDetailFormatter(type);
        if (new DetailFormatterDialog(JDIDebugUIPlugin.getActivePage().getWorkbenchWindow().getShell(), detailFormatter, null, false, true).open() == 0) {
            detailFormattersManager.setAssociatedDetailFormatter(detailFormatter);
        }
    }
}

