/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.views.actions;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.ant.internal.ui.model.AntUIImages;
import org.eclipse.ant.internal.ui.views.AntView;
import org.eclipse.ant.internal.ui.views.actions.AntViewActionMessages;
import org.eclipse.ant.internal.ui.views.actions.SearchForBuildFilesDialog;
import org.eclipse.ant.internal.ui.views.elements.ProjectNode;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class SearchForBuildFilesAction
extends Action {
    private AntView view;

    public SearchForBuildFilesAction(AntView view) {
        super(AntViewActionMessages.getString("SearchForBuildFilesAction.Search_1"), AntUIImages.getImageDescriptor("org.eclipse.ant.ui.search"));
        this.setToolTipText(AntViewActionMessages.getString("SearchForBuildFilesAction.Add_build_files_with_search_2"));
        this.view = view;
        WorkbenchHelp.setHelp((IAction)this, (String)"org.eclipse.ant.ui.search_for_buildfiles_action_context");
    }

    public void run() {
        SearchForBuildFilesDialog dialog = new SearchForBuildFilesDialog();
        if (dialog.open() != 1) {
            final IFile[] files = dialog.getResults();
            final boolean includeErrorNodes = dialog.getIncludeErrorResults();
            final ProjectNode[] existingProjects = this.view.getProjects();
            try {
                PlatformUI.getWorkbench().getProgressService().busyCursorWhile(new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        monitor.beginTask(AntViewActionMessages.getString("SearchForBuildFilesAction.Processing_search_results_3"), files.length);
                        int i = 0;
                        while (i < files.length && !monitor.isCanceled()) {
                            String buildFileName = files[i].getFullPath().toString();
                            monitor.subTask(MessageFormat.format(AntViewActionMessages.getString("SearchForBuildFilesAction.Adding_{0}_4"), buildFileName));
                            if (!this.alreadyAdded(buildFileName)) {
                                ProjectNode project = new ProjectNode(buildFileName);
                                project.getName();
                                monitor.worked(1);
                                if (includeErrorNodes || !project.isErrorNode()) {
                                    Display.getDefault().asyncExec(new Runnable(this, project){
                                        final /* synthetic */ 1 this$1;
                                        private final /* synthetic */ ProjectNode val$project;
                                        {
                                            this.this$1 = var1_1;
                                            this.val$project = projectNode;
                                        }

                                        public void run() {
                                            SearchForBuildFilesAction.access$0(1.access$0(this.this$1)).addProject(this.val$project);
                                        }
                                    });
                                }
                            }
                            ++i;
                        }
                    }

                    private boolean alreadyAdded(String buildFileName) {
                        int j = 0;
                        while (j < existingProjects.length) {
                            ProjectNode existingProject = existingProjects[j];
                            if (existingProject.getBuildFileName().equals(buildFileName)) {
                                return true;
                            }
                            ++j;
                        }
                        return false;
                    }

                    static /* synthetic */ SearchForBuildFilesAction access$0(1 var0) {
                        return var0.SearchForBuildFilesAction.this;
                    }
                });
            }
            catch (InvocationTargetException invocationTargetException) {
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    static /* synthetic */ AntView access$0(SearchForBuildFilesAction searchForBuildFilesAction) {
        return searchForBuildFilesAction.view;
    }
}

