/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.launchConfigurations;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.internal.ui.launchConfigurations.AntLaunchConfigurationMessages;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.jdt.internal.launching.AbstractRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IJavaLaunchConfigurationConstants;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class ContributedClasspathEntriesEntry
extends AbstractRuntimeClasspathEntry {
    public static final String TYPE_ID = "org.eclipse.ant.ui.classpathentry.extraClasspathEntries";

    protected void buildMemento(Document document, Element memento) throws CoreException {
    }

    public void initializeFrom(Element memento) throws CoreException {
    }

    public String getTypeId() {
        return TYPE_ID;
    }

    public IRuntimeClasspathEntry[] getRuntimeClasspathEntries(ILaunchConfiguration configuration) throws CoreException {
        IAntClasspathEntry entry;
        boolean separateVM = configuration.getAttribute(IJavaLaunchConfigurationConstants.ATTR_VM_INSTALL_TYPE, null) != null;
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        IAntClasspathEntry[] antClasspathEntries = prefs.getContributedClasspathEntries();
        IAntClasspathEntry[] userEntries = prefs.getAdditionalClasspathEntries();
        ArrayList<IRuntimeClasspathEntry> rtes = new ArrayList<IRuntimeClasspathEntry>(antClasspathEntries.length + userEntries.length);
        int i = 0;
        while (i < antClasspathEntries.length) {
            entry = antClasspathEntries[i];
            if (!separateVM || separateVM && !entry.isEclipseRuntimeRequired()) {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)entry.getLabel()));
            }
            ++i;
        }
        boolean haveToolsEntry = false;
        int i2 = 0;
        while (i2 < userEntries.length) {
            entry = userEntries[i2];
            String path = entry.getLabel();
            if (path.endsWith("tools.jar")) {
                haveToolsEntry = true;
                this.addToolsJar(configuration, rtes, path);
            } else {
                rtes.add(JavaRuntime.newStringVariableClasspathEntry((String)path));
            }
            ++i2;
        }
        if (!haveToolsEntry) {
            this.addToolsJar(configuration, rtes, null);
        }
        return rtes.toArray(new IRuntimeClasspathEntry[rtes.size()]);
    }

    private void addToolsJar(ILaunchConfiguration configuration, List rtes, String path) {
        IRuntimeClasspathEntry tools = this.getToolsJar(configuration);
        if (tools == null) {
            if (path != null) {
                rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(path)));
            } else {
                IAntClasspathEntry entry;
                IVMInstall install = JavaRuntime.getDefaultVMInstall();
                if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                    rtes.add(JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(entry.getEntryURL().getPath())));
                }
            }
        } else {
            rtes.add(tools);
        }
    }

    private IRuntimeClasspathEntry getToolsJar(ILaunchConfiguration configuration) {
        try {
            IAntClasspathEntry entry;
            IVMInstall install = JavaRuntime.computeVMInstall((ILaunchConfiguration)configuration);
            if (install != null && (entry = AntCorePlugin.getPlugin().getPreferences().getToolsJarEntry((IPath)new Path(install.getInstallLocation().getAbsolutePath()))) != null) {
                return JavaRuntime.newArchiveRuntimeClasspathEntry((IPath)new Path(entry.getEntryURL().getPath()));
            }
        }
        catch (CoreException coreException) {}
        return null;
    }

    public String getName() {
        return AntLaunchConfigurationMessages.getString("ContributedClasspathEntriesEntry.1");
    }

    public int getType() {
        return 5;
    }

    public boolean isComposite() {
        return true;
    }

    public boolean equals(Object obj) {
        return obj instanceof ContributedClasspathEntriesEntry;
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

