/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.ui.editor.text;

import org.eclipse.ant.internal.ui.model.AntUIPlugin;
import org.eclipse.ant.internal.ui.model.ColorManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.StringConverter;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;

public abstract class AbstractAntEditorScanner
extends RuleBasedScanner {
    protected void adaptToColorChange(PropertyChangeEvent event, Token token) {
        RGB rgb = null;
        Object value = event.getNewValue();
        if (value instanceof RGB) {
            rgb = (RGB)value;
        } else if (value instanceof String) {
            rgb = StringConverter.asRGB((String)((String)value));
        }
        if (rgb != null) {
            TextAttribute attr = (TextAttribute)token.getData();
            token.setData((Object)new TextAttribute(ColorManager.getDefault().getColor(rgb), attr.getBackground(), attr.getStyle()));
        }
    }

    protected void adaptToStyleChange(PropertyChangeEvent event, Token token, int styleAttribute) {
        boolean activeValue;
        if (token == null) {
            return;
        }
        boolean eventValue = false;
        Object value = event.getNewValue();
        if (value instanceof Boolean) {
            eventValue = (Boolean)value;
        } else if ("true".equals(value)) {
            eventValue = true;
        }
        TextAttribute attr = (TextAttribute)token.getData();
        boolean bl = activeValue = (attr.getStyle() & styleAttribute) == styleAttribute;
        if (activeValue != eventValue) {
            token.setData((Object)new TextAttribute(attr.getForeground(), attr.getBackground(), eventValue ? attr.getStyle() | styleAttribute : attr.getStyle() & ~styleAttribute));
        }
    }

    protected TextAttribute createTextAttribute(String colorID, String boldKey, String italicKey) {
        IPreferenceStore store;
        int style;
        Color color = null;
        if (colorID != null) {
            color = AntUIPlugin.getPreferenceColor(colorID);
        }
        int n = style = (store = AntUIPlugin.getDefault().getPreferenceStore()).getBoolean(boldKey) ? 1 : 0;
        if (store.getBoolean(italicKey)) {
            style |= 2;
        }
        return new TextAttribute(color, null, style);
    }
}

