/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.Assert;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.IAnnotationModelExtension;
import org.eclipse.jface.text.source.IAnnotationModelListener;
import org.eclipse.jface.text.source.IChangeRulerColumn;
import org.eclipse.jface.text.source.ILineDiffInfo;
import org.eclipse.jface.text.source.ILineDiffer;
import org.eclipse.jface.text.source.ISharedTextColors;
import org.eclipse.jface.text.source.IVerticalRulerInfo;
import org.eclipse.jface.text.source.IVerticalRulerInfoExtension;
import org.eclipse.jface.text.source.IVerticalRulerListener;
import org.eclipse.jface.text.source.LineNumberRulerColumn;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;

public final class LineNumberChangeRulerColumn
extends LineNumberRulerColumn
implements IVerticalRulerInfo,
IVerticalRulerInfoExtension,
IChangeRulerColumn {
    private static final int fTriangleWidth = 7;
    private static final int fTriangleHeight = 3;
    private Color fAddedColor;
    private Color fChangedColor;
    private Color fDeletedColor;
    IAnnotationModel fAnnotationModel;
    private IAnnotationHover fHover;
    private AnnotationListener fAnnotationListener = new AnnotationListener();
    private boolean fCharacterDisplay;
    private ISharedTextColors fSharedColors;

    private static RGB interpolate(RGB fg, RGB bg, double scale) {
        return new RGB((int)((1.0 - scale) * (double)fg.red + scale * (double)bg.red), (int)((1.0 - scale) * (double)fg.green + scale * (double)bg.green), (int)((1.0 - scale) * (double)fg.blue + scale * (double)bg.blue));
    }

    private static double greyLevel(RGB rgb) {
        if (rgb.red == rgb.green && rgb.green == rgb.blue) {
            return rgb.red;
        }
        return 0.299 * (double)rgb.red + 0.587 * (double)rgb.green + 0.114 * (double)rgb.blue + 0.5;
    }

    private static boolean isDark(RGB rgb) {
        return LineNumberChangeRulerColumn.greyLevel(rgb) > 128.0;
    }

    public LineNumberChangeRulerColumn(ISharedTextColors sharedColors) {
        Assert.isNotNull((Object)sharedColors);
        this.fSharedColors = sharedColors;
    }

    protected void handleDispose() {
        if (this.fAnnotationModel != null) {
            this.fAnnotationModel.removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            this.fAnnotationModel = null;
        }
        super.handleDispose();
    }

    protected void paintLine(int line, int y, int lineheight, GC gc, Display display) {
        ILineDiffInfo info = this.getDiffInfo(line);
        if (info != null) {
            int width = this.getWidth();
            if (this.hasSpecialColor(info)) {
                gc.setBackground(this.getColor(info, display));
                gc.fillRectangle(0, y, width, lineheight);
            }
            int delBefore = info.getRemovedLinesAbove();
            int delBelow = info.getRemovedLinesBelow();
            if (delBefore > 0 || delBelow > 0) {
                Color deletionColor = this.getDeletionColor(display);
                gc.setBackground(deletionColor);
                gc.setForeground(deletionColor);
                int[] triangle = new int[]{width - 7, y, width, y - 3, width, y + 3};
                if (delBefore > 0) {
                    gc.drawLine(0, y, width, y);
                    gc.fillPolygon(triangle);
                }
                if (delBelow > 0) {
                    triangle[1] = triangle[1] + lineheight;
                    triangle[3] = triangle[3] + lineheight;
                    triangle[5] = triangle[5] + lineheight;
                    gc.drawLine(0, y + lineheight, width, y + lineheight);
                    gc.fillPolygon(triangle);
                }
                gc.setForeground(this.getForeground());
            }
        }
    }

    private boolean hasSpecialColor(ILineDiffInfo info) {
        return info.getChangeType() == 1 || info.getChangeType() == 2;
    }

    private ILineDiffInfo getDiffInfo(int line) {
        if (this.fAnnotationModel == null) {
            return null;
        }
        if (this.fAnnotationModel instanceof ILineDiffer) {
            ILineDiffer differ = (ILineDiffer)this.fAnnotationModel;
            return differ.getLineInfo(line);
        }
        return null;
    }

    private Color getDeletionColor(Display display) {
        return this.fDeletedColor == null ? this.getBackground(display) : this.fDeletedColor;
    }

    private Color getColor(ILineDiffInfo info, Display display) {
        Assert.isTrue((info != null && info.getChangeType() != 0 ? 1 : 0) != 0);
        Color ret = null;
        switch (info.getChangeType()) {
            case 2: {
                ret = this.getShadedColor(this.fChangedColor, display);
                break;
            }
            case 1: {
                ret = this.getShadedColor(this.fAddedColor, display);
            }
        }
        return ret == null ? this.getBackground(display) : ret;
    }

    private String getDisplayCharacter(ILineDiffInfo info) {
        if (info == null) {
            return "";
        }
        switch (info.getChangeType()) {
            case 2: {
                return "~";
            }
            case 1: {
                return "+";
            }
        }
        return " ";
    }

    public int getLineOfLastMouseButtonActivity() {
        return this.getParentRuler().getLineOfLastMouseButtonActivity();
    }

    public int toDocumentLineNumber(int y_coordinate) {
        return this.getParentRuler().toDocumentLineNumber(y_coordinate);
    }

    public IAnnotationHover getHover() {
        return this.fHover;
    }

    public void setHover(IAnnotationHover hover) {
        this.fHover = hover;
    }

    public void setModel(IAnnotationModel model) {
        IAnnotationModel newModel = model instanceof IAnnotationModelExtension ? ((IAnnotationModelExtension)model).getAnnotationModel((Object)"diff") : model;
        if (this.fAnnotationModel != newModel) {
            if (this.fAnnotationModel != null) {
                this.fAnnotationModel.removeAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.fAnnotationModel = newModel;
            if (this.fAnnotationModel != null) {
                this.fAnnotationModel.addAnnotationModelListener((IAnnotationModelListener)this.fAnnotationListener);
            }
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
            this.postRedraw();
        }
    }

    public void setAddedColor(Color addedColor) {
        this.fAddedColor = addedColor;
    }

    public void setChangedColor(Color changedColor) {
        this.fChangedColor = changedColor;
    }

    private Color getShadedColor(Color color, Display display) {
        if (color == null) {
            return null;
        }
        RGB baseRGB = color.getRGB();
        RGB background = this.getBackground(display).getRGB();
        boolean darkBase = LineNumberChangeRulerColumn.isDark(baseRGB);
        boolean darkBackground = LineNumberChangeRulerColumn.isDark(background);
        if (darkBase && darkBackground) {
            background = new RGB(255, 255, 255);
        } else if (!darkBase && !darkBackground) {
            background = new RGB(0, 0, 0);
        }
        return this.fSharedColors.getColor(LineNumberChangeRulerColumn.interpolate(baseRGB, background, 0.6));
    }

    public void setDeletedColor(Color deletedColor) {
        this.fDeletedColor = deletedColor;
    }

    public void setDisplayMode(boolean characterMode) {
        if (characterMode != this.fCharacterDisplay) {
            this.fCharacterDisplay = characterMode;
            this.updateNumberOfDigits();
            this.computeIndentations();
            this.layout(true);
        }
    }

    public IAnnotationModel getModel() {
        return this.fAnnotationModel;
    }

    protected String createDisplayString(int line) {
        if (this.fCharacterDisplay && this.getModel() != null) {
            return String.valueOf(super.createDisplayString(line)) + this.getDisplayCharacter(this.getDiffInfo(line));
        }
        return super.createDisplayString(line);
    }

    protected int computeNumberOfDigits() {
        if (this.fCharacterDisplay && this.getModel() != null) {
            return super.computeNumberOfDigits() + 1;
        }
        return super.computeNumberOfDigits();
    }

    public void addVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeVerticalRulerListener(IVerticalRulerListener listener) {
        throw new UnsupportedOperationException();
    }

    class AnnotationListener
    implements IAnnotationModelListener {
        AnnotationListener() {
        }

        public void modelChanged(IAnnotationModel model) {
            LineNumberChangeRulerColumn.this.postRedraw();
        }
    }
}

