/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.client.listeners;

import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.team.internal.ccvs.core.CVSException;
import org.eclipse.team.internal.ccvs.core.CVSProviderPlugin;
import org.eclipse.team.internal.ccvs.core.CVSStatus;
import org.eclipse.team.internal.ccvs.core.ICVSFolder;
import org.eclipse.team.internal.ccvs.core.ICVSRepositoryLocation;
import org.eclipse.team.internal.ccvs.core.Policy;
import org.eclipse.team.internal.ccvs.core.client.CommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ICommandOutputListener;
import org.eclipse.team.internal.ccvs.core.client.listeners.ServerMessageLineMatcher;

public class CompareDiffListener
extends CommandOutputListener {
    private static ServerMessageLineMatcher LOCAL_FILE_MATCHER;
    private static ServerMessageLineMatcher REMOTE_FILE_MATCHER;
    private static ServerMessageLineMatcher REVISION_LINE_MATCHER;
    private String localFilePath;
    private String remoteFilePath;
    private String leftRevision;
    private String rightRevision;
    private IFileDiffListener listener;

    static {
        try {
            LOCAL_FILE_MATCHER = new ServerMessageLineMatcher("Index: (localFile:.*:localFile)", new String[]{"localFile"});
            REMOTE_FILE_MATCHER = new ServerMessageLineMatcher("RCS file: (remoteFile:.*:remoteFile),v", new String[]{"remoteFile"});
            REVISION_LINE_MATCHER = new ServerMessageLineMatcher("diff .* -r(leftRevision:.*:leftRevision) -r(rightRevision:.*:rightRevision)", new String[]{"leftRevision", "rightRevision"});
        }
        catch (CVSException e) {
            CVSProviderPlugin.log((CoreException)((Object)e));
            LOCAL_FILE_MATCHER = null;
            REMOTE_FILE_MATCHER = null;
            REVISION_LINE_MATCHER = null;
        }
    }

    public CompareDiffListener(IFileDiffListener listener) {
        this.listener = listener;
    }

    public IStatus messageLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (this.getServerMessage(line, location) != null) {
            return ICommandOutputListener.OK;
        }
        Map map = LOCAL_FILE_MATCHER.processServerMessage(line);
        if (map != null) {
            this.localFilePath = (String)map.get("localFile");
            return ICommandOutputListener.OK;
        }
        map = REMOTE_FILE_MATCHER.processServerMessage(line);
        if (map != null) {
            this.remoteFilePath = (String)map.get("remoteFile");
            return ICommandOutputListener.OK;
        }
        map = REVISION_LINE_MATCHER.processServerMessage(line);
        if (map != null) {
            this.leftRevision = (String)map.get("leftRevision");
            this.rightRevision = (String)map.get("rightRevision");
            if (this.localFilePath == null || this.remoteFilePath == null) {
                return new CVSStatus(4, Policy.bind("CompareDiffListener.11"));
            }
            this.listener.fileDiff(this.localFilePath, this.remoteFilePath, this.leftRevision, this.rightRevision);
            this.rightRevision = null;
            this.leftRevision = null;
            this.remoteFilePath = null;
            this.localFilePath = null;
            return ICommandOutputListener.OK;
        }
        return ICommandOutputListener.OK;
    }

    private IStatus handleUnknownDiffFormat(String line) {
        return new CVSStatus(4, Policy.bind("CompareDiffListener.12", line));
    }

    public IStatus errorLine(String line, ICVSRepositoryLocation location, ICVSFolder commandRoot, IProgressMonitor monitor) {
        if (this.getServerMessage(line, location) != null) {
            return ICommandOutputListener.OK;
        }
        return super.errorLine(line, location, commandRoot, monitor);
    }

    public interface IFileDiffListener {
        public void fileDiff(String var1, String var2, String var3, String var4);
    }
}

