/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.debug.core.breakpoints;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.InvalidLineNumberException;
import com.sun.jdi.Location;
import com.sun.jdi.NativeMethodException;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.jdt.debug.core.IJavaStratumLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.JDIDebugPlugin;
import org.eclipse.jdt.internal.debug.core.breakpoints.JDIDebugBreakpointMessages;
import org.eclipse.jdt.internal.debug.core.breakpoints.JavaLineBreakpoint;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class JavaStratumLineBreakpoint
extends JavaLineBreakpoint
implements IJavaStratumLineBreakpoint {
    private static final String PATTERN = "org.eclipse.jdt.debug.pattern";
    private static final String STRATUM = "org.eclipse.jdt.debug.stratum";
    private static final String SOURCE_PATH = "org.eclipse.jdt.debug.source_path";
    private static final String STRATUM_BREAKPOINT = "org.eclipse.jdt.debug.javaStratumLineBreakpointMarker";

    public JavaStratumLineBreakpoint() {
    }

    public JavaStratumLineBreakpoint(IResource resource, String stratum, String sourceName, String sourcePath, String classNamePattern, int lineNumber, int charStart, int charEnd, int hitCount, boolean register, Map attributes) throws DebugException {
        this(resource, stratum, sourceName, sourcePath, classNamePattern, lineNumber, charStart, charEnd, hitCount, register, attributes, STRATUM_BREAKPOINT);
    }

    protected JavaStratumLineBreakpoint(final IResource resource, final String stratum, final String sourceName, final String sourcePath, final String classNamePattern, final int lineNumber, final int charStart, final int charEnd, final int hitCount, final boolean register, final Map attributes, final String markerType) throws DebugException {
        IWorkspaceRunnable wr = new IWorkspaceRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                JavaStratumLineBreakpoint.this.setMarker(resource.createMarker(markerType));
                String pattern = classNamePattern;
                if (pattern != null && pattern.length() == 0) {
                    pattern = null;
                }
                JavaStratumLineBreakpoint.this.addLineBreakpointAttributes(attributes, JavaStratumLineBreakpoint.this.getModelIdentifier(), true, lineNumber, charStart, charEnd);
                JavaStratumLineBreakpoint.this.addStratumPatternAndHitCount(attributes, stratum, sourceName, sourcePath, pattern, hitCount);
                JavaStratumLineBreakpoint.this.ensureMarker().setAttributes(attributes);
                JavaStratumLineBreakpoint.this.register(register);
            }
        };
        this.run(null, wr);
    }

    protected void addStratumPatternAndHitCount(Map attributes, String stratum, String sourceName, String sourcePath, String pattern, int hitCount) {
        attributes.put(PATTERN, pattern);
        attributes.put(STRATUM, stratum);
        if (sourceName != null) {
            attributes.put("org.eclipse.jdt.debug.core.sourceName", sourceName);
        }
        if (sourcePath != null) {
            attributes.put(SOURCE_PATH, sourcePath);
        }
        if (hitCount > 0) {
            attributes.put("org.eclipse.jdt.debug.core.hitCount", new Integer(hitCount));
            attributes.put("org.eclipse.jdt.debug.core.expired", Boolean.FALSE);
        }
    }

    protected boolean installableReferenceType(ReferenceType type, JDIDebugTarget target) throws CoreException {
        String bpSourcePath;
        String typeName = type.name();
        if (!this.validType(typeName)) {
            return false;
        }
        String stratum = this.getStratum();
        String bpSourceName = this.getSourceName();
        if (bpSourceName != null) {
            List<String> sourceNames;
            try {
                sourceNames = type.sourceNames(stratum);
            }
            catch (AbsentInformationException absentInformationException) {
                return false;
            }
            if (!this.containsMatch(sourceNames, bpSourceName)) {
                return false;
            }
        }
        if ((bpSourcePath = this.getSourcePath()) != null) {
            List<String> sourcePaths;
            try {
                sourcePaths = type.sourcePaths(stratum);
            }
            catch (AbsentInformationException absentInformationException) {
                return false;
            }
            if (!this.containsMatch(sourcePaths, bpSourcePath)) {
                return false;
            }
        }
        return this.queryInstallListeners(target, type);
    }

    private boolean containsMatch(List strings, String key) {
        Iterator iter = strings.iterator();
        while (iter.hasNext()) {
            if (!((String)iter.next()).equals(key)) continue;
            return true;
        }
        return false;
    }

    private boolean validType(String typeName) throws CoreException {
        String pattern = this.getPattern();
        if (pattern.charAt(0) == '*') {
            if (pattern.length() == 1) {
                return true;
            }
            return typeName.endsWith(pattern.substring(1));
        }
        int length = pattern.length();
        if (pattern.charAt(length - 1) == '*') {
            return typeName.startsWith(pattern.substring(0, length - 1));
        }
        return typeName.startsWith(pattern);
    }

    protected Location determineLocation(int lineNumber, ReferenceType type) {
        String sourcePath;
        List<Location> locations;
        try {
            locations = type.locationsOfLine(this.getStratum(), this.getSourceName(), lineNumber);
            sourcePath = this.getSourcePath();
        }
        catch (AbsentInformationException absentInformationException) {
            Status status = new Status(4, JDIDebugPlugin.getUniqueIdentifier(), 162, JDIDebugBreakpointMessages.getString("JavaLineBreakpoint.Absent_Line_Number_Information_1"), null);
            IStatusHandler handler = DebugPlugin.getDefault().getStatusHandler((IStatus)status);
            if (handler != null) {
                try {
                    handler.handleStatus((IStatus)status, (Object)type);
                }
                catch (CoreException coreException) {}
            }
            return null;
        }
        catch (NativeMethodException nativeMethodException) {
            return null;
        }
        catch (InvalidLineNumberException invalidLineNumberException) {
            return null;
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            return null;
        }
        catch (RuntimeException e) {
            JDIDebugPlugin.log(e);
            return null;
        }
        catch (CoreException e) {
            JDIDebugPlugin.log(e);
            return null;
        }
        if (sourcePath == null) {
            if (locations.size() > 0) {
                return locations.get(0);
            }
        } else {
            Iterator<Location> iter = locations.iterator();
            while (iter.hasNext()) {
                Location location = iter.next();
                try {
                    if (!sourcePath.equals(location.sourcePath())) continue;
                    return location;
                }
                catch (AbsentInformationException absentInformationException) {}
            }
        }
        return null;
    }

    public String getPattern() throws CoreException {
        return this.ensureMarker().getAttribute(PATTERN, "*");
    }

    public String getSourceName() throws CoreException {
        return (String)this.ensureMarker().getAttribute("org.eclipse.jdt.debug.core.sourceName");
    }

    public String getStratum() throws CoreException {
        return (String)this.ensureMarker().getAttribute(STRATUM);
    }

    public String getSourcePath() throws CoreException {
        return (String)this.ensureMarker().getAttribute(SOURCE_PATH);
    }

    protected void createRequests(JDIDebugTarget target) throws CoreException {
        String referenceTypeName;
        if (target.isTerminated() || this.shouldSkipBreakpoint()) {
            return;
        }
        try {
            referenceTypeName = this.getPattern();
        }
        catch (CoreException e) {
            JDIDebugPlugin.log(e);
            return;
        }
        String classPrepareTypeName = referenceTypeName;
        this.registerRequest(target.createClassPrepareRequest(classPrepareTypeName), target);
        VirtualMachine vm = target.getVM();
        if (vm == null) {
            target.requestFailed(JDIDebugBreakpointMessages.getString("JavaPatternBreakpoint.Unable_to_add_breakpoint_-_VM_disconnected._1"), null);
        }
        List<ReferenceType> classes = null;
        try {
            classes = vm.allClasses();
        }
        catch (RuntimeException e) {
            target.targetRequestFailed(JDIDebugBreakpointMessages.getString("JavaPatternBreakpoint.0"), e);
        }
        if (classes != null) {
            Iterator<ReferenceType> iter = classes.iterator();
            while (iter.hasNext()) {
                ReferenceType type = iter.next();
                if (!this.installableReferenceType(type, target)) continue;
                this.createRequest(target, type);
            }
        }
    }
}

