/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdi.internal;

import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.Value;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.reflect.Field;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdi.hcr.OperationRefusedException;
import org.eclipse.jdi.hcr.ThreadReference;
import org.eclipse.jdi.internal.JDIMessages;
import org.eclipse.jdi.internal.MirrorImpl;
import org.eclipse.jdi.internal.ObjectReferenceImpl;
import org.eclipse.jdi.internal.StackFrameImpl;
import org.eclipse.jdi.internal.ThreadGroupReferenceImpl;
import org.eclipse.jdi.internal.TypeImpl;
import org.eclipse.jdi.internal.ValueImpl;
import org.eclipse.jdi.internal.VirtualMachineImpl;
import org.eclipse.jdi.internal.jdwp.JdwpReplyPacket;
import org.eclipse.jdi.internal.jdwp.JdwpThreadID;

public class ThreadReferenceImpl
extends ObjectReferenceImpl
implements com.sun.jdi.ThreadReference,
ThreadReference {
    public static final int JDWP_THREAD_STATUS_ZOMBIE = 0;
    public static final int JDWP_THREAD_STATUS_RUNNING = 1;
    public static final int JDWP_THREAD_STATUS_SLEEPING = 2;
    public static final int JDWP_THREAD_STATUS_MONITOR = 3;
    public static final int JDWP_THREAD_STATUS_WAIT = 4;
    public static final int SUSPEND_STATUS_SUSPENDED = 1;
    private static Map fgThreadStatusMap = null;
    private static String[] fgSuspendStatusStrings = null;
    protected static final byte tag = 116;
    private boolean fIsAtBreakpoint = false;
    private ThreadGroupReferenceImpl fThreadGroup = null;
    static /* synthetic */ Class class$0;

    public ThreadReferenceImpl(VirtualMachineImpl vmImpl, JdwpThreadID threadID) {
        super("ThreadReference", vmImpl, threadID);
    }

    public void setIsAtBreakpoint() {
        this.fIsAtBreakpoint = true;
    }

    public void resetEventFlags() {
        this.fIsAtBreakpoint = false;
    }

    public byte getTag() {
        return 116;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ObjectReference currentContendedMonitor() throws IncompatibleThreadStateException {
        ObjectReferenceImpl objectReferenceImpl;
        if (!this.virtualMachine().canGetCurrentContendedMonitor()) {
            throw new UnsupportedOperationException();
        }
        this.initJdwpRequest();
        try {
            try {
                ObjectReferenceImpl result;
                JdwpReplyPacket replyPacket = this.requestVM(2825, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                    case 13: {
                        throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                objectReferenceImpl = result = ObjectReferenceImpl.readObjectRefWithTag(this, replyData);
                Object var4_7 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                ObjectReference objectReference = null;
                Object var4_8 = null;
                this.handledJdwpRequest();
                return objectReference;
            }
        }
        catch (Throwable throwable) {
            Object var4_9 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return objectReferenceImpl;
    }

    public StackFrame frame(int index) throws IncompatibleThreadStateException {
        return (StackFrameImpl)this.frames(index, 1).get(0);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int frameCount() throws IncompatibleThreadStateException {
        int n;
        this.initJdwpRequest();
        try {
            try {
                int result;
                JdwpReplyPacket replyPacket = this.requestVM(2823, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                    case 13: {
                        throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                n = result = this.readInt("frame count", replyData);
                Object var4_6 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var4_7 = null;
                this.handledJdwpRequest();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return n;
    }

    public List frames() throws IncompatibleThreadStateException {
        return this.frames(0, -1);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List frames(int start, int length) throws IndexOutOfBoundsException, IncompatibleThreadStateException {
        ArrayList<StackFrameImpl> arrayList;
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                this.write(this, outData);
                this.writeInt(start, "start", outData);
                this.writeInt(length, "length", outData);
                JdwpReplyPacket replyPacket = this.requestVM(2822, outBytes);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                    case 13: {
                        throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_1"));
                    }
                    case 503: {
                        throw new IndexOutOfBoundsException(JDIMessages.getString("ThreadReferenceImpl.Invalid_index_of_stack_frames_given_4"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                int nrOfElements = this.readInt("elements", replyData);
                ArrayList<StackFrameImpl> frames = new ArrayList<StackFrameImpl>(nrOfElements);
                int i = 0;
                while (true) {
                    if (i >= nrOfElements) {
                        arrayList = frames;
                        Object var11_14 = null;
                        break;
                    }
                    StackFrameImpl frame = StackFrameImpl.readWithLocation(this, this, replyData);
                    if (frame != null) {
                        frames.add(frame);
                    }
                    ++i;
                }
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                List list = null;
                Object var11_15 = null;
                this.handledJdwpRequest();
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void interrupt() {
        this.initJdwpRequest();
        try {
            this.requestVM(2827, this);
        }
        catch (Throwable throwable) {
            Object var1_2 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        {
            Object var1_3 = null;
        }
        this.handledJdwpRequest();
    }

    public boolean isAtBreakpoint() {
        return this.isSuspended() && this.fIsAtBreakpoint;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isSuspended() {
        boolean bl;
        this.initJdwpRequest();
        try {
            try {
                boolean result;
                JdwpReplyPacket replyPacket = this.requestVM(2820, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                this.readInt("thread status", ThreadReferenceImpl.threadStatusMap(), replyData);
                int suspendStatus = this.readInt("suspend status", ThreadReferenceImpl.suspendStatusStrings(), replyData);
                bl = result = suspendStatus == 1;
                Object var5_7 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var5_8 = null;
                this.handledJdwpRequest();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var5_9 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String name() {
        String string;
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(2817, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                string = this.readString("name", replyData);
                Object var3_6 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                String string2 = null;
                Object var3_7 = null;
                this.handledJdwpRequest();
                return string2;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public List ownedMonitors() throws IncompatibleThreadStateException {
        ArrayList<ObjectReferenceImpl> arrayList;
        if (!this.virtualMachine().canGetOwnedMonitorInfo()) {
            throw new UnsupportedOperationException();
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(2824, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                    case 13: {
                        throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Thread_was_not_suspended_5"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                int nrOfMonitors = this.readInt("nr of monitors", replyData);
                ArrayList<ObjectReferenceImpl> result = new ArrayList<ObjectReferenceImpl>(nrOfMonitors);
                int i = 0;
                while (true) {
                    if (i >= nrOfMonitors) {
                        arrayList = result;
                        Object var6_9 = null;
                        break;
                    }
                    result.add(ObjectReferenceImpl.readObjectRefWithTag(this, replyData));
                    ++i;
                }
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                List list = null;
                Object var6_10 = null;
                this.handledJdwpRequest();
                return list;
            }
        }
        catch (Throwable throwable) {
            Object var6_11 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return arrayList;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resume() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2819, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
            this.resetEventFlags();
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.handledJdwpRequest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int status() {
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            block18: {
                                block17: {
                                    this.initJdwpRequest();
                                    try {
                                        try {
                                            JdwpReplyPacket replyPacket = this.requestVM(2820, this);
                                            switch (replyPacket.errorCode()) {
                                                case 101: {
                                                    Object var4_3 = null;
                                                    break;
                                                }
                                                case 10: {
                                                    break block17;
                                                }
                                                default: {
                                                    this.defaultReplyErrorHandler(replyPacket.errorCode());
                                                    DataInputStream replyData = replyPacket.dataInStream();
                                                    int threadStatus = this.readInt("thread status", ThreadReferenceImpl.threadStatusMap(), replyData);
                                                    this.readInt("suspend status", ThreadReferenceImpl.suspendStatusStrings(), replyData);
                                                    switch (threadStatus) {
                                                        case 0: {
                                                            break block18;
                                                        }
                                                        case 1: {
                                                            break block19;
                                                        }
                                                        case 2: {
                                                            break block20;
                                                        }
                                                        case 3: {
                                                            break block21;
                                                        }
                                                        case 4: {
                                                            break block22;
                                                        }
                                                        case -1: {
                                                            break block23;
                                                        }
                                                        default: {
                                                            throw new InternalException(String.valueOf(JDIMessages.getString("ThreadReferenceImpl.Unknown_thread_status_received___6")) + threadStatus);
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                        catch (IOException e) {
                                            this.defaultIOExceptionHandler(e);
                                            Object var4_11 = null;
                                            this.handledJdwpRequest();
                                            return 0;
                                        }
                                    }
                                    catch (Throwable throwable) {
                                        Object var4_12 = null;
                                        this.handledJdwpRequest();
                                        throw throwable;
                                    }
                                    this.handledJdwpRequest();
                                    return -1;
                                }
                                Object var4_4 = null;
                                this.handledJdwpRequest();
                                return 5;
                            }
                            Object var4_5 = null;
                            this.handledJdwpRequest();
                            return 0;
                        }
                        Object var4_6 = null;
                        this.handledJdwpRequest();
                        return 1;
                    }
                    Object var4_7 = null;
                    this.handledJdwpRequest();
                    return 2;
                }
                Object var4_8 = null;
                this.handledJdwpRequest();
                return 3;
            }
            Object var4_9 = null;
            this.handledJdwpRequest();
            return 4;
        }
        Object var4_10 = null;
        this.handledJdwpRequest();
        return -1;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void stop(ObjectReference throwable) throws InvalidTypeException {
        this.checkVM(throwable);
        ObjectReferenceImpl throwableImpl = (ObjectReferenceImpl)throwable;
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                this.write(this, outData);
                throwableImpl.write(this, outData);
                JdwpReplyPacket replyPacket = this.requestVM(2826, outBytes);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                    case 21: {
                        throw new InvalidTypeException(JDIMessages.getString("ThreadReferenceImpl.Stop_argument_not_an_instance_of_java.lang.Throwable_in_the_target_VM_7"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
            }
        }
        catch (Throwable throwable2) {
            Object var6_8 = null;
            this.handledJdwpRequest();
            throw throwable2;
        }
        {
            Object var6_9 = null;
        }
        this.handledJdwpRequest();
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void suspend() {
        this.initJdwpRequest();
        try {
            JdwpReplyPacket replyPacket = this.requestVM(2818, this);
            switch (replyPacket.errorCode()) {
                case 10: {
                    throw new ObjectCollectedException();
                }
            }
            this.defaultReplyErrorHandler(replyPacket.errorCode());
        }
        catch (Throwable throwable) {
            Object var2_3 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        {
            Object var2_4 = null;
        }
        this.handledJdwpRequest();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int suspendCount() {
        int n;
        this.initJdwpRequest();
        try {
            try {
                int result;
                JdwpReplyPacket replyPacket = this.requestVM(2828, this);
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                n = result = this.readInt("suspend count", replyData);
                Object var4_6 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var4_7 = null;
                this.handledJdwpRequest();
                return 0;
            }
        }
        catch (Throwable throwable) {
            Object var4_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ThreadGroupReference threadGroup() {
        ThreadGroupReferenceImpl threadGroupReferenceImpl;
        if (this.fThreadGroup != null) {
            return this.fThreadGroup;
        }
        this.initJdwpRequest();
        try {
            try {
                JdwpReplyPacket replyPacket = this.requestVM(2821, this);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                threadGroupReferenceImpl = this.fThreadGroup = ThreadGroupReferenceImpl.read(this, replyData);
                Object var3_6 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                ThreadGroupReference threadGroupReference = null;
                Object var3_7 = null;
                this.handledJdwpRequest();
                return threadGroupReference;
            }
        }
        catch (Throwable throwable) {
            Object var3_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return threadGroupReferenceImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean doReturn(Value returnValue, boolean triggerFinallyAndSynchronized) throws OperationRefusedException {
        boolean bl;
        ValueImpl valueImpl;
        this.virtualMachineImpl().checkHCRSupported();
        if (returnValue != null) {
            this.checkVM(returnValue);
            valueImpl = (ValueImpl)returnValue;
        } else {
            try {
                TypeImpl returnType = (TypeImpl)this.frame(0).location().method().returnType();
                valueImpl = (ValueImpl)returnType.createNullValue();
            }
            catch (IncompatibleThreadStateException e) {
                throw new OperationRefusedException(e.toString());
            }
            catch (ClassNotLoadedException e) {
                throw new OperationRefusedException(e.toString());
            }
        }
        this.initJdwpRequest();
        try {
            try {
                boolean result;
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                this.write(this, outData);
                valueImpl.writeWithTag(this, outData);
                this.writeBoolean(triggerFinallyAndSynchronized, "trigger finaly+sync", outData);
                JdwpReplyPacket replyPacket = this.requestVM(32771, outBytes);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new ObjectCollectedException();
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
                DataInputStream replyData = replyPacket.dataInStream();
                bl = result = this.readBoolean("is enclosed", replyData);
                Object var9_13 = null;
            }
            catch (IOException e) {
                this.defaultIOExceptionHandler(e);
                Object var9_14 = null;
                this.handledJdwpRequest();
                return false;
            }
        }
        catch (Throwable throwable) {
            Object var9_15 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        this.handledJdwpRequest();
        return bl;
    }

    public String toString() {
        try {
            return MessageFormat.format(JDIMessages.getString("ThreadReferenceImpl.8"), this.type().toString(), this.name(), this.getObjectID().toString());
        }
        catch (ObjectCollectedException objectCollectedException) {
            return String.valueOf(JDIMessages.getString("ThreadReferenceImpl.(Garbage_Collected)_ThreadReference__9")) + this.idString();
        }
        catch (Exception exception) {
            return this.fDescription;
        }
    }

    public static ThreadReferenceImpl read(MirrorImpl target, DataInputStream in) throws IOException {
        VirtualMachineImpl vmImpl = target.virtualMachineImpl();
        JdwpThreadID ID = new JdwpThreadID(vmImpl);
        ID.read(in);
        if (target.fVerboseWriter != null) {
            target.fVerboseWriter.println("threadReference", ID.value());
        }
        if (ID.isNull()) {
            return null;
        }
        ThreadReferenceImpl mirror = (ThreadReferenceImpl)vmImpl.getCachedMirror(ID);
        if (mirror == null) {
            mirror = new ThreadReferenceImpl(vmImpl, ID);
            vmImpl.addCachedMirror(mirror);
        }
        return mirror;
    }

    public static void getConstantMaps() {
        if (fgThreadStatusMap != null) {
            return;
        }
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdi.internal.ThreadReferenceImpl");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Field[] fields = clazz.getDeclaredFields();
        fgThreadStatusMap = new HashMap();
        fgSuspendStatusStrings = new String[32];
        int i = 0;
        while (i < fields.length) {
            block13: {
                Field field = fields[i];
                if ((field.getModifiers() & 1) != 0 && (field.getModifiers() & 8) != 0 && (field.getModifiers() & 0x10) != 0) {
                    try {
                        String name = field.getName();
                        int value = field.getInt(null);
                        Integer intValue = new Integer(value);
                        if (name.startsWith("JDWP_THREAD_STATUS_")) {
                            name = name.substring(19);
                            fgThreadStatusMap.put(intValue, name);
                            break block13;
                        }
                        if (!name.startsWith("SUSPEND_STATUS_")) break block13;
                        name = name.substring(15);
                        int j = 0;
                        while (j < fgSuspendStatusStrings.length) {
                            if ((1 << j & value) != 0) {
                                ThreadReferenceImpl.fgSuspendStatusStrings[j] = name;
                                break;
                            }
                            ++j;
                        }
                    }
                    catch (IllegalAccessException illegalAccessException) {
                    }
                    catch (IllegalArgumentException illegalArgumentException) {}
                }
            }
            ++i;
        }
    }

    public static Map threadStatusMap() {
        ThreadReferenceImpl.getConstantMaps();
        return fgThreadStatusMap;
    }

    public static String[] suspendStatusStrings() {
        ThreadReferenceImpl.getConstantMaps();
        return fgSuspendStatusStrings;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void popFrames(StackFrame frameToPop) throws IncompatibleThreadStateException {
        if (!this.isSuspended()) {
            throw new IncompatibleThreadStateException();
        }
        if (!this.virtualMachineImpl().canPopFrames()) {
            throw new UnsupportedOperationException();
        }
        StackFrameImpl frame = (StackFrameImpl)frameToPop;
        this.initJdwpRequest();
        try {
            try {
                ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
                DataOutputStream outData = new DataOutputStream(outBytes);
                frame.writeWithThread(frame, outData);
                JdwpReplyPacket replyPacket = this.requestVM(4100, outBytes);
                switch (replyPacket.errorCode()) {
                    case 10: {
                        throw new InvalidStackFrameException();
                    }
                    case 30: {
                        throw new InvalidStackFrameException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame_from_the_call_stack_(Reasons_include__The_frame_id_was_invalid;_The_thread_was_resumed)_10"));
                    }
                    case 13: {
                        throw new IncompatibleThreadStateException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame._The_requested_stack_frame_is_not_suspended_11"));
                    }
                    case 31: {
                        throw new InvalidStackFrameException(JDIMessages.getString("ThreadReferenceImpl.Unable_to_pop_the_requested_stack_frame_from_the_call_stack_(Reasons_include__The_requested_frame_was_the_last_frame_on_the_call_stack;_The_requested_frame_was_the_last_frame_above_a_native_frame)_12"));
                    }
                }
                this.defaultReplyErrorHandler(replyPacket.errorCode());
            }
            catch (IOException ioe) {
                this.defaultIOExceptionHandler(ioe);
            }
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            this.handledJdwpRequest();
            throw throwable;
        }
        {
            Object var6_9 = null;
        }
        this.handledJdwpRequest();
    }
}

