/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.protocols;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.util.URLCoder;
import org.osgi.framework.Bundle;

public class HelpURLConnection
extends URLConnection {
    private static final String LANG = "lang";
    protected static boolean cachingEnabled = true;
    protected String pluginAndFile;
    protected String query;
    protected HashMap arguments;
    protected Bundle plugin;
    protected String file;
    protected String locale;
    private static String appserverImplPluginId;

    static {
        String[] args = Platform.getCommandLineArgs();
        int i = 0;
        while (i < args.length) {
            if ("-dev".equals(args[i])) {
                cachingEnabled = false;
                break;
            }
            ++i;
        }
    }

    public HelpURLConnection(URL url) {
        super(url);
        int indx;
        String urlFile = url.getFile();
        if (urlFile.startsWith("/")) {
            urlFile = urlFile.substring(1);
        }
        if ((indx = urlFile.indexOf("?")) != -1) {
            this.query = urlFile.substring(indx + 1);
            urlFile = urlFile.substring(0, indx);
        }
        this.pluginAndFile = urlFile;
        this.parseQuery();
        this.setDefaultUseCaches(this.isCacheable());
        if (HelpPlugin.DEBUG_PROTOCOLS) {
            System.out.println("HelpURLConnection: url=" + url);
        }
    }

    public void connect() throws IOException {
    }

    public InputStream getInputStream() throws IOException {
        Bundle plugin = this.getPlugin();
        if (plugin == null) {
            throw new IOException("Resource not found.");
        }
        if (plugin.getSymbolicName().equals(HelpURLConnection.getAppserverImplPluginId())) {
            throw new IOException("Resource not found.");
        }
        if (this.getFile() == null || "".equals(this.getFile())) {
            throw new IOException("Resource not found.");
        }
        InputStream inputStream = ResourceLocator.openFromProducer(plugin, this.query == null ? this.getFile() : String.valueOf(this.getFile()) + "?" + this.query, this.getLocale());
        if (inputStream == null) {
            inputStream = ResourceLocator.openFromZip(plugin, "doc.zip", this.getFile(), this.getLocale());
        }
        if (inputStream == null) {
            inputStream = ResourceLocator.openFromPlugin(plugin, this.getFile(), this.getLocale());
        }
        if (inputStream == null) {
            throw new IOException("Resource not found.");
        }
        return inputStream;
    }

    public long getExpiration() {
        return this.isCacheable() ? new Date().getTime() + 10000L : 0L;
    }

    protected void parseQuery() {
        if (this.query != null && !"".equals(this.query)) {
            if (this.arguments == null) {
                this.arguments = new HashMap(5);
            }
            StringTokenizer stok = new StringTokenizer(this.query, "&");
            while (stok.hasMoreTokens()) {
                String aQuery = stok.nextToken();
                int equalsPosition = aQuery.indexOf("=");
                if (equalsPosition <= -1) continue;
                String arg = aQuery.substring(0, equalsPosition);
                String val = aQuery.substring(equalsPosition + 1);
                Object existing = this.arguments.get(arg);
                if (existing == null) {
                    this.arguments.put(arg, val);
                    continue;
                }
                if (existing instanceof Vector) {
                    ((Vector)existing).add(val);
                    this.arguments.put(arg, existing);
                    continue;
                }
                Vector<Object> v = new Vector<Object>(2);
                v.add(existing);
                v.add(val);
                this.arguments.put(arg, v);
            }
        }
    }

    public String getContentType() {
        String file = this.pluginAndFile.toLowerCase(Locale.US);
        if (file.endsWith(".html") || file.endsWith(".htm")) {
            return "text/html";
        }
        if (file.endsWith(".css")) {
            return "text/css";
        }
        if (file.endsWith(".gif")) {
            return "image/gif";
        }
        if (file.endsWith(".jpg")) {
            return "image/jpeg";
        }
        if (file.endsWith(".pdf")) {
            return "application/pdf";
        }
        if (file.endsWith(".xml")) {
            return "application/xml";
        }
        if (file.endsWith(".xsl")) {
            return "application/xsl";
        }
        return "text/plain";
    }

    public Vector getMultiValue(String name) {
        if (this.arguments != null) {
            Object value = this.arguments.get(name);
            if (value instanceof Vector) {
                return (Vector)value;
            }
            return null;
        }
        return null;
    }

    public String getValue(String name) {
        if (this.arguments == null) {
            return null;
        }
        Object value = this.arguments.get(name);
        String stringValue = null;
        if (value instanceof String) {
            stringValue = (String)value;
        } else if (value instanceof Vector) {
            stringValue = (String)((Vector)value).firstElement();
        } else {
            return null;
        }
        try {
            return URLCoder.decode(stringValue);
        }
        catch (Exception exception) {
            return null;
        }
    }

    protected String getLocale() {
        if (this.locale == null) {
            this.locale = this.getValue(LANG);
            if (this.locale == null) {
                this.locale = Platform.getNL();
            }
        }
        return this.locale;
    }

    protected String getFile() {
        if (this.file == null) {
            int start = this.pluginAndFile.indexOf("/") + 1;
            int end = this.pluginAndFile.indexOf("?");
            if (end == -1) {
                end = this.pluginAndFile.indexOf("#");
            }
            if (end == -1) {
                end = this.pluginAndFile.length();
            }
            this.file = this.pluginAndFile.substring(start, end);
            this.file = URLCoder.decode(this.file);
        }
        return this.file;
    }

    protected Bundle getPlugin() {
        if (this.plugin == null) {
            int i = this.pluginAndFile.indexOf(47);
            String pluginId = i == -1 ? "" : this.pluginAndFile.substring(0, i);
            pluginId = URLCoder.decode(pluginId);
            this.plugin = Platform.getBundle((String)pluginId);
        }
        return this.plugin;
    }

    public boolean isCacheable() {
        if (this.getValue("resultof") != null) {
            return false;
        }
        return cachingEnabled;
    }

    public String toString() {
        return this.pluginAndFile;
    }

    private static String getAppserverImplPluginId() {
        IExtension[] extensions;
        IExtensionRegistry pluginRegistry;
        IExtensionPoint point;
        if (appserverImplPluginId == null && (point = (pluginRegistry = Platform.getExtensionRegistry()).getExtensionPoint("org.eclipse.help.appserver.server")) != null && (extensions = point.getExtensions()).length != 0) {
            IConfigurationElement[] elements = extensions[0].getConfigurationElements();
            if (elements.length == 0) {
                return null;
            }
            IConfigurationElement serverElement = null;
            int i = 0;
            while (i < elements.length) {
                String defaultValue = elements[i].getAttribute("default");
                if (defaultValue == null || defaultValue.equals("false")) {
                    serverElement = elements[i];
                    break;
                }
                ++i;
            }
            if (serverElement == null) {
                serverElement = elements[0];
            }
            appserverImplPluginId = serverElement.getDeclaringExtension().getNamespace();
        }
        return appserverImplPluginId;
    }
}

