/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.ui.IElementFactory;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPersistableElement;

public class PersistableLaunchConfigurationTypeFactory
implements IPersistableElement,
IElementFactory {
    private ILaunchConfigurationType fConfigType;
    private static final String KEY = "launchConfigTypeID";
    private static final String FACTORY_ID = "org.eclipse.debug.ui.PersistableLaunchConfigurationTypeFactory";

    public PersistableLaunchConfigurationTypeFactory() {
    }

    public PersistableLaunchConfigurationTypeFactory(ILaunchConfigurationType configType) {
        this.setConfigType(configType);
    }

    public String getFactoryId() {
        return FACTORY_ID;
    }

    public void saveState(IMemento memento) {
        String configTypeID = this.getConfigType().getIdentifier();
        memento.putString(KEY, configTypeID);
    }

    public IAdaptable createElement(IMemento memento) {
        String configTypeID = memento.getString(KEY);
        return this.getLaunchManager().getLaunchConfigurationType(configTypeID);
    }

    private void setConfigType(ILaunchConfigurationType configType) {
        this.fConfigType = configType;
    }

    private ILaunchConfigurationType getConfigType() {
        return this.fConfigType;
    }

    private ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }
}

