/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.internal.core.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.text.MessageFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Vector;
import org.apache.tools.ant.AntTypeDefinition;
import org.apache.tools.ant.BuildEvent;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.BuildListener;
import org.apache.tools.ant.BuildLogger;
import org.apache.tools.ant.ComponentHelper;
import org.apache.tools.ant.DefaultLogger;
import org.apache.tools.ant.DemuxOutputStream;
import org.apache.tools.ant.Diagnostics;
import org.apache.tools.ant.Main;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.ProjectHelper;
import org.apache.tools.ant.Target;
import org.apache.tools.ant.XmlLogger;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.AntCorePreferences;
import org.eclipse.ant.core.AntSecurityException;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.ant.AntSecurityManager;
import org.eclipse.ant.internal.core.ant.DemuxInputStreamSetter;
import org.eclipse.ant.internal.core.ant.InputHandlerSetter;
import org.eclipse.ant.internal.core.ant.InternalAntMessages;
import org.eclipse.ant.internal.core.ant.InternalProject;
import org.eclipse.ant.internal.core.ant.ProgressBuildListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;

public class InternalAntRunner {
    private IProgressMonitor monitor;
    private List buildListeners;
    private String buildFileLocation;
    private Vector targets;
    private Map userProperties;
    private boolean noExplicitUserProperties = true;
    private Project currentProject;
    private String defaultTarget;
    private BuildLogger buildLogger = null;
    private String antVersionNumber = null;
    private int messageOutputLevel = 2;
    private boolean emacsMode = false;
    private boolean projectHelp = false;
    private PrintStream out = System.out;
    private PrintStream err = System.err;
    private String loggerClassname = null;
    private String[] extraArguments = null;
    private boolean scriptExecuted = false;
    private List propertyFiles = new ArrayList();
    private URL[] customClasspath = null;
    private String inputHandlerClassname = null;
    private String buildAntHome = null;
    private boolean keepGoing = false;
    private boolean allowInput = true;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void addBuildListeners(List classNames) {
        if (this.buildListeners == null) {
            this.buildListeners = new ArrayList(classNames.size());
        }
        this.buildListeners.addAll(classNames);
    }

    public void addBuildLogger(String className) {
        this.loggerClassname = className;
    }

    public void addUserProperties(Map properties) {
        if (this.userProperties == null) {
            this.userProperties = new HashMap(properties.size());
        }
        this.userProperties.putAll(properties);
        this.noExplicitUserProperties = false;
    }

    public void addPropertyFiles(String[] additionalPropertyFiles) {
        this.propertyFiles.addAll(Arrays.asList(additionalPropertyFiles));
    }

    private void addBuildListeners(Project project) {
        String className = null;
        try {
            BuildLogger logger = this.createLogger();
            if (logger != null) {
                project.addBuildListener((BuildListener)logger);
            }
            if (this.buildListeners != null) {
                Iterator iterator = this.buildListeners.iterator();
                while (iterator.hasNext()) {
                    className = (String)iterator.next();
                    Class<?> listener = Class.forName(className);
                    project.addBuildListener((BuildListener)listener.newInstance());
                }
            }
        }
        catch (ClassCastException e) {
            String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_be_a_build_listener_is_not_an_instance_of_org.apache.tools.ant.BuildListener._1"), className);
            this.logMessage(null, message, 0);
            throw new BuildException(message, (Throwable)e);
        }
        catch (BuildException e) {
            throw e;
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void setProperties(Project project) {
        this.setBuiltInProperties(project);
        if (this.userProperties != null) {
            Iterator iterator = this.userProperties.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                project.setUserProperty((String)entry.getKey(), (String)entry.getValue());
            }
            if (this.noExplicitUserProperties) {
                this.setGlobalProperties(project);
            }
        } else {
            this.setGlobalProperties(project);
        }
    }

    private void setBuiltInProperties(Project project) {
        project.setUserProperty("ant.file", this.getBuildFileLocation());
        project.setUserProperty("ant.version", Main.getAntVersion());
    }

    private void setGlobalProperties(Project project) {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        List properties = prefs.getProperties();
        if (properties != null) {
            Iterator iter = properties.iterator();
            while (iter.hasNext()) {
                Property property = (Property)iter.next();
                String value = property.getValue();
                if (value == null) continue;
                project.setUserProperty(property.getName(), value);
            }
        }
    }

    private void setTasks(Project project) {
        List tasks = AntCorePlugin.getPlugin().getPreferences().getTasks();
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Task task = (Task)iterator.next();
            if (this.isVersionCompatible("1.6")) {
                AntTypeDefinition def = new AntTypeDefinition();
                def.setName(task.getTaskName());
                def.setClassName(task.getClassName());
                def.setClassLoader(this.getClass().getClassLoader());
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.apache.tools.ant.Task");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                def.setAdaptToClass((Class)clazz);
                Class<?> clazz2 = class$1;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.apache.tools.ant.TaskAdapter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                def.setAdapterClass((Class)clazz2);
                ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
                continue;
            }
            try {
                Class<?> taskClass = Class.forName(task.getClassName());
                if (this.isVersionCompatible("1.5")) {
                    try {
                        project.checkTaskClass(taskClass);
                    }
                    catch (BuildException e) {
                        Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Error_setting_Ant_task"), task.getTaskName()), (Throwable)e);
                        AntCorePlugin.getPlugin().getLog().log((IStatus)status);
                        continue;
                    }
                }
                project.addTaskDefinition(task.getTaskName(), taskClass);
            }
            catch (ClassNotFoundException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Class_{0}_not_found_for_task_{1}_1"), task.getClassName(), task.getTaskName()), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private void setTypes(Project project) {
        List types = AntCorePlugin.getPlugin().getPreferences().getTypes();
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Type type = (Type)iterator.next();
            if (this.isVersionCompatible("1.6")) {
                AntTypeDefinition def = new AntTypeDefinition();
                def.setName(type.getTypeName());
                def.setClassName(type.getClassName());
                def.setClassLoader(this.getClass().getClassLoader());
                ComponentHelper.getComponentHelper((Project)project).addDataTypeDefinition(def);
                continue;
            }
            try {
                Class<?> typeClass = Class.forName(type.getClassName());
                project.addDataTypeDefinition(type.getTypeName(), typeClass);
            }
            catch (ClassNotFoundException e) {
                Status status = new Status(4, "org.eclipse.ant.core", 1, MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Class_{0}_not_found_for_type_{1}_2"), type.getClassName(), type.getTypeName()), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private void parseBuildFile(Project project) {
        File buildFile = new File(this.getBuildFileLocation());
        if (!buildFile.exists()) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Buildfile__{0}_does_not_exist_!_1"), buildFile.getAbsolutePath()));
        }
        if (!buildFile.isFile()) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Buildfile__{0}_is_not_a_file_1"), buildFile.getAbsolutePath()));
        }
        ProjectHelper helper = ProjectHelper.getProjectHelper();
        project.addReference("ant.projectHelper", (Object)helper);
        helper.parse(project, (Object)buildFile);
    }

    public List getTargets() {
        try {
            Object antProject = this.isVersionCompatible("1.6") ? new Project() : new InternalProject();
            this.processAntHome(false);
            antProject.init();
            this.setTypes((Project)antProject);
            this.processProperties(this.getArrayList(this.extraArguments));
            this.setProperties((Project)antProject);
            if (this.isVersionCompatible("1.6")) {
                new InputHandlerSetter().setInputHandler((Project)antProject, "org.eclipse.ant.internal.core.ant.NullInputHandler");
            }
            this.parseBuildFile((Project)antProject);
            this.defaultTarget = antProject.getDefaultTarget();
            Enumeration projectTargets = antProject.getTargets().elements();
            ArrayList<Object> infos = new ArrayList<Object>();
            infos.add(antProject.getName());
            infos.add(antProject.getDescription());
            boolean defaultFound = false;
            while (projectTargets.hasMoreElements()) {
                Target target = (Target)projectTargets.nextElement();
                String name = target.getName();
                if (name.length() == 0) continue;
                ArrayList<Object> info = new ArrayList<Object>(4);
                info.add(name);
                if (target.getName().equals(this.defaultTarget)) {
                    defaultFound = true;
                }
                info.add(target.getDescription());
                ArrayList dependencies = new ArrayList();
                Enumeration enumeration = target.getDependencies();
                while (enumeration.hasMoreElements()) {
                    dependencies.add(enumeration.nextElement());
                }
                String[] dependencyArray = new String[dependencies.size()];
                dependencies.toArray(dependencyArray);
                info.add(dependencyArray);
                infos.add(info);
            }
            if (!defaultFound) {
                throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Default_target_{0}{1}{2}_does_not_exist_in_this_project_1"), "'", this.defaultTarget, "'"));
            }
            ArrayList<Object> arrayList = infos;
            Object var11_12 = null;
            this.processAntHome(true);
            return arrayList;
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            this.processAntHome(true);
            throw throwable;
        }
    }

    public String getDefaultTarget() {
        return this.defaultTarget;
    }

    public void run() {
        this.run(this.getArrayList(this.extraArguments));
    }

    private void printArguments(Project project) {
        if (this.messageOutputLevel != 4 && this.messageOutputLevel != 3) {
            return;
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < this.extraArguments.length) {
            sb.append(this.extraArguments[i]);
            sb.append(' ');
            ++i;
        }
        project.log(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Arguments__{0}_2"), sb.toString().trim()));
    }

    private void createMonitorBuildListener(Project project) {
        if (this.monitor == null) {
            return;
        }
        AbstractList chosenTargets = this.targets;
        if (chosenTargets == null || chosenTargets.isEmpty()) {
            chosenTargets = new ArrayList(1);
            String defltTarget = project.getDefaultTarget();
            if (defltTarget != null) {
                chosenTargets.add(defltTarget);
            }
        }
        project.addBuildListener((BuildListener)new ProgressBuildListener(project, chosenTargets, this.monitor));
    }

    private void printTargets(Project project) {
        int maxLength = 0;
        Enumeration ptargets = project.getTargets().elements();
        ArrayList<String> topNames = new ArrayList<String>();
        ArrayList<String> topDescriptions = new ArrayList<String>();
        ArrayList<String> subNames = new ArrayList<String>();
        while (ptargets.hasMoreElements()) {
            Target currentTarget = (Target)ptargets.nextElement();
            String targetName = currentTarget.getName();
            String targetDescription = currentTarget.getDescription();
            if (targetDescription == null) {
                subNames.add(targetName);
                continue;
            }
            topNames.add(targetName);
            topDescriptions.add(targetDescription);
            if (targetName.length() <= maxLength) continue;
            maxLength = targetName.length();
        }
        Collections.sort(subNames);
        Collections.sort(topNames);
        Collections.sort(topDescriptions);
        String defaultTargetName = project.getDefaultTarget();
        if (defaultTargetName != null && !"".equals(defaultTargetName)) {
            ArrayList<String> defaultName = new ArrayList<String>(1);
            ArrayList defaultDesc = null;
            defaultName.add(defaultTargetName);
            int indexOfDefDesc = topNames.indexOf(defaultTargetName);
            if (indexOfDefDesc >= 0) {
                defaultDesc = new ArrayList(1);
                defaultDesc.add(topDescriptions.get(indexOfDefDesc));
            }
            this.printTargets(project, defaultName, defaultDesc, InternalAntMessages.getString("InternalAntRunner.Default_target__3"), maxLength);
        }
        this.printTargets(project, topNames, topDescriptions, InternalAntMessages.getString("InternalAntRunner.Main_targets__4"), maxLength);
        this.printTargets(project, subNames, null, InternalAntMessages.getString("InternalAntRunner.Subtargets__5"), 0);
    }

    private void printTargets(Project project, List names, List descriptions, String heading, int maxlen) {
        String lSep = System.getProperty("line.separator");
        String spaces = "    ";
        while (spaces.length() < maxlen) {
            spaces = String.valueOf(spaces) + spaces;
        }
        StringBuffer msg = new StringBuffer();
        msg.append(String.valueOf(heading) + lSep + lSep);
        int i = 0;
        while (i < names.size()) {
            msg.append(' ');
            msg.append(names.get(i));
            if (descriptions != null) {
                msg.append(spaces.substring(0, maxlen - ((String)names.get(i)).length() + 2));
                msg.append(descriptions.get(i));
            }
            msg.append(lSep);
            ++i;
        }
        this.logMessage(project, msg.toString(), 2);
    }

    public void run(Object argArray) throws Exception {
        this.run(this.getArrayList((String[])argArray));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void run(List argList) {
        SecurityManager originalSM;
        InputStream originalIn;
        PrintStream originalOut;
        PrintStream originalErr;
        Throwable error;
        block47: {
            block46: {
                block45: {
                    block44: {
                        this.setCurrentProject(new Project());
                        error = null;
                        originalErr = System.err;
                        originalOut = System.out;
                        originalIn = System.in;
                        originalSM = System.getSecurityManager();
                        this.setJavaClassPath();
                        this.scriptExecuted = true;
                        this.processAntHome(false);
                        try {
                            try {
                                if (argList != null && (argList.remove("-projecthelp") || argList.remove("-p"))) {
                                    this.projectHelp = true;
                                }
                                this.getCurrentProject().init();
                                if (argList != null) {
                                    this.scriptExecuted = this.preprocessCommandLine(argList);
                                    if (!this.scriptExecuted) {
                                        Object var8_7 = null;
                                        break block44;
                                    }
                                }
                                this.addBuildListeners(this.getCurrentProject());
                                this.processProperties(argList);
                                this.setProperties(this.getCurrentProject());
                                this.addInputHandler(this.getCurrentProject());
                                this.remapSystemIn();
                                System.setOut(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), false)));
                                System.setErr(new PrintStream((OutputStream)new DemuxOutputStream(this.getCurrentProject(), true)));
                                if (!this.projectHelp) {
                                    this.fireBuildStarted(this.getCurrentProject());
                                }
                                if (argList != null && !argList.isEmpty()) {
                                    try {
                                        this.scriptExecuted = this.processCommandLine(argList);
                                    }
                                    catch (BuildException e) {
                                        this.scriptExecuted = false;
                                        throw e;
                                    }
                                }
                                if (!this.scriptExecuted) {
                                    break block45;
                                }
                                if (!this.allowInput) {
                                    System.setProperty("eclipse.ant.noInput", "true");
                                } else if (this.isVersionCompatible("1.6")) {
                                    this.getCurrentProject().setDefaultInputStream(originalIn);
                                }
                                this.getCurrentProject().log(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Build_file__{0}_1"), this.getBuildFileLocation()));
                                this.setTasks(this.getCurrentProject());
                                this.setTypes(this.getCurrentProject());
                                if (this.isVersionCompatible("1.6")) {
                                    this.getCurrentProject().setKeepGoingMode(this.keepGoing);
                                }
                                this.parseBuildFile(this.getCurrentProject());
                                this.validateDefaultTarget();
                                this.createMonitorBuildListener(this.getCurrentProject());
                                if (this.projectHelp) {
                                    this.printHelp(this.getCurrentProject());
                                    this.scriptExecuted = false;
                                    break block46;
                                }
                                if (this.extraArguments != null) {
                                    this.printArguments(this.getCurrentProject());
                                }
                                System.setSecurityManager(new AntSecurityManager(originalSM));
                                if (this.targets != null && !this.targets.isEmpty()) {
                                    this.getCurrentProject().executeTargets(this.targets);
                                    break block47;
                                } else {
                                    this.getCurrentProject().executeTarget(this.getCurrentProject().getDefaultTarget());
                                }
                                break block47;
                            }
                            catch (OperationCanceledException e) {
                                this.scriptExecuted = false;
                                this.logMessage(this.getCurrentProject(), e.getMessage(), 2);
                                throw e;
                            }
                            catch (AntSecurityException antSecurityException) {
                                break block47;
                            }
                            catch (RuntimeException e) {
                                error = e;
                                throw e;
                            }
                            catch (Error e) {
                                error = e;
                                throw e;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var8_10 = null;
                            System.setErr(originalErr);
                            System.setOut(originalOut);
                            System.setIn(originalIn);
                            if (System.getSecurityManager() instanceof AntSecurityManager) {
                                System.setSecurityManager(originalSM);
                            }
                            if (!this.projectHelp) {
                                this.fireBuildFinished(this.getCurrentProject(), error);
                            }
                            if (this.err != originalErr) {
                                this.err.close();
                            }
                            if (this.out != originalOut) {
                                this.out.close();
                            }
                            this.processAntHome(true);
                            if (this.allowInput) throw throwable;
                            System.getProperties().remove("eclipse.ant.noInput");
                            throw throwable;
                        }
                    }
                    System.setErr(originalErr);
                    System.setOut(originalOut);
                    System.setIn(originalIn);
                    if (System.getSecurityManager() instanceof AntSecurityManager) {
                        System.setSecurityManager(originalSM);
                    }
                    if (!this.projectHelp) {
                        this.fireBuildFinished(this.getCurrentProject(), error);
                    }
                    if (this.err != originalErr) {
                        this.err.close();
                    }
                    if (this.out != originalOut) {
                        this.out.close();
                    }
                    this.processAntHome(true);
                    if (this.allowInput) return;
                    System.getProperties().remove("eclipse.ant.noInput");
                    return;
                }
                Object var8_8 = null;
                System.setErr(originalErr);
                System.setOut(originalOut);
                System.setIn(originalIn);
                if (System.getSecurityManager() instanceof AntSecurityManager) {
                    System.setSecurityManager(originalSM);
                }
                if (!this.projectHelp) {
                    this.fireBuildFinished(this.getCurrentProject(), error);
                }
                if (this.err != originalErr) {
                    this.err.close();
                }
                if (this.out != originalOut) {
                    this.out.close();
                }
                this.processAntHome(true);
                if (this.allowInput) return;
                System.getProperties().remove("eclipse.ant.noInput");
                return;
            }
            Object var8_9 = null;
            System.setErr(originalErr);
            System.setOut(originalOut);
            System.setIn(originalIn);
            if (System.getSecurityManager() instanceof AntSecurityManager) {
                System.setSecurityManager(originalSM);
            }
            if (!this.projectHelp) {
                this.fireBuildFinished(this.getCurrentProject(), error);
            }
            if (this.err != originalErr) {
                this.err.close();
            }
            if (this.out != originalOut) {
                this.out.close();
            }
            this.processAntHome(true);
            if (this.allowInput) return;
            System.getProperties().remove("eclipse.ant.noInput");
            return;
        }
        Object var8_11 = null;
        System.setErr(originalErr);
        System.setOut(originalOut);
        System.setIn(originalIn);
        if (System.getSecurityManager() instanceof AntSecurityManager) {
            System.setSecurityManager(originalSM);
        }
        if (!this.projectHelp) {
            this.fireBuildFinished(this.getCurrentProject(), error);
        }
        if (this.err != originalErr) {
            this.err.close();
        }
        if (this.out != originalOut) {
            this.out.close();
        }
        this.processAntHome(true);
        if (this.allowInput) return;
        System.getProperties().remove("eclipse.ant.noInput");
    }

    private void remapSystemIn() {
        if (!this.isVersionCompatible("1.6")) {
            return;
        }
        DemuxInputStreamSetter setter = new DemuxInputStreamSetter();
        setter.remapSystemIn(this.getCurrentProject());
    }

    private void processAntHome(boolean finished) {
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        String antHome = prefs.getAntHome();
        if (this.buildAntHome != null && !finished) {
            antHome = this.buildAntHome;
        }
        if (antHome == null || antHome.length() == 0) {
            System.getProperties().remove("ant.home");
            System.getProperties().remove("ant.library.dir");
        } else {
            System.setProperty("ant.home", antHome);
            File antLibDir = new File(antHome, "lib");
            System.setProperty("ant.library.dir", antLibDir.getAbsolutePath());
        }
    }

    public void setAntHome(String antHome) {
        this.buildAntHome = antHome;
    }

    private void validateDefaultTarget() {
        this.defaultTarget = this.getCurrentProject().getDefaultTarget();
        Enumeration currentTargets = this.getCurrentProject().getTargets().elements();
        boolean defaultFound = false;
        while (currentTargets.hasMoreElements()) {
            Target target = (Target)currentTargets.nextElement();
            if (!target.getName().equals(this.defaultTarget)) continue;
            defaultFound = true;
            break;
        }
        if (!defaultFound) {
            throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Default_target_{0}{1}{2}_does_not_exist_in_this_project_1"), "'", this.defaultTarget, "'"));
        }
    }

    private BuildLogger createLogger() {
        if (this.loggerClassname == null) {
            this.buildLogger = new DefaultLogger();
        } else if (!"".equals(this.loggerClassname)) {
            try {
                this.buildLogger = (BuildLogger)Class.forName(this.loggerClassname).newInstance();
            }
            catch (ClassCastException e) {
                String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.{0}_which_was_specified_to_perform_logging_is_not_an_instance_of_org.apache.tools.ant.BuildLogger._2"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
            catch (Exception e) {
                String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Unable_to_instantiate_logger__{0}_6"), this.loggerClassname);
                this.logMessage(null, message, 0);
                throw new BuildException(message, (Throwable)e);
            }
        }
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(this.messageOutputLevel);
            this.buildLogger.setOutputPrintStream(this.out);
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setEmacsMode(this.emacsMode);
        }
        return this.buildLogger;
    }

    private void fireBuildStarted(Project project) {
        BuildEvent event = new BuildEvent(project);
        Iterator iterator = project.getBuildListeners().iterator();
        while (iterator.hasNext()) {
            BuildListener listener = (BuildListener)iterator.next();
            listener.buildStarted(event);
        }
    }

    private void fireBuildFinished(Project project, Throwable error) {
        if (this.usingXmlLogger()) {
            String fileName = project.getProperty("XmlLogger.file");
            if (fileName == null) {
                fileName = "log.xml";
            }
            String realPath = new Path(this.getBuildFileLocation()).toFile().getAbsolutePath();
            Path path = new Path(realPath);
            path = path.removeLastSegments(1);
            path = path.addTrailingSeparator();
            path = path.append(fileName);
            project.setProperty("XmlLogger.file", path.toOSString());
        }
        if (error == null && this.scriptExecuted) {
            this.logMessage(project, InternalAntMessages.getString("InternalAntRunner.BUILD_SUCCESSFUL_1"), this.messageOutputLevel);
        }
        project.fireBuildFinished(error);
    }

    private boolean usingXmlLogger() {
        if (this.buildLogger instanceof XmlLogger) {
            return true;
        }
        if (this.buildListeners != null) {
            Enumeration e = this.getCurrentProject().getBuildListeners().elements();
            while (e.hasMoreElements()) {
                BuildListener element = (BuildListener)e.nextElement();
                if (!(element instanceof XmlLogger)) continue;
                return true;
            }
        }
        return false;
    }

    private void logMessage(Project project, String message, int priority) {
        if (project != null) {
            project.log(message, priority);
        } else if (this.buildListeners != null) {
            project = new Project();
            BuildEvent event = new BuildEvent(project);
            event.setMessage(message, priority);
            Iterator iterator = this.buildListeners.iterator();
            while (iterator.hasNext()) {
                try {
                    BuildListener listener = (BuildListener)iterator.next();
                    listener.messageLogged(event);
                }
                catch (ClassCastException classCastException) {}
            }
        } else {
            Status s = new Status(4, "org.eclipse.ant.core", 120, message, null);
            AntCorePlugin.getPlugin().getLog().log((IStatus)s);
        }
    }

    public void setBuildFileLocation(String buildFileLocation) {
        this.buildFileLocation = buildFileLocation;
        if (this.getCurrentProject() != null) {
            this.getCurrentProject().setUserProperty("ant.file", buildFileLocation);
        }
    }

    public void setInputHandler(String inputHandlerClassname) {
        this.inputHandlerClassname = inputHandlerClassname;
    }

    private String getBuildFileLocation() {
        if (this.buildFileLocation == null) {
            this.buildFileLocation = new File("build.xml").getAbsolutePath();
        }
        return this.buildFileLocation;
    }

    public void setMessageOutputLevel(int level) {
        this.messageOutputLevel = level;
        if (this.buildLogger != null) {
            this.buildLogger.setMessageOutputLevel(level);
        }
    }

    public void setArguments(String[] args) {
        this.extraArguments = args;
    }

    public void setExecutionTargets(String[] executionTargets) {
        this.targets = new Vector(executionTargets.length);
        int i = 0;
        while (i < executionTargets.length) {
            this.targets.add(executionTargets[i]);
            ++i;
        }
    }

    private String getAntVersionNumber() throws BuildException {
        if (this.antVersionNumber == null) {
            try {
                String versionNumber;
                Properties props = new Properties();
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("org.apache.tools.ant.Main");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                InputStream in = clazz.getResourceAsStream("/org/apache/tools/ant/version.txt");
                props.load(in);
                in.close();
                this.antVersionNumber = versionNumber = props.getProperty("VERSION");
            }
            catch (IOException ioe) {
                throw new BuildException(MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._{0}_9"), ioe.getMessage()));
            }
            catch (NullPointerException nullPointerException) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Could_not_load_the_version_information._10"));
            }
        }
        return this.antVersionNumber;
    }

    private boolean isVersionCompatible(String comparison) {
        String version = this.getAntVersionNumber();
        return version.compareTo(comparison) >= 0;
    }

    private boolean preprocessCommandLine(List commands) {
        String arg = this.getArgument(commands, "-listener");
        while (arg != null) {
            if (arg.length() == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-listener_argument_1"));
            }
            if (this.buildListeners == null) {
                this.buildListeners = new ArrayList(1);
            }
            this.buildListeners.add(arg);
            arg = this.getArgument(commands, "-listener");
        }
        arg = this.getArgument(commands, "-logger");
        if (arg != null) {
            if (arg.length() == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-logger_argument_2"));
            }
            this.loggerClassname = arg;
        }
        if ((arg = this.getArgument(commands, "-logger")) != null) {
            throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Only_one_logger_class_may_be_specified_1"));
        }
        arg = this.getArgument(commands, "-inputhandler");
        if (arg != null) {
            if (!this.isVersionCompatible("1.5")) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Specifying_an_InputHandler_is_an_Ant_1.5.*_feature._Please_update_your_Ant_classpath_to_include_an_Ant_version_greater_than_this._2"));
            }
            if (arg.length() == 0) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_classname_when_using_the_-inputhandler_argument_1"));
            }
            this.inputHandlerClassname = arg;
        }
        if ((arg = this.getArgument(commands, "-inputhandler")) != null) {
            throw new BuildException(InternalAntMessages.getString("InternalAntRunner.Only_one_input_handler_class_may_be_specified._2"));
        }
        return true;
    }

    private boolean processCommandLine(List commands) {
        if (commands.remove("-help") || commands.remove("-h")) {
            this.printUsage();
            return false;
        }
        if (commands.remove("-version")) {
            this.printVersion();
            return false;
        }
        if (commands.remove("-verbose") || commands.remove("-v")) {
            this.printVersion();
            this.setMessageOutputLevel(3);
        }
        if (commands.remove("-debug") || commands.remove("-d")) {
            this.printVersion();
            this.setMessageOutputLevel(4);
        }
        if (commands.remove("-quiet") || commands.remove("-q")) {
            this.setMessageOutputLevel(1);
        }
        if (commands.remove("-emacs") || commands.remove("-e")) {
            this.emacsMode = true;
            if (this.buildLogger != null) {
                this.buildLogger.setEmacsMode(true);
            }
        }
        if (commands.remove("-diagnostics")) {
            if (!this.isVersionCompatible("1.5")) {
                throw new BuildException(InternalAntMessages.getString("InternalAntRunner.The_diagnositics_options_is_an_Ant_1.5.*_feature._Please_update_your_Ant_classpath_to_include_an_Ant_version_greater_than_this._4"));
            }
            try {
                Diagnostics.doReport((PrintStream)System.out);
            }
            catch (NullPointerException nullPointerException) {
                this.logMessage(this.getCurrentProject(), InternalAntMessages.getString("InternalAntRunner.ANT_HOME_must_be_set_to_use_Ant_diagnostics_2"), 0);
            }
            return false;
        }
        String arg = this.getArgument(commands, "-logfile");
        if (arg == null) {
            arg = this.getArgument(commands, "-l");
        }
        if (arg != null) {
            if (arg.length() == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_log_file_when_using_the_-log_argument_3");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            try {
                this.createLogFile(arg);
            }
            catch (IOException iOException) {
                this.logMessage(this.getCurrentProject(), MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_write_to_the_specified_log_file__{0}._Make_sure_the_path_exists_and_you_have_write_permissions._2"), arg), 0);
                return false;
            }
        }
        if ((arg = this.getArgument(commands, "-buildfile")) == null && (arg = this.getArgument(commands, "-file")) == null) {
            arg = this.getArgument(commands, "-f");
        }
        if (arg != null) {
            if (arg.length() == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_buildfile_when_using_the_-buildfile_argument_4");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            this.setBuildFileLocation(arg);
        }
        if (this.isVersionCompatible("1.6")) {
            if (commands.remove("-k") || commands.remove("-keep-going")) {
                this.keepGoing = true;
            }
            if (commands.remove("-noinput")) {
                this.allowInput = false;
            }
            if ((arg = this.getArgument(commands, "-lib")) != null) {
                this.logMessage(this.currentProject, InternalAntMessages.getString("InternalAntRunner.157"), 0);
                return false;
            }
        }
        if ((arg = this.getArgument(commands, "-find")) == null) {
            arg = this.getArgument(commands, "-s");
        }
        if (arg != null) {
            this.logMessage(this.currentProject, InternalAntMessages.getString("InternalAntRunner.-find_not_supported"), 0);
            return false;
        }
        if (commands != null && !commands.isEmpty()) {
            this.processUnrecognizedCommands(commands);
        }
        if (commands != null && !commands.isEmpty()) {
            this.processTargets(commands);
        }
        return true;
    }

    private void processUnrecognizedCommands(List commands) {
        int p = -1;
        int i = commands.size() - 1;
        while (i >= 0) {
            if (((String)commands.get(0)).startsWith("-")) {
                p = i;
                break;
            }
            --i;
        }
        if (p < 0) {
            return;
        }
        String s = "";
        int i2 = 0;
        while (i2 <= p) {
            s = String.valueOf(s) + " " + (String)commands.get(0);
            commands.remove(0);
            ++i2;
        }
        String message = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Unknown_argument__{0}_2"), s.substring(1));
        this.logMessage(this.currentProject, message, 1);
    }

    private void processTargets(List commands) {
        if (this.targets == null) {
            this.targets = new Vector(commands.size());
        }
        Iterator iter = commands.iterator();
        while (iter.hasNext()) {
            this.targets.add(iter.next());
        }
    }

    private void createLogFile(String fileName) throws FileNotFoundException, IOException {
        File logFile = this.getFileRelativeToBaseDir(fileName);
        this.err = this.out = new PrintStream(new FileOutputStream(logFile));
        this.logMessage(this.getCurrentProject(), MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Using_{0}_file_as_build_log._1"), logFile.getCanonicalPath()), 2);
        if (this.buildLogger != null) {
            this.buildLogger.setErrorPrintStream(this.err);
            this.buildLogger.setOutputPrintStream(this.out);
        }
    }

    private File getFileRelativeToBaseDir(String fileName) {
        Path path = new Path(fileName);
        if (!path.isAbsolute()) {
            String base = this.getCurrentProject().getUserProperty("basedir");
            if (base != null) {
                File baseDir = new File(base);
                if (baseDir != null) {
                    path = new Path(baseDir.getAbsolutePath());
                }
            } else {
                path = new Path(this.getBuildFileLocation());
                path = path.removeLastSegments(1);
            }
            path = path.addTrailingSeparator();
            path = path.append(fileName);
        }
        return path.toFile();
    }

    private void processProperties(List commands) {
        String arg = this.getArgument(commands, "-propertyfile");
        while (arg != null) {
            if (!this.isVersionCompatible("1.5")) {
                this.logMessage(this.currentProject, InternalAntMessages.getString("InternalAntRunner.Specifying_property_files_is_a_Ant_1.5.*_feature._Please_update_your_Ant_classpath._6"), 0);
                break;
            }
            if (arg.length() == 0) {
                String message = InternalAntMessages.getString("InternalAntRunner.You_must_specify_a_property_filename_when_using_the_-propertyfile_argument_3");
                this.logMessage(this.currentProject, message, 0);
                throw new BuildException(message);
            }
            this.propertyFiles.add(arg);
            arg = this.getArgument(commands, "-propertyfile");
        }
        String[] globalPropertyFiles = AntCorePlugin.getPlugin().getPreferences().getCustomPropertyFiles();
        if (globalPropertyFiles.length > 0) {
            if (this.propertyFiles == null) {
                this.propertyFiles = new ArrayList(globalPropertyFiles.length);
            }
            this.propertyFiles.addAll(Arrays.asList(globalPropertyFiles));
        }
        if (this.propertyFiles != null && !this.propertyFiles.isEmpty()) {
            this.loadPropertyFiles();
        }
        if (commands == null) {
            return;
        }
        this.processMinusDProperties(commands);
    }

    private void processMinusDProperties(List commands) {
        String[] args = commands.toArray(new String[commands.size()]);
        int i = 0;
        while (i < args.length) {
            String arg = args[i];
            if (arg.startsWith("-D")) {
                String name = arg.substring(2, arg.length());
                String value = null;
                int posEq = name.indexOf("=");
                if (posEq == 0) {
                    value = name.substring(1);
                    name = "";
                } else if (posEq > 0 && posEq != name.length() - 1) {
                    value = name.substring(posEq + 1).trim();
                    name = name.substring(0, posEq);
                }
                if (value != null) {
                    if (this.userProperties == null) {
                        this.userProperties = new HashMap();
                    }
                    this.userProperties.put(name, value);
                    commands.remove(args[i]);
                }
            }
            ++i;
        }
    }

    private void printHelp(Project project) {
        if (project.getDescription() != null) {
            this.logMessage(project, project.getDescription(), 2);
        }
        this.printTargets(project);
    }

    private void printVersion() {
        this.logMessage(this.getCurrentProject(), Main.getAntVersion(), 2);
    }

    private void printUsage() {
        String lSep = System.getProperty("line.separator");
        StringBuffer msg = new StringBuffer();
        msg.append("ant [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.options_13"));
        msg.append("] [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append(" [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("2 [");
        msg.append(InternalAntMessages.getString("InternalAntRunner.target_15"));
        msg.append("3] ...]]");
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner.Options___21"));
        msg.append(lSep);
        msg.append("\t-help, -h\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_this_message_23"));
        msg.append(lSep);
        msg.append("\t-projecthelp, -p\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_project_help_information_25"));
        msg.append(lSep);
        msg.append("\t-version\t\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_the_version_information_and_exit_27"));
        msg.append(lSep);
        msg.append("\t-diagnostics\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.12"));
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner.13"));
        msg.append(lSep);
        msg.append("\t-quiet, -q\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.be_extra_quiet_29"));
        msg.append(lSep);
        msg.append("\t-verbose, -v\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.be_extra_verbose_31"));
        msg.append(lSep);
        msg.append("\t-debug, -d\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.print_debugging_information_33"));
        msg.append(lSep);
        msg.append("\t-emacs, -e\t\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.produce_logging_information_without_adornments_35"));
        msg.append(lSep);
        msg.append("\t-logfile\t<file>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_given_file_for_log_37"));
        msg.append(lSep);
        msg.append("\t\t-l\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t-logger <classname>\t\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.the_class_which_is_to_perform_logging_39"));
        msg.append(lSep);
        msg.append("\t-listener <classname>\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.add_an_instance_of_class_as_a_project_listener_41"));
        msg.append(lSep);
        msg.append("\t-noinput\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.158"));
        msg.append(lSep);
        msg.append("\t-buildfile\t<file>\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_given_buildfile_43"));
        msg.append(lSep);
        msg.append("\t\t-file\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t\t-f\t\t<file>");
        msg.append(InternalAntMessages.getString("InternalAntRunner.1"));
        msg.append(lSep);
        msg.append("\t-D<property>=<value>\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.use_value_for_given_property_45"));
        msg.append(lSep);
        msg.append("\t-keep-going, -k");
        msg.append(InternalAntMessages.getString("InternalAntRunner.159"));
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner.160"));
        msg.append(lSep);
        msg.append("\t-propertyfile <name>\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.19"));
        msg.append(lSep);
        msg.append(InternalAntMessages.getString("InternalAntRunner.20"));
        msg.append(lSep);
        msg.append("\t-inputhandler <class>\t");
        msg.append(InternalAntMessages.getString("InternalAntRunner.22"));
        msg.append(lSep);
        this.logMessage(this.getCurrentProject(), msg.toString(), 2);
    }

    private String getArgument(List commands, String param) {
        if (commands == null) {
            return null;
        }
        int index = commands.indexOf(param);
        if (index == -1) {
            return null;
        }
        commands.remove(index);
        if (index == commands.size()) {
            return "";
        }
        String command = (String)commands.get(index);
        if (command.startsWith("-")) {
            return "";
        }
        commands.remove(index);
        return command;
    }

    private ArrayList getArrayList(String[] args) {
        if (args == null) {
            return null;
        }
        ArrayList<String> result = new ArrayList<String>(args.length);
        int i = 0;
        while (i < args.length) {
            result.add(args[i]);
            ++i;
        }
        return result;
    }

    public void setProgressMonitor(IProgressMonitor monitor) {
        this.monitor = monitor;
    }

    private Project getCurrentProject() {
        return this.currentProject;
    }

    private void setCurrentProject(Project currentProject) {
        this.currentProject = currentProject;
    }

    public String getBuildExceptionErrorMessage(Throwable t) {
        if (t instanceof BuildException) {
            return t.toString();
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadPropertyFiles() {
        Iterator itr = this.propertyFiles.iterator();
        block8: while (true) {
            Properties props;
            block12: {
                Object var8_9;
                if (!itr.hasNext()) {
                    return;
                }
                String filename = (String)itr.next();
                File file = this.getFileRelativeToBaseDir(filename);
                props = new Properties();
                FileInputStream fis = null;
                try {
                    try {
                        fis = new FileInputStream(file);
                        props.load(fis);
                    }
                    catch (IOException e) {
                        String msg = MessageFormat.format(InternalAntMessages.getString("InternalAntRunner.Could_not_load_property_file_{0}__{1}_4"), filename, e.getMessage());
                        this.logMessage(this.getCurrentProject(), msg, 0);
                    }
                }
                catch (Throwable throwable) {
                    var8_9 = null;
                    if (fis == null) throw throwable;
                    try {
                        fis.close();
                        throw throwable;
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                {
                    var8_9 = null;
                    if (fis == null) break block12;
                }
                try {}
                catch (IOException iOException) {}
                fis.close();
            }
            if (this.userProperties == null) {
                this.userProperties = new HashMap();
            }
            Enumeration<?> propertyNames = props.propertyNames();
            while (true) {
                if (!propertyNames.hasMoreElements()) continue block8;
                String name = (String)propertyNames.nextElement();
                if (this.userProperties.get(name) != null) continue;
                this.userProperties.put(name, props.getProperty(name));
            }
            break;
        }
    }

    private void addInputHandler(Project project) {
        if (!this.isVersionCompatible("1.5")) {
            return;
        }
        InputHandlerSetter setter = new InputHandlerSetter();
        setter.setInputHandler(project, this.inputHandlerClassname);
    }

    private void setJavaClassPath() {
        org.apache.tools.ant.types.Path systemClasspath;
        URL[] antClasspath = null;
        AntCorePreferences prefs = AntCorePlugin.getPlugin().getPreferences();
        if (this.customClasspath == null) {
            antClasspath = prefs.getURLs();
        } else {
            URL[] extraClasspath = prefs.getExtraClasspathURLs();
            antClasspath = new URL[this.customClasspath.length + extraClasspath.length];
            System.arraycopy(this.customClasspath, 0, antClasspath, 0, this.customClasspath.length);
            System.arraycopy(extraClasspath, 0, antClasspath, this.customClasspath.length, extraClasspath.length);
        }
        StringBuffer buff = new StringBuffer();
        File file = null;
        int i = 0;
        while (i < antClasspath.length) {
            block5: {
                try {
                    file = new File(Platform.asLocalURL((URL)antClasspath[i]).getPath());
                }
                catch (IOException iOException) {
                    break block5;
                }
                buff.append(file.getAbsolutePath());
                buff.append("; ");
            }
            ++i;
        }
        org.apache.tools.ant.types.Path.systemClasspath = systemClasspath = new org.apache.tools.ant.types.Path(null, buff.substring(0, buff.length() - 2));
    }

    public void setCustomClasspath(URL[] classpath) {
        this.customClasspath = classpath;
    }
}

