/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.registry;

import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.registry.ActionSetRegistry;
import org.eclipse.ui.internal.registry.RegistryReader;

public class ActionSetPartAssociationsReader
extends RegistryReader {
    private ActionSetRegistry registry;
    private static final String TAG_EXTENSION = "actionSetPartAssociation";
    private static final String TAG_PART = "part";
    private static final String ATT_ID = "id";
    private static final String ATT_TARGET_ID = "targetID";

    public ActionSetPartAssociationsReader() {
    }

    public ActionSetPartAssociationsReader(ActionSetRegistry registry) {
        this.registry = registry;
    }

    private boolean processExtension(IConfigurationElement element) {
        String actionSetId = element.getAttribute(ATT_TARGET_ID);
        IConfigurationElement[] children = element.getChildren();
        int i = 0;
        while (i < children.length) {
            IConfigurationElement child = children[i];
            String type = child.getName();
            if (type.equals(TAG_PART)) {
                String partId = child.getAttribute(ATT_ID);
                if (partId != null) {
                    this.registry.addAssociation(actionSetId, partId);
                }
            } else {
                WorkbenchPlugin.log("Unable to process element: " + type + " in action set part associations extension: " + element.getDeclaringExtension().getUniqueIdentifier());
            }
            ++i;
        }
        return true;
    }

    public boolean readElement(IConfigurationElement element) {
        String type = element.getName();
        if (type.equals(TAG_EXTENSION)) {
            return this.processExtension(element);
        }
        return false;
    }

    public void readRegistry(IExtensionRegistry in, ActionSetRegistry out) {
        this.registry = out;
        this.readRegistry(in, "org.eclipse.ui", "actionSetPartAssociations");
    }
}

