/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.JobTreeElement;
import org.eclipse.ui.internal.progress.NewProgressViewer;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressMessages;
import org.eclipse.ui.internal.progress.ProgressTreeContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewUpdater;
import org.eclipse.ui.internal.util.ImageSupport;
import org.eclipse.ui.part.ViewPart;

public class JobView
extends ViewPart
implements IViewPart {
    NewProgressViewer viewer;
    Action cancelAction;
    Action clearAllAction;

    public void createPartControl(Composite parent) {
        this.viewer = new NewProgressViewer(parent, 770);
        this.viewer.setUseHashlookup(true);
        this.viewer.setSorter(ProgressManagerUtil.getProgressViewerSorter());
        this.initContentProvider();
        this.createClearAllAction();
        this.createCancelAction();
        this.initContextMenu();
        this.initPulldownMenu();
        this.initToolBar();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
    }

    public void setFocus() {
        if (this.viewer != null) {
            this.viewer.setFocus();
        }
    }

    protected void initContentProvider() {
        ProgressTreeContentProvider provider = new ProgressTreeContentProvider(this.viewer);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput((IContentProvider)provider);
    }

    private void initContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        menuMgr.add((IAction)this.cancelAction);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                JobInfo info = JobView.this.getSelectedInfo();
                if (info == null) {
                    return;
                }
            }
        });
        menuMgr.add((IContributionItem)new Separator("additions"));
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
        this.viewer.getControl().setMenu(menu);
    }

    private void initPulldownMenu() {
        IMenuManager menuMgr = this.getViewSite().getActionBars().getMenuManager();
        menuMgr.add((IAction)this.clearAllAction);
        menuMgr.add((IAction)new Action(ProgressMessages.getString("ProgressView.VerboseAction"), 2){

            public void run() {
                ProgressViewUpdater updater = ProgressViewUpdater.getSingleton();
                updater.debug = !updater.debug;
                this.setChecked(updater.debug);
                updater.refreshAll();
            }
        });
    }

    private void initToolBar() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager tm = bars.getToolBarManager();
        tm.add((IAction)this.clearAllAction);
    }

    private IStructuredSelection getSelection() {
        ISelectionProvider provider = this.getSite().getSelectionProvider();
        if (provider == null) {
            return null;
        }
        ISelection currentSelection = provider.getSelection();
        if (currentSelection instanceof IStructuredSelection) {
            return (IStructuredSelection)currentSelection;
        }
        return null;
    }

    JobInfo getSelectedInfo() {
        JobTreeElement element;
        IStructuredSelection selection = this.getSelection();
        if (selection != null && selection.size() == 1 && (element = (JobTreeElement)selection.getFirstElement()).isJobInfo()) {
            return (JobInfo)element;
        }
        return null;
    }

    private void createCancelAction() {
        this.cancelAction = new Action(ProgressMessages.getString("ProgressView.CancelAction")){

            public void run() {
                JobView.this.viewer.cancelSelection();
            }
        };
    }

    private void createClearAllAction() {
        this.clearAllAction = new Action(ProgressMessages.getString("ProgressView.ClearAllAction")){

            public void run() {
                JobView.this.viewer.clearAll();
            }
        };
        this.clearAllAction.setToolTipText(ProgressMessages.getString("NewProgressView.RemoveAllJobsToolTip"));
        ImageDescriptor id = ImageSupport.getImageDescriptor("icons/full/elcl16/progress_remall.gif");
        if (id != null) {
            this.clearAllAction.setImageDescriptor(id);
        }
        if ((id = ImageSupport.getImageDescriptor("icons/full/dlcl16/progress_remall.gif")) != null) {
            this.clearAllAction.setDisabledImageDescriptor(id);
        }
    }
}

