/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.internal.WorkbenchMessages;

public class ResetPerspectiveAction
extends Action
implements ActionFactory.IWorkbenchAction {
    private IWorkbenchWindow workbenchWindow;

    public ResetPerspectiveAction() {
        this(PlatformUI.getWorkbench().getActiveWorkbenchWindow());
    }

    public ResetPerspectiveAction(IWorkbenchWindow window) {
        super(WorkbenchMessages.getString("ResetPerspective.text"));
        if (window == null) {
            throw new IllegalArgumentException();
        }
        this.workbenchWindow = window;
        this.setActionDefinitionId("org.eclipse.ui.window.resetPerspective");
        this.setToolTipText(WorkbenchMessages.getString("ResetPerspective.toolTip"));
        this.setEnabled(false);
        WorkbenchHelp.setHelp((IAction)this, "org.eclipse.ui.reset_perspective_action_context");
    }

    public void run() {
        if (this.workbenchWindow == null) {
            return;
        }
        IWorkbenchPage page = this.workbenchWindow.getActivePage();
        if (page != null && page.getPerspective() != null) {
            String message = WorkbenchMessages.format("ResetPerspective.message", new Object[]{page.getPerspective().getLabel()});
            String[] buttons = new String[]{IDialogConstants.OK_LABEL, IDialogConstants.CANCEL_LABEL};
            MessageDialog d = new MessageDialog(this.workbenchWindow.getShell(), WorkbenchMessages.getString("ResetPerspective.title"), null, message, 3, buttons, 0);
            if (d.open() == 0) {
                page.resetPerspective();
            }
        }
    }

    public void dispose() {
        if (this.workbenchWindow == null) {
            return;
        }
        this.workbenchWindow = null;
    }
}

