/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.application;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.application.IActionBarConfigurer;
import org.eclipse.ui.application.IWorkbenchConfigurer;
import org.eclipse.ui.application.IWorkbenchWindowConfigurer;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindowConfigurer;
import org.eclipse.ui.internal.util.PrefUtil;

public abstract class WorkbenchAdvisor {
    public static final int FILL_PROXY = 1;
    public static final int FILL_MENU_BAR = 2;
    public static final int FILL_COOL_BAR = 4;
    public static final int FILL_STATUS_LINE = 8;
    private IWorkbenchConfigurer workbenchConfigurer;
    private boolean introOpened;

    protected WorkbenchAdvisor() {
    }

    public final void internalBasicInitialize(IWorkbenchConfigurer configurer) {
        if (this.workbenchConfigurer != null) {
            throw new IllegalStateException();
        }
        this.workbenchConfigurer = configurer;
        this.initialize(configurer);
    }

    public void initialize(IWorkbenchConfigurer configurer) {
    }

    protected IWorkbenchConfigurer getWorkbenchConfigurer() {
        return this.workbenchConfigurer;
    }

    public void preStartup() {
    }

    public void postStartup() {
    }

    public boolean preShutdown() {
        return true;
    }

    public void postShutdown() {
    }

    public void eventLoopException(Throwable exception) {
        if (exception == null) {
            return;
        }
        try {
            String msg = exception.getMessage();
            if (msg == null) {
                msg = exception.toString();
            }
            WorkbenchPlugin.log("Unhandled event loop exception", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, exception));
            Throwable nested = null;
            if (exception instanceof SWTException) {
                nested = ((SWTException)exception).throwable;
            } else if (exception instanceof SWTError) {
                nested = ((SWTError)exception).throwable;
            }
            if (nested != null) {
                msg = nested.getMessage();
                if (msg == null) {
                    msg = nested.toString();
                }
                WorkbenchPlugin.log("*** SWT nested exception", (IStatus)new Status(4, "org.eclipse.ui", 0, msg, nested));
            }
            if (WorkbenchPlugin.DEBUG) {
                exception.printStackTrace();
            }
        }
        catch (Throwable e) {
            System.err.println("Error while logging event loop exception:");
            exception.printStackTrace();
            System.err.println("Logging exception:");
            e.printStackTrace();
        }
    }

    public void eventLoopIdle(Display display) {
        display.sleep();
    }

    public void preWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public void fillActionBars(IWorkbenchWindow window, IActionBarConfigurer configurer, int flags) {
    }

    public void postWindowRestore(IWorkbenchWindowConfigurer configurer) throws WorkbenchException {
    }

    public void openIntro(IWorkbenchWindowConfigurer configurer) {
        if (this.introOpened) {
            return;
        }
        this.introOpened = true;
        boolean showIntro = PrefUtil.getAPIPreferenceStore().getBoolean("showIntro");
        if (!showIntro) {
            return;
        }
        if (this.getWorkbenchConfigurer().getWorkbench().getIntroManager().hasIntro()) {
            this.getWorkbenchConfigurer().getWorkbench().getIntroManager().showIntro(configurer.getWindow(), false);
            PrefUtil.getAPIPreferenceStore().setValue("showIntro", false);
            PrefUtil.saveAPIPrefs();
        }
    }

    public void postWindowCreate(IWorkbenchWindowConfigurer configurer) {
    }

    public void postWindowOpen(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean preWindowShellClose(IWorkbenchWindowConfigurer configurer) {
        return true;
    }

    public void postWindowClose(IWorkbenchWindowConfigurer configurer) {
    }

    public boolean isApplicationMenu(IWorkbenchWindowConfigurer configurer, String menuId) {
        return false;
    }

    public IAdaptable getDefaultPageInput() {
        return null;
    }

    public abstract String getInitialWindowPerspectiveId();

    public String getMainPreferencePageId() {
        return null;
    }

    public void createWindowContents(IWorkbenchWindowConfigurer configurer, Shell shell) {
        ((WorkbenchWindowConfigurer)configurer).createDefaultContents(shell);
    }

    public boolean openWindows() {
        IStatus status = this.getWorkbenchConfigurer().restoreState();
        if (!status.isOK()) {
            if (status.getCode() == 2) {
                return false;
            }
            if (status.getCode() == 1) {
                this.getWorkbenchConfigurer().openFirstTimeWindow();
            }
        }
        return true;
    }
}

