/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.forms.widgets;

import java.util.Hashtable;
import org.eclipse.jface.util.Assert;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.forms.widgets.ExpandableComposite;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public final class Section
extends ExpandableComposite {
    public static final int DESCRIPTION = 128;
    private Label descriptionLabel;
    private Control separator;
    private Hashtable titleColors;
    private static final String COLOR_BG = "bg";
    private static final String COLOR_GBG = "gbg";
    private static final String COLOR_FG = "fg";
    private static final String COLOR_BORDER = "border";

    public Section(Composite parent, int style) {
        super(parent, 0, style);
        if ((style & 0x80) != 0) {
            this.descriptionLabel = new Label((Composite)this, 64);
        }
    }

    protected void internalSetExpanded(boolean expanded) {
        super.internalSetExpanded(expanded);
        this.reflow();
    }

    protected void reflow() {
        Section c = this;
        while (c != null) {
            c.setRedraw(false);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
        for (c = this; c != null; c = c.getParent()) {
            c.layout(true);
            if (!(c instanceof ScrolledForm)) continue;
            ((ScrolledForm)((Object)c)).reflow(true);
            break;
        }
        c = this;
        while (c != null) {
            c.setRedraw(true);
            c = c.getParent();
            if (c instanceof ScrolledForm) break;
        }
    }

    public void setDescription(String description) {
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setText(description);
        }
    }

    public String getDescription() {
        if (this.descriptionLabel != null) {
            return this.descriptionLabel.getText();
        }
        return null;
    }

    public void setSeparatorControl(Control separator) {
        Assert.isTrue((separator != null && separator.getParent().equals((Object)this) ? 1 : 0) != 0);
        this.separator = separator;
    }

    public Control getSeparatorControl() {
        return this.separator;
    }

    public void setBackground(Color bg) {
        super.setBackground(bg);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setBackground(bg);
        }
    }

    public void setForeground(Color fg) {
        super.setForeground(fg);
        if (this.descriptionLabel != null) {
            this.descriptionLabel.setForeground(fg);
        }
    }

    protected Control getDescriptionControl() {
        return this.descriptionLabel;
    }

    public void setTitleBarBorderColor(Color color) {
        this.putTitleBarColor(COLOR_BORDER, color);
    }

    public void setTitleBarForeground(Color color) {
        this.putTitleBarColor(COLOR_FG, color);
    }

    public void setTitleBarBackground(Color color) {
        this.putTitleBarColor(COLOR_BG, color);
        this.textLabel.setBackground(color);
        if (this.toggle != null) {
            this.toggle.setBackground(color);
        }
    }

    public void setTitleBarGradientBackground(Color color) {
        this.putTitleBarColor(COLOR_GBG, color);
    }

    public Color getTitleBarBorderColor() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BORDER);
    }

    public Color getTitleBarGradientBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_GBG);
    }

    public Color getTitleBarForeground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_FG);
    }

    public Color getTitleBarBackground() {
        if (this.titleColors == null) {
            return null;
        }
        return (Color)this.titleColors.get(COLOR_BG);
    }

    private void putTitleBarColor(String key, Color color) {
        if (this.titleColors == null) {
            this.titleColors = new Hashtable();
        }
        this.titleColors.put(key, color);
    }

    protected void onPaint(PaintEvent e) {
        Color bg = null;
        Color gbg = null;
        Color fg = null;
        Color border = null;
        if (this.titleColors != null) {
            bg = (Color)this.titleColors.get(COLOR_BG);
            gbg = (Color)this.titleColors.get(COLOR_GBG);
            fg = (Color)this.titleColors.get(COLOR_FG);
            border = (Color)this.titleColors.get(COLOR_BORDER);
        }
        if (bg == null) {
            bg = this.getBackground();
        }
        if (fg == null) {
            fg = this.getForeground();
        }
        if (border == null) {
            border = fg;
        }
        if (gbg == null) {
            gbg = bg;
        }
        Rectangle bounds = this.getClientArea();
        Point tsize = null;
        Point tcsize = null;
        if (this.toggle != null) {
            tsize = this.toggle.getSize();
        }
        int twidth = bounds.width - this.marginWidth - this.marginWidth;
        if (tsize != null) {
            twidth -= tsize.x + this.GAP;
        }
        if (this.getTextClient() != null) {
            tcsize = this.getTextClient().getSize();
        }
        if (tcsize != null) {
            twidth -= tcsize.x + this.GAP;
        }
        Point size = this.textLabel.getSize();
        int tvmargin = this.GAP;
        int theight = 0;
        if (tsize != null) {
            theight += Math.max(theight, tsize.y);
        }
        if (tcsize != null) {
            theight = Math.max(theight, tcsize.y);
        }
        theight = Math.max(theight, size.y);
        int midpoint = (theight += tvmargin + tvmargin) * 66 / 100;
        int rem = theight - midpoint;
        GC gc = e.gc;
        gc.setForeground(bg);
        gc.setBackground(gbg);
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight, bounds.width - 1 - this.marginWidth - this.marginWidth, midpoint - 1, true);
        gc.setForeground(gbg);
        gc.setBackground(this.getBackground());
        gc.fillGradientRectangle(this.marginWidth, this.marginHeight + midpoint - 1, bounds.width - 1 - this.marginWidth - this.marginWidth, rem - 1, true);
        gc.setForeground(border);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth, this.marginHeight + theight - 1);
        gc.drawLine(this.marginWidth, this.marginHeight + 2, this.marginWidth + 2, this.marginHeight);
        gc.drawLine(this.marginWidth + 2, this.marginHeight, bounds.width - this.marginWidth - 3, this.marginHeight);
        gc.drawLine(bounds.width - this.marginWidth - 3, this.marginHeight, bounds.width - this.marginWidth - 1, this.marginHeight + 2);
        gc.drawLine(bounds.width - this.marginWidth - 1, this.marginHeight + 2, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
        if (this.toggle != null && !this.isExpanded()) {
            gc.drawLine(this.marginWidth, this.marginHeight + theight - 1, bounds.width - this.marginWidth - 1, this.marginHeight + theight - 1);
        }
    }
}

