/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.wizards.buildpaths;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.dialogs.StatusDialog;
import org.eclipse.jdt.internal.ui.viewsupport.ImageDescriptorRegistry;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.internal.ui.wizards.TypedElementSelectionValidator;
import org.eclipse.jdt.internal.ui.wizards.TypedViewerFilter;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.CPListElement;
import org.eclipse.jdt.internal.ui.wizards.buildpaths.ExclusionInclusionEntryDialog;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.DialogField;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IDialogFieldListener;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.IListAdapter;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.LayoutUtil;
import org.eclipse.jdt.internal.ui.wizards.dialogfields.ListDialogField;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.ElementTreeSelectionDialog;
import org.eclipse.ui.dialogs.ISelectionStatusValidator;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchContentProvider;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ExclusionInclusionDialog
extends StatusDialog {
    private ListDialogField fInclusionPatternList;
    private ListDialogField fExclusionPatternList;
    private CPListElement fCurrElement;
    private IProject fCurrProject;
    private IContainer fCurrSourceFolder;
    private static final int IDX_ADD = 0;
    private static final int IDX_ADD_MULTIPLE = 1;
    private static final int IDX_EDIT = 2;
    private static final int IDX_REMOVE = 4;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public ExclusionInclusionDialog(Shell parent, CPListElement entryToEdit, boolean focusOnExcluded) {
        super(parent);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fCurrElement = entryToEdit;
        this.setTitle(NewWizardMessages.getString("ExclusionInclusionDialog.title"));
        this.fCurrProject = entryToEdit.getJavaProject().getProject();
        IWorkspaceRoot root = this.fCurrProject.getWorkspace().getRoot();
        IResource res = root.findMember(entryToEdit.getPath());
        if (res instanceof IContainer) {
            this.fCurrSourceFolder = (IContainer)res;
        }
        String excLabel = NewWizardMessages.getString("ExclusionInclusionDialog.exclusion.pattern.label");
        ImageDescriptor excDescriptor = JavaPluginImages.DESC_OBJS_EXCLUSION_FILTER_ATTRIB;
        String[] stringArray = new String[5];
        stringArray[0] = NewWizardMessages.getString("ExclusionInclusionDialog.exclusion.pattern.add");
        stringArray[1] = NewWizardMessages.getString("ExclusionInclusionDialog.exclusion.pattern.add.multiple");
        stringArray[2] = NewWizardMessages.getString("ExclusionInclusionDialog.exclusion.pattern.edit");
        stringArray[4] = NewWizardMessages.getString("ExclusionInclusionDialog.exclusion.pattern.remove");
        String[] excButtonLabels = stringArray;
        String incLabel = NewWizardMessages.getString("ExclusionInclusionDialog.inclusion.pattern.label");
        ImageDescriptor incDescriptor = JavaPluginImages.DESC_OBJS_INCLUSION_FILTER_ATTRIB;
        String[] stringArray2 = new String[5];
        stringArray2[0] = NewWizardMessages.getString("ExclusionInclusionDialog.inclusion.pattern.add");
        stringArray2[1] = NewWizardMessages.getString("ExclusionInclusionDialog.inclusion.pattern.add.multiple");
        stringArray2[2] = NewWizardMessages.getString("ExclusionInclusionDialog.inclusion.pattern.edit");
        stringArray2[4] = NewWizardMessages.getString("ExclusionInclusionDialog.inclusion.pattern.remove");
        String[] incButtonLabels = stringArray2;
        this.fExclusionPatternList = this.createListContents(entryToEdit, "exclusion", excLabel, excDescriptor, excButtonLabels);
        this.fInclusionPatternList = this.createListContents(entryToEdit, "inclusion", incLabel, incDescriptor, incButtonLabels);
        if (focusOnExcluded) {
            this.fExclusionPatternList.postSetFocusOnDialogField(parent.getDisplay());
        } else {
            this.fInclusionPatternList.postSetFocusOnDialogField(parent.getDisplay());
        }
    }

    private ListDialogField createListContents(CPListElement entryToEdit, String key, String label, ImageDescriptor descriptor, String[] buttonLabels) {
        ExclusionPatternAdapter adapter = new ExclusionPatternAdapter();
        ListDialogField patternList = new ListDialogField(adapter, buttonLabels, (ILabelProvider)new ExclusionInclusionLabelProvider(descriptor));
        patternList.setDialogFieldListener(adapter);
        patternList.setLabelText(label);
        patternList.setRemoveButtonIndex(4);
        patternList.enableButton(2, false);
        IPath[] pattern = (IPath[])entryToEdit.getAttribute(key);
        ArrayList<String> elements = new ArrayList<String>(pattern.length);
        int i = 0;
        while (i < pattern.length) {
            elements.add(pattern[i].toString());
            ++i;
        }
        patternList.setElements(elements);
        patternList.selectFirstElement();
        patternList.enableButton(1, this.fCurrSourceFolder != null);
        patternList.setViewerSorter(new ViewerSorter());
        return patternList;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        Composite inner = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.numColumns = 2;
        inner.setLayout((Layout)layout);
        inner.setLayoutData((Object)new GridData(1808));
        DialogField labelField = new DialogField();
        String name = this.fCurrElement.getPath().makeRelative().toString();
        labelField.setLabelText(NewWizardMessages.getFormattedString("ExclusionInclusionDialog.description", name));
        labelField.doFillIntoGrid(inner, 2);
        this.fInclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fInclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fInclusionPatternList.getListControl(null));
        this.fExclusionPatternList.doFillIntoGrid(inner, 3);
        LayoutUtil.setHorizontalSpan((Control)this.fExclusionPatternList.getLabelControl(null), 2);
        LayoutUtil.setHorizontalGrabbing(this.fExclusionPatternList.getListControl(null));
        Dialog.applyDialogFont((Control)composite);
        return composite;
    }

    protected void doCustomButtonPressed(ListDialogField field, int index) {
        if (index == 0) {
            this.addEntry(field);
        } else if (index == 2) {
            this.editEntry(field);
        } else if (index == 1) {
            this.addMultipleEntries(field);
        }
    }

    protected void doDoubleClicked(ListDialogField field) {
        this.editEntry(field);
    }

    protected void doSelectionChanged(ListDialogField field) {
        List selected = field.getSelectedElements();
        field.enableButton(2, this.canEdit(selected));
    }

    private boolean canEdit(List selected) {
        return selected.size() == 1;
    }

    private void editEntry(ListDialogField field) {
        List selElements = field.getSelectedElements();
        if (selElements.size() != 1) {
            return;
        }
        List existing = field.getElements();
        String entry = (String)selElements.get(0);
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), entry, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.replaceElement(entry, dialog.getExclusionPattern());
        }
    }

    private boolean isExclusion(ListDialogField field) {
        return field == this.fExclusionPatternList;
    }

    private void addEntry(ListDialogField field) {
        List existing = field.getElements();
        ExclusionInclusionEntryDialog dialog = new ExclusionInclusionEntryDialog(this.getShell(), this.isExclusion(field), null, existing, this.fCurrElement);
        if (dialog.open() == 0) {
            field.addElement(dialog.getExclusionPattern());
        }
    }

    protected void doStatusLineUpdate() {
    }

    protected void checkIfPatternValid() {
    }

    private IPath[] getPattern(ListDialogField field) {
        Object[] arr = field.getElements().toArray();
        Arrays.sort(arr);
        IPath[] res = new IPath[arr.length];
        int i = 0;
        while (i < res.length) {
            res[i] = new Path((String)arr[i]);
            ++i;
        }
        return res;
    }

    public IPath[] getExclusionPattern() {
        return this.getPattern(this.fExclusionPatternList);
    }

    public IPath[] getInclusionPattern() {
        return this.getPattern(this.fInclusionPatternList);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        WorkbenchHelp.setHelp((Control)newShell, (String)"org.eclipse.jdt.ui.exclusion_pattern_dialog_context");
    }

    private void addMultipleEntries(ListDialogField field) {
        String message;
        String title;
        Class[] classArray = new Class[2];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.core.resources.IFolder");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IFile");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[1] = clazz2;
        Class[] acceptedClasses = classArray;
        TypedElementSelectionValidator validator = new TypedElementSelectionValidator(acceptedClasses, true);
        TypedViewerFilter filter = new TypedViewerFilter(acceptedClasses);
        WorkbenchLabelProvider lp = new WorkbenchLabelProvider();
        WorkbenchContentProvider cp = new WorkbenchContentProvider();
        Object initialElement = null;
        if (this.isExclusion(field)) {
            title = NewWizardMessages.getString("ExclusionInclusionDialog.ChooseExclusionPattern.title");
            message = NewWizardMessages.getString("ExclusionInclusionDialog.ChooseExclusionPattern.description");
        } else {
            title = NewWizardMessages.getString("ExclusionInclusionDialog.ChooseInclusionPattern.title");
            message = NewWizardMessages.getString("ExclusionInclusionDialog.ChooseInclusionPattern.description");
        }
        ElementTreeSelectionDialog dialog = new ElementTreeSelectionDialog(this.getShell(), (ILabelProvider)lp, (ITreeContentProvider)cp);
        dialog.setTitle(title);
        dialog.setValidator((ISelectionStatusValidator)validator);
        dialog.setMessage(message);
        dialog.addFilter((ViewerFilter)filter);
        dialog.setInput((Object)this.fCurrSourceFolder);
        dialog.setInitialSelection(initialElement);
        dialog.setSorter((ViewerSorter)new ResourceSorter(1));
        if (dialog.open() == 0) {
            Object[] objects = dialog.getResult();
            int existingSegments = this.fCurrSourceFolder.getFullPath().segmentCount();
            int i = 0;
            while (i < objects.length) {
                IResource curr = (IResource)objects[i];
                IPath path = curr.getFullPath().removeFirstSegments(existingSegments).makeRelative();
                String res = curr instanceof IContainer ? path.addTrailingSeparator().toString() : path.toString();
                field.addElement(res);
                ++i;
            }
        }
    }

    private static class ExclusionInclusionLabelProvider
    extends LabelProvider {
        private Image fElementImage;

        public ExclusionInclusionLabelProvider(ImageDescriptor descriptor) {
            ImageDescriptorRegistry registry = JavaPlugin.getImageDescriptorRegistry();
            this.fElementImage = registry.get(descriptor);
        }

        public Image getImage(Object element) {
            return this.fElementImage;
        }

        public String getText(Object element) {
            return (String)element;
        }
    }

    private class ExclusionPatternAdapter
    implements IListAdapter,
    IDialogFieldListener {
        ExclusionPatternAdapter() {
        }

        public void customButtonPressed(ListDialogField field, int index) {
            ExclusionInclusionDialog.this.doCustomButtonPressed(field, index);
        }

        public void selectionChanged(ListDialogField field) {
            ExclusionInclusionDialog.this.doSelectionChanged(field);
        }

        public void doubleClicked(ListDialogField field) {
            ExclusionInclusionDialog.this.doDoubleClicked(field);
        }

        public void dialogFieldChanged(DialogField field) {
        }
    }
}

