/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.Arrays;
import java.util.Comparator;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.jdt.internal.corext.dom.NodeFinder;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.javaeditor.EditorHighlightingSynchronizer;
import org.eclipse.jdt.internal.ui.javaeditor.JavaEditor;
import org.eclipse.jdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.jdt.ui.text.java.IJavaCompletionProposal;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.contentassist.ICompletionProposalExtension2;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.link.ILinkedModeListener;
import org.eclipse.jface.text.link.LinkedModeModel;
import org.eclipse.jface.text.link.LinkedPosition;
import org.eclipse.jface.text.link.LinkedPositionGroup;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.link.EditorLinkedModeUI;

public class LinkedNamesAssistProposal
implements IJavaCompletionProposal,
ICompletionProposalExtension2 {
    private SimpleName fNode;
    private IRegion fSelectedRegion;
    private ICompilationUnit fCompilationUnit;
    private String fLabel;

    public LinkedNamesAssistProposal(ICompilationUnit cu, SimpleName node) {
        this(CorrectionMessages.getString("LinkedNamesAssistProposal.description"), cu, node);
        this.fNode = node;
        this.fCompilationUnit = cu;
    }

    public LinkedNamesAssistProposal(String label, ICompilationUnit cu, SimpleName node) {
        this.fLabel = label;
        this.fNode = node;
        this.fCompilationUnit = cu;
    }

    public void apply(ITextViewer viewer, char trigger, int stateMask, int offset) {
        try {
            CompilationUnit root = JavaPlugin.getDefault().getASTProvider().getAST((IJavaElement)this.fCompilationUnit, true, null);
            ASTNode nameNode = NodeFinder.perform((ASTNode)root, this.fNode.getStartPosition(), this.fNode.getLength());
            final int pos = this.fNode.getStartPosition();
            Object[] sameNodes = nameNode instanceof SimpleName ? LinkedNodeFinder.findByNode((ASTNode)root, (SimpleName)nameNode) : new ASTNode[]{nameNode};
            Arrays.sort(sameNodes, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return this.rank((ASTNode)o1) - this.rank((ASTNode)o2);
                }

                private int rank(ASTNode node) {
                    int relativeRank = node.getStartPosition() + node.getLength() - pos;
                    if (relativeRank < 0) {
                        return Integer.MAX_VALUE + relativeRank;
                    }
                    return relativeRank;
                }
            });
            IDocument document = viewer.getDocument();
            LinkedPositionGroup group = new LinkedPositionGroup();
            int i = 0;
            while (i < sameNodes.length) {
                SimpleName elem = sameNodes[i];
                group.addPosition(new LinkedPosition(document, elem.getStartPosition(), elem.getLength(), i));
                ++i;
            }
            LinkedModeModel model = new LinkedModeModel();
            model.addGroup(group);
            model.forceInstall();
            JavaEditor editor = this.getJavaEditor();
            if (editor != null) {
                model.addLinkingListener((ILinkedModeListener)new EditorHighlightingSynchronizer(editor));
            }
            EditorLinkedModeUI ui = new EditorLinkedModeUI(model, viewer);
            ui.setExitPosition(viewer, offset, 0, -1);
            ui.enter();
            this.fSelectedRegion = ui.getSelectedRegion();
        }
        catch (BadLocationException e) {
            JavaPlugin.log(e);
        }
    }

    private JavaEditor getJavaEditor() {
        IEditorPart part = JavaPlugin.getActivePage().getActiveEditor();
        if (part instanceof JavaEditor) {
            return (JavaEditor)part;
        }
        return null;
    }

    public void apply(IDocument document) {
    }

    public Point getSelection(IDocument document) {
        if (this.fSelectedRegion == null) {
            return null;
        }
        return new Point(this.fSelectedRegion.getOffset(), this.fSelectedRegion.getLength());
    }

    public String getAdditionalProposalInfo() {
        return CorrectionMessages.getString("LinkedNamesAssistProposal.proposalinfo");
    }

    public String getDisplayString() {
        return this.fLabel;
    }

    public Image getImage() {
        return JavaPluginImages.get("org.eclipse.jdt.ui.localvariable_obj.gif");
    }

    public IContextInformation getContextInformation() {
        return null;
    }

    public int getRelevance() {
        return 1;
    }

    public void selected(ITextViewer textViewer, boolean smartToggle) {
    }

    public void unselected(ITextViewer textViewer) {
    }

    public boolean validate(IDocument document, int offset, DocumentEvent event) {
        return false;
    }
}

