/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.refactoring.actions;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.internal.corext.refactoring.rename.RenameResourceProcessor;
import org.eclipse.jdt.internal.ui.actions.ActionUtil;
import org.eclipse.jdt.internal.ui.refactoring.RefactoringMessages;
import org.eclipse.jdt.internal.ui.refactoring.UserInterfaceStarter;
import org.eclipse.jdt.internal.ui.refactoring.reorg.RenameUserInterfaceManager;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.ui.actions.SelectionDispatchAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.Refactoring;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ui.IWorkbenchSite;

public class RenameResourceAction
extends SelectionDispatchAction {
    public RenameResourceAction(IWorkbenchSite site) {
        super(site);
    }

    public void selectionChanged(IStructuredSelection selection) {
        IResource element = RenameResourceAction.getResource(selection);
        if (element == null) {
            this.setEnabled(false);
        } else {
            RenameResourceProcessor processor = new RenameResourceProcessor(element);
            try {
                this.setEnabled(processor.isApplicable());
            }
            catch (CoreException coreException) {
                this.setEnabled(false);
            }
        }
    }

    public void run(IStructuredSelection selection) {
        IResource resource = RenameResourceAction.getResource(selection);
        if (!ActionUtil.isProcessable(this.getShell(), resource)) {
            return;
        }
        RenameResourceProcessor processor = new RenameResourceProcessor(resource);
        try {
            if (!processor.isApplicable()) {
                return;
            }
            RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)processor);
            UserInterfaceStarter starter = RenameUserInterfaceManager.getDefault().getStarter((Refactoring)refactoring);
            starter.activate((Refactoring)refactoring, this.getShell(), true);
        }
        catch (CoreException e) {
            ExceptionHandler.handle(e, RefactoringMessages.getString("RenameJavaElementAction.name"), RefactoringMessages.getString("RenameJavaElementAction.exception"));
        }
    }

    private static IResource getResource(IStructuredSelection selection) {
        if (selection.size() != 1) {
            return null;
        }
        Object first = selection.getFirstElement();
        if (!(first instanceof IResource)) {
            return null;
        }
        return (IResource)first;
    }
}

