/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.util;

import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;

public class SearchUtils {
    public static IJavaElement getEnclosingJavaElement(SearchMatch match) {
        Object element = match.getElement();
        if (element instanceof IJavaElement) {
            return (IJavaElement)element;
        }
        return null;
    }

    public static int getEnd(SearchMatch match) {
        int offset = match.getOffset();
        int length = match.getLength();
        if (offset == -1 || length == -1) {
            return -1;
        }
        return offset + length;
    }

    public static ICompilationUnit getCompilationUnit(SearchMatch match) {
        IJavaElement jElement;
        IJavaElement enclosingElement = SearchUtils.getEnclosingJavaElement(match);
        if (enclosingElement != null) {
            if (enclosingElement instanceof ICompilationUnit) {
                return (ICompilationUnit)enclosingElement;
            }
            ICompilationUnit cu = (ICompilationUnit)enclosingElement.getAncestor(5);
            if (cu != null) {
                return cu;
            }
        }
        if ((jElement = JavaCore.create((IResource)match.getResource())) != null && jElement.exists() && jElement.getElementType() == 5) {
            return (ICompilationUnit)jElement;
        }
        return null;
    }

    public static SearchParticipant[] getDefaultSearchParticipants() {
        return new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()};
    }
}

