/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.rename;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IImportDeclaration;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.ISourceRange;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.MethodDeclaration;
import org.eclipse.jdt.core.dom.Modifier;
import org.eclipse.jdt.core.dom.TypeDeclaration;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.internal.corext.Assert;
import org.eclipse.jdt.internal.corext.refactoring.Checks;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringCoreMessages;
import org.eclipse.jdt.internal.corext.refactoring.RefactoringSearchEngine;
import org.eclipse.jdt.internal.corext.refactoring.SearchResultGroup;
import org.eclipse.jdt.internal.corext.refactoring.base.JavaStatusContext;
import org.eclipse.jdt.internal.corext.refactoring.changes.DynamicValidationStateChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameCompilationUnitChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.RenameResourceChange;
import org.eclipse.jdt.internal.corext.refactoring.changes.TextChangeCompatibility;
import org.eclipse.jdt.internal.corext.refactoring.participants.JavaProcessors;
import org.eclipse.jdt.internal.corext.refactoring.participants.ResourceModifications;
import org.eclipse.jdt.internal.corext.refactoring.rename.JavaRenameProcessor;
import org.eclipse.jdt.internal.corext.refactoring.rename.RefactoringScopeFactory;
import org.eclipse.jdt.internal.corext.refactoring.rename.TextMatchUpdater;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IQualifiedNameUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.IReferenceUpdating;
import org.eclipse.jdt.internal.corext.refactoring.tagging.ITextUpdating;
import org.eclipse.jdt.internal.corext.refactoring.util.Changes;
import org.eclipse.jdt.internal.corext.refactoring.util.JavaElementUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameFinder;
import org.eclipse.jdt.internal.corext.refactoring.util.QualifiedNameSearchResult;
import org.eclipse.jdt.internal.corext.refactoring.util.RefactoringASTParser;
import org.eclipse.jdt.internal.corext.refactoring.util.ResourceUtil;
import org.eclipse.jdt.internal.corext.refactoring.util.TextChangeManager;
import org.eclipse.jdt.internal.corext.util.JavaModelUtil;
import org.eclipse.jdt.internal.corext.util.JdtFlags;
import org.eclipse.jdt.internal.corext.util.WorkingCopyUtil;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.RefactoringStatusContext;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.RenameArguments;
import org.eclipse.ltk.core.refactoring.participants.SharableParticipants;
import org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker;
import org.eclipse.text.edits.ReplaceEdit;
import org.eclipse.text.edits.TextEdit;

public class RenameTypeProcessor
extends JavaRenameProcessor
implements ITextUpdating,
IReferenceUpdating,
IQualifiedNameUpdating {
    private IType fType;
    private SearchResultGroup[] fReferences;
    private TextChangeManager fChangeManager;
    private QualifiedNameSearchResult fQualifiedNameSearchResult;
    private boolean fUpdateReferences;
    private boolean fUpdateTextualMatches;
    private boolean fUpdateQualifiedNames;
    private String fFilePatterns;
    public static final String IDENTIFIER = "org.eclipse.jdt.ui.renameTypeProcessor";
    static /* synthetic */ Class class$0;

    public RenameTypeProcessor(IType type) {
        this.fType = type;
        this.setNewElementName(this.fType.getElementName());
        this.fUpdateReferences = true;
        this.fUpdateTextualMatches = false;
    }

    public IType getType() {
        return this.fType;
    }

    public String getIdentifier() {
        return IDENTIFIER;
    }

    public boolean isApplicable() throws CoreException {
        if (this.fType == null) {
            return false;
        }
        if (this.fType.isAnonymous()) {
            return false;
        }
        if (!Checks.isAvailable((IJavaElement)this.fType)) {
            return false;
        }
        return !RenameTypeProcessor.isSpecialCase(this.fType);
    }

    public String getProcessorName() {
        return RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
    }

    protected String[] getAffectedProjectNatures() throws CoreException {
        return JavaProcessors.computeAffectedNatures((IJavaElement)this.fType);
    }

    public Object[] getElements() {
        return new Object[]{this.fType};
    }

    protected void loadDerivedParticipants(RefactoringStatus status, List result, String[] natures, SharableParticipants shared) throws CoreException {
        String newCUName = String.valueOf(this.getNewElementName()) + ".java";
        RenameArguments arguments = new RenameArguments(newCUName, this.getUpdateReferences());
        this.loadDerivedParticipants(status, result, this.computeDerivedElements(), arguments, this.computeResourceModifications(), natures, shared);
    }

    private Object[] computeDerivedElements() {
        if (!this.isPrimaryType()) {
            return new Object[0];
        }
        return new Object[]{this.fType.getCompilationUnit()};
    }

    private ResourceModifications computeResourceModifications() {
        if (!this.isPrimaryType()) {
            return null;
        }
        IResource resource = this.fType.getCompilationUnit().getResource();
        if (resource == null) {
            return null;
        }
        ResourceModifications result = new ResourceModifications();
        result.setRename(resource, new RenameArguments(String.valueOf(this.getNewElementName()) + ".java", this.getUpdateReferences()));
        return result;
    }

    public String getCurrentElementName() {
        return this.fType.getElementName();
    }

    public RefactoringStatus checkNewElementName(String newName) {
        Assert.isNotNull(newName, "new name");
        RefactoringStatus result = Checks.checkTypeName(newName);
        if (Checks.isAlreadyNamed((IJavaElement)this.fType, newName)) {
            result.addFatalError(RefactoringCoreMessages.getString("RenameTypeRefactoring.choose_another_name"));
        }
        return result;
    }

    public Object getNewElement() {
        IPackageFragment parent = this.fType.getPackageFragment();
        ICompilationUnit cu = this.isPrimaryType() ? parent.getCompilationUnit(String.valueOf(this.getNewElementName()) + ".java") : this.fType.getCompilationUnit();
        return cu.getType(this.getNewElementName());
    }

    public boolean canEnableTextUpdating() {
        return true;
    }

    public boolean getUpdateTextualMatches() {
        return this.fUpdateTextualMatches;
    }

    public void setUpdateTextualMatches(boolean update) {
        this.fUpdateTextualMatches = update;
    }

    public void setUpdateReferences(boolean update) {
        this.fUpdateReferences = update;
    }

    public boolean canEnableUpdateReferences() {
        return true;
    }

    public boolean getUpdateReferences() {
        return this.fUpdateReferences;
    }

    public boolean canEnableQualifiedNameUpdating() {
        return !this.fType.getPackageFragment().isDefaultPackage() && !(this.fType.getParent() instanceof IType);
    }

    public boolean getUpdateQualifiedNames() {
        return this.fUpdateQualifiedNames;
    }

    public void setUpdateQualifiedNames(boolean update) {
        this.fUpdateQualifiedNames = update;
    }

    public String getFilePatterns() {
        return this.fFilePatterns;
    }

    public void setFilePatterns(String patterns) {
        Assert.isNotNull(patterns);
        this.fFilePatterns = patterns;
    }

    public RefactoringStatus checkInitialConditions(IProgressMonitor pm) throws CoreException {
        IType orig = (IType)WorkingCopyUtil.getOriginal((IMember)this.fType);
        if (orig == null || !orig.exists()) {
            String message = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.does_not_exist", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.fType.getCompilationUnit().getElementName()});
            return RefactoringStatus.createFatalErrorStatus((String)message);
        }
        this.fType = orig;
        return Checks.checkIfCuBroken((IMember)this.fType);
    }

    public RefactoringStatus checkFinalConditions(IProgressMonitor pm, CheckConditionsContext context) throws CoreException {
        Class<?> clazz;
        RefactoringStatus result;
        block23: {
            block22: {
                block21: {
                    block20: {
                        block19: {
                            RefactoringStatus refactoringStatus;
                            Assert.isNotNull(this.fType, "type");
                            Assert.isNotNull(this.getNewElementName(), "newName");
                            result = new RefactoringStatus();
                            try {
                                pm.beginTask("", 120);
                                pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
                                result.merge(this.checkNewElementName(this.getNewElementName()));
                                if (!result.hasFatalError()) break block19;
                                refactoringStatus = result;
                                Object var5_10 = null;
                            }
                            catch (Throwable throwable) {
                                Object var5_16 = null;
                                pm.done();
                                throw throwable;
                            }
                            pm.done();
                            return refactoringStatus;
                        }
                        result.merge(Checks.checkIfCuBroken((IMember)this.fType));
                        if (!result.hasFatalError()) break block20;
                        RefactoringStatus refactoringStatus = result;
                        Object var5_11 = null;
                        pm.done();
                        return refactoringStatus;
                    }
                    pm.worked(2);
                    result.merge(this.checkTypesInCompilationUnit());
                    pm.worked(1);
                    result.merge(this.checkForMethodsWithConstructorNames());
                    pm.worked(1);
                    result.merge(this.checkImportedTypes());
                    pm.worked(1);
                    if (this.mustRenameCU()) {
                        result.merge(Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()));
                    }
                    pm.worked(1);
                    if (this.isPrimaryType()) {
                        result.merge(this.checkNewPathValidity());
                    }
                    pm.worked(1);
                    result.merge(this.checkEnclosingTypes());
                    pm.worked(1);
                    result.merge(this.checkEnclosedTypes());
                    pm.worked(1);
                    result.merge(this.checkTypesInPackage());
                    pm.worked(1);
                    result.merge(this.checkTypesImportedInCu());
                    pm.worked(1);
                    result.merge(Checks.checkForNativeMethods(this.fType));
                    pm.worked(1);
                    result.merge(Checks.checkForMainMethod(this.fType));
                    pm.worked(1);
                    if (!result.hasFatalError()) break block21;
                    RefactoringStatus refactoringStatus = result;
                    Object var5_12 = null;
                    pm.done();
                    return refactoringStatus;
                }
                result.merge(this.analyseEnclosedTypes());
                pm.worked(1);
                if (!result.hasFatalError()) break block22;
                RefactoringStatus refactoringStatus = result;
                Object var5_13 = null;
                pm.done();
                return refactoringStatus;
            }
            if (this.fUpdateReferences) {
                pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching"));
                this.fReferences = this.getReferences((IProgressMonitor)new SubProgressMonitor(pm, 35), result);
            } else {
                this.fReferences = new SearchResultGroup[0];
            }
            pm.worked(35);
            pm.setTaskName(RefactoringCoreMessages.getString("RenameTypeRefactoring.checking"));
            if (pm.isCanceled()) {
                throw new OperationCanceledException();
            }
            if (this.fUpdateReferences) {
                result.merge(this.analyzeAffectedCompilationUnits((IProgressMonitor)new SubProgressMonitor(pm, 25)));
            } else {
                pm.worked(25);
            }
            if (!result.hasFatalError()) break block23;
            RefactoringStatus refactoringStatus = result;
            Object var5_14 = null;
            pm.done();
            return refactoringStatus;
        }
        this.fChangeManager = this.createChangeManager((IProgressMonitor)new SubProgressMonitor(pm, 35));
        if (this.fUpdateQualifiedNames) {
            this.computeQualifiedNameMatches((IProgressMonitor)new SubProgressMonitor(pm, 10));
        } else {
            pm.worked(10);
        }
        if ((clazz = class$0) == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ltk.core.refactoring.participants.ValidateEditChecker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ValidateEditChecker checker = (ValidateEditChecker)context.getChecker((Class)clazz);
        checker.addFiles(this.getAllFilesToModify());
        RefactoringStatus refactoringStatus = result;
        Object var5_15 = null;
        pm.done();
        return refactoringStatus;
    }

    private RefactoringStatus checkNewPathValidity() {
        IContainer c = ResourceUtil.getResource((IMember)this.fType).getParent();
        String notRename = RefactoringCoreMessages.getString("RenameTypeRefactoring.will_not_rename");
        IStatus status = c.getWorkspace().validateName(this.getNewElementName(), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        status = c.getWorkspace().validatePath(this.createNewPath(this.getNewElementName()), 1);
        if (status.getSeverity() == 4) {
            return RefactoringStatus.createWarningStatus((String)(String.valueOf(status.getMessage()) + ". " + notRename));
        }
        return new RefactoringStatus();
    }

    private String createNewPath(String newName) {
        return ResourceUtil.getResource((IMember)this.fType).getFullPath().removeLastSegments(1).append(newName).toString();
    }

    private RefactoringStatus checkTypesImportedInCu() throws CoreException {
        IImportDeclaration imp = RenameTypeProcessor.getImportedType(this.fType.getCompilationUnit(), this.getNewElementName());
        if (imp == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.imported", new Object[]{this.getNewElementName(), ResourceUtil.getResource((IMember)this.fType).getFullPath()});
        IJavaElement grandParent = imp.getParent().getParent();
        if (grandParent instanceof ICompilationUnit) {
            return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create(imp));
        }
        return null;
    }

    private RefactoringStatus checkTypesInPackage() throws CoreException {
        IType type = Checks.findTypeInPackage(this.fType.getPackageFragment(), this.getNewElementName());
        if (type == null || !type.exists()) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.exists", new String[]{this.getNewElementName(), this.fType.getPackageFragment().getElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)type));
    }

    private RefactoringStatus checkEnclosedTypes() throws CoreException {
        IType enclosedType = RenameTypeProcessor.findEnclosedType(this.fType, this.getNewElementName());
        if (enclosedType == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.encloses", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosedType));
    }

    private RefactoringStatus checkEnclosingTypes() {
        IType enclosingType = RenameTypeProcessor.findEnclosingType(this.fType, this.getNewElementName());
        if (enclosingType == null) {
            return null;
        }
        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed", new String[]{JavaModelUtil.getFullyQualifiedName(this.fType), this.getNewElementName()});
        return RefactoringStatus.createErrorStatus((String)msg, (RefactoringStatusContext)JavaStatusContext.create((IMember)enclosingType));
    }

    private static IType findEnclosedType(IType type, String newName) throws CoreException {
        IType[] enclosedTypes = type.getTypes();
        int i = 0;
        while (i < enclosedTypes.length) {
            if (newName.equals(enclosedTypes[i].getElementName()) || RenameTypeProcessor.findEnclosedType(enclosedTypes[i], newName) != null) {
                return enclosedTypes[i];
            }
            ++i;
        }
        return null;
    }

    private static IType findEnclosingType(IType type, String newName) {
        IType enclosing = type.getDeclaringType();
        while (enclosing != null) {
            if (newName.equals(enclosing.getElementName())) {
                return enclosing;
            }
            enclosing = enclosing.getDeclaringType();
        }
        return null;
    }

    private static IImportDeclaration getImportedType(ICompilationUnit cu, String typeName) throws CoreException {
        IImportDeclaration[] imports = cu.getImports();
        String dotTypeName = "." + typeName;
        int i = 0;
        while (i < imports.length) {
            if (imports[i].getElementName().endsWith(dotTypeName)) {
                return imports[i];
            }
            ++i;
        }
        return null;
    }

    private static boolean isSpecialCase(IType type) {
        return type.getPackageFragment().getElementName().equals("java.lang");
    }

    private IJavaSearchScope createRefactoringScope() throws JavaModelException {
        return RefactoringScopeFactory.create((IJavaElement)this.fType);
    }

    private SearchPattern createSearchPattern() {
        return SearchPattern.createPattern((IJavaElement)this.fType, (int)2);
    }

    private SearchResultGroup[] getReferences(IProgressMonitor pm, RefactoringStatus status) throws CoreException {
        return RefactoringSearchEngine.search(this.createSearchPattern(), this.createRefactoringScope(), pm, status);
    }

    private RefactoringStatus checkForMethodsWithConstructorNames() throws CoreException {
        IMethod[] methods = this.fType.getMethods();
        int i = 0;
        while (i < methods.length) {
            RefactoringStatus check;
            if (!methods[i].isConstructor() && (check = Checks.checkIfConstructorName(methods[i], methods[i].getElementName(), this.getNewElementName())) != null) {
                return check;
            }
            ++i;
        }
        return null;
    }

    private RefactoringStatus checkImportedTypes() throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IImportDeclaration[] imports = this.fType.getCompilationUnit().getImports();
        int i = 0;
        while (i < imports.length) {
            this.analyzeImportDeclaration(imports[i], result);
            ++i;
        }
        return result;
    }

    private RefactoringStatus checkTypesInCompilationUnit() {
        IType siblingType;
        RefactoringStatus result = new RefactoringStatus();
        if (!Checks.isTopLevel(this.fType) && (siblingType = this.fType.getDeclaringType().getType(this.getNewElementName())).exists()) {
            String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type_exists", new String[]{this.getNewElementName(), JavaModelUtil.getFullyQualifiedName(this.fType.getDeclaringType())});
            result.addError(msg, JavaStatusContext.create((IMember)siblingType));
        }
        return result;
    }

    private RefactoringStatus analyseEnclosedTypes() throws CoreException {
        final ISourceRange typeRange = this.fType.getSourceRange();
        final RefactoringStatus result = new RefactoringStatus();
        CompilationUnit cuNode = new RefactoringASTParser(2).parse(this.fType.getCompilationUnit(), false);
        cuNode.accept(new ASTVisitor(){

            public boolean visit(TypeDeclaration node) {
                if (node.getStartPosition() <= typeRange.getOffset()) {
                    return true;
                }
                if (node.getStartPosition() > typeRange.getOffset() + typeRange.getLength()) {
                    return true;
                }
                if (RenameTypeProcessor.this.getNewElementName().equals(node.getName().getIdentifier())) {
                    RefactoringStatusContext context = JavaStatusContext.create(RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)node);
                    String msg = null;
                    if (node.isLocalTypeDeclaration()) {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.local_type", new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    } else if (node.isMemberTypeDeclaration()) {
                        msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.member_type", new String[]{JavaElementUtil.createSignature((IMember)RenameTypeProcessor.this.fType), RenameTypeProcessor.this.getNewElementName()});
                    }
                    if (msg != null) {
                        result.addError(msg, context);
                    }
                }
                MethodDeclaration[] methods = node.getMethods();
                int i = 0;
                while (i < methods.length) {
                    if (Modifier.isNative((int)methods[i].getModifiers())) {
                        RefactoringStatusContext context = JavaStatusContext.create(RenameTypeProcessor.this.fType.getCompilationUnit(), (ASTNode)methods[i]);
                        String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.enclosed_type_native", node.getName().getIdentifier());
                        result.addWarning(msg, context);
                    }
                    ++i;
                }
                return true;
            }
        });
        return result;
    }

    private boolean mustRenameCU() throws CoreException {
        return Checks.isTopLevel(this.fType) && JdtFlags.isPublic((IMember)this.fType);
    }

    private static ICompilationUnit getCompilationUnit(IImportDeclaration imp) {
        return (ICompilationUnit)imp.getParent().getParent();
    }

    private void analyzeImportedTypes(IType[] types, RefactoringStatus result, IImportDeclaration imp) throws CoreException {
        int i = 0;
        while (i < types.length) {
            if (JdtFlags.isPublic((IMember)types[i]) && types[i].getElementName().equals(this.getNewElementName())) {
                String msg = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.name_conflict1", new Object[]{JavaModelUtil.getFullyQualifiedName(types[i]), RenameTypeProcessor.getFullPath(RenameTypeProcessor.getCompilationUnit(imp))});
                result.addError(msg, JavaStatusContext.create(imp));
            }
            ++i;
        }
    }

    private static IJavaElement convertFromImportDeclaration(IImportDeclaration declaration) throws CoreException {
        if (declaration.isOnDemand()) {
            String packageName = declaration.getElementName().substring(0, declaration.getElementName().length() - 2);
            return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), packageName);
        }
        return JavaModelUtil.findTypeContainer(declaration.getJavaProject(), declaration.getElementName());
    }

    private void analyzeImportDeclaration(IImportDeclaration imp, RefactoringStatus result) throws CoreException {
        if (!imp.isOnDemand()) {
            return;
        }
        IJavaElement imported = RenameTypeProcessor.convertFromImportDeclaration(imp);
        if (imported == null) {
            return;
        }
        if (imported instanceof IPackageFragment) {
            ICompilationUnit[] cus = ((IPackageFragment)imported).getCompilationUnits();
            int i = 0;
            while (i < cus.length) {
                this.analyzeImportedTypes(cus[i].getTypes(), result, imp);
                ++i;
            }
        } else {
            this.analyzeImportedTypes(((IType)imported).getTypes(), result, imp);
        }
    }

    private IFile[] getAllFilesToModify() throws CoreException {
        ArrayList<IFile> result = new ArrayList<IFile>();
        result.addAll(Arrays.asList(ResourceUtil.getFiles(this.fChangeManager.getAllCompilationUnits())));
        if (this.fQualifiedNameSearchResult != null) {
            result.addAll(Arrays.asList(this.fQualifiedNameSearchResult.getAllFiles()));
        }
        if (this.willRenameCU()) {
            result.add(ResourceUtil.getFile(this.fType.getCompilationUnit()));
        }
        return result.toArray(new IFile[result.size()]);
    }

    private RefactoringStatus analyzeAffectedCompilationUnits(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        this.fReferences = Checks.excludeCompilationUnits(this.fReferences, result);
        if (result.hasFatalError()) {
            return result;
        }
        result.merge(Checks.checkCompileErrorsInAffectedFiles(this.fReferences));
        pm.beginTask("", this.fReferences.length);
        result.merge(this.checkConflictingTypes(pm));
        return result;
    }

    private RefactoringStatus checkConflictingTypes(IProgressMonitor pm) throws CoreException {
        RefactoringStatus result = new RefactoringStatus();
        IJavaSearchScope scope = RefactoringScopeFactory.create((IJavaElement)this.fType);
        SearchPattern pattern = SearchPattern.createPattern((String)this.getNewElementName(), (int)0, (int)3, (int)8);
        ICompilationUnit[] cusWithReferencesToConflictingTypes = RefactoringSearchEngine.findAffectedCompilationUnits(pattern, scope, pm, result);
        if (cusWithReferencesToConflictingTypes.length == 0) {
            return result;
        }
        ICompilationUnit[] cusWithReferencesToRenamedType = RenameTypeProcessor.getCus(this.fReferences);
        ICompilationUnit[] intersection = RenameTypeProcessor.isIntersectionEmpty(cusWithReferencesToRenamedType, cusWithReferencesToConflictingTypes);
        if (intersection.length == 0) {
            return result;
        }
        int i = 0;
        while (i < intersection.length) {
            RefactoringStatusContext context = JavaStatusContext.create(intersection[i]);
            String message = RefactoringCoreMessages.getFormattedString("RenameTypeRefactoring.another_type", new String[]{this.getNewElementName(), intersection[i].getElementName()});
            result.addError(message, context);
            ++i;
        }
        return result;
    }

    private static ICompilationUnit[] isIntersectionEmpty(ICompilationUnit[] a1, ICompilationUnit[] a2) {
        HashSet<ICompilationUnit> set1 = new HashSet<ICompilationUnit>(Arrays.asList(a1));
        HashSet<ICompilationUnit> set2 = new HashSet<ICompilationUnit>(Arrays.asList(a2));
        set1.retainAll(set2);
        return set1.toArray(new ICompilationUnit[set1.size()]);
    }

    private static ICompilationUnit[] getCus(SearchResultGroup[] searchResultGroups) {
        ArrayList<ICompilationUnit> cus = new ArrayList<ICompilationUnit>(searchResultGroups.length);
        int i = 0;
        while (i < searchResultGroups.length) {
            ICompilationUnit cu = searchResultGroups[i].getCompilationUnit();
            if (cu != null) {
                cus.add(cu);
            }
            ++i;
        }
        return cus.toArray(new ICompilationUnit[cus.size()]);
    }

    private static String getFullPath(ICompilationUnit cu) {
        Assert.isTrue(cu.exists());
        return ResourceUtil.getResource(cu).getFullPath().toString();
    }

    public Change createChange(IProgressMonitor pm) throws CoreException {
        pm.beginTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.creating_change"), 4);
        DynamicValidationStateChange result = new DynamicValidationStateChange(RefactoringCoreMessages.getString("Change.javaChanges"));
        result.addAll((Change[])this.fChangeManager.getAllChanges());
        if (this.willRenameCU()) {
            IResource resource = ResourceUtil.getResource((IMember)this.fType);
            if (resource != null && resource.isLinked()) {
                result.add(new RenameResourceChange(ResourceUtil.getResource((IMember)this.fType), String.valueOf(this.getNewElementName()) + ".java"));
            } else {
                result.add(new RenameCompilationUnitChange(this.fType.getCompilationUnit(), String.valueOf(this.getNewElementName()) + ".java"));
            }
        }
        pm.worked(1);
        return result;
    }

    public Change postCreateChange(Change[] participantChanges, IProgressMonitor pm) throws CoreException {
        if (this.fQualifiedNameSearchResult != null) {
            return this.fQualifiedNameSearchResult.getSingleChange(Changes.getModifiedFiles(participantChanges));
        }
        return null;
    }

    private boolean willRenameCU() throws CoreException {
        if (!this.isPrimaryType()) {
            return false;
        }
        if (!this.checkNewPathValidity().isOK()) {
            return false;
        }
        return Checks.checkCompilationUnitNewName(this.fType.getCompilationUnit(), this.getNewElementName()).isOK();
    }

    private boolean isPrimaryType() {
        return Checks.isTopLevel(this.fType) && this.hasSameNameAsCU();
    }

    private boolean hasSameNameAsCU() {
        return this.fType.getCompilationUnit().getElementName().equals(String.valueOf(this.fType.getElementName()) + ".java");
    }

    private void addTextMatches(TextChangeManager manager, IProgressMonitor pm) throws CoreException {
        TextMatchUpdater.perform(pm, this.createRefactoringScope(), this, manager, this.fReferences);
    }

    private TextChangeManager createChangeManager(IProgressMonitor pm) throws CoreException {
        TextChangeManager textChangeManager;
        try {
            pm.beginTask("", 7);
            TextChangeManager manager = new TextChangeManager();
            if (this.fUpdateReferences) {
                this.addReferenceUpdates(manager, (IProgressMonitor)new SubProgressMonitor(pm, 3));
            }
            pm.worked(1);
            IResource resource = ResourceUtil.getResource((IMember)this.fType);
            if (resource != null && resource.isLinked() || !this.willRenameCU()) {
                this.addTypeDeclarationUpdate(manager);
                pm.worked(1);
                this.addConstructorRenames(manager);
                pm.worked(1);
            } else {
                pm.worked(2);
            }
            if (this.fUpdateTextualMatches) {
                pm.subTask(RefactoringCoreMessages.getString("RenameTypeRefactoring.searching_text"));
                this.addTextMatches(manager, (IProgressMonitor)new SubProgressMonitor(pm, 1));
            }
            textChangeManager = manager;
            Object var4_5 = null;
        }
        catch (Throwable throwable) {
            Object var4_6 = null;
            pm.done();
            throw throwable;
        }
        pm.done();
        return textChangeManager;
    }

    private void addTypeDeclarationUpdate(TextChangeManager manager) throws CoreException {
        String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update");
        int typeNameLength = this.fType.getElementName().length();
        ICompilationUnit cu = this.fType.getCompilationUnit();
        TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(this.fType.getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
    }

    private void addConstructorRenames(TextChangeManager manager) throws CoreException {
        ICompilationUnit cu = this.fType.getCompilationUnit();
        IMethod[] methods = this.fType.getMethods();
        int typeNameLength = this.fType.getElementName().length();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].isConstructor()) {
                String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.rename_constructor");
                TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(methods[i].getNameRange().getOffset(), typeNameLength, this.getNewElementName()));
            }
            ++i;
        }
    }

    private void addReferenceUpdates(TextChangeManager manager, IProgressMonitor pm) {
        pm.beginTask("", this.fReferences.length);
        int i = 0;
        while (i < this.fReferences.length) {
            ICompilationUnit cu = this.fReferences[i].getCompilationUnit();
            if (cu != null) {
                String name = RefactoringCoreMessages.getString("RenameTypeRefactoring.update_reference");
                SearchMatch[] results = this.fReferences[i].getSearchResults();
                int j = 0;
                while (j < results.length) {
                    SearchMatch match = results[j];
                    String oldName = this.fType.getElementName();
                    int offset = match.getOffset() + match.getLength() - oldName.length();
                    TextChangeCompatibility.addTextEdit(manager.get(cu), name, (TextEdit)new ReplaceEdit(offset, oldName.length(), this.getNewElementName()));
                    ++j;
                }
                pm.worked(1);
            }
            ++i;
        }
    }

    private void computeQualifiedNameMatches(IProgressMonitor pm) throws CoreException {
        IPackageFragment fragment = this.fType.getPackageFragment();
        if (this.fQualifiedNameSearchResult == null) {
            this.fQualifiedNameSearchResult = new QualifiedNameSearchResult();
        }
        QualifiedNameFinder.process(this.fQualifiedNameSearchResult, this.fType.getFullyQualifiedName(), String.valueOf(fragment.getElementName()) + "." + this.getNewElementName(), this.fFilePatterns, this.fType.getJavaProject().getProject(), pm);
    }
}

