/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.javadoc;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMInstallChangedListener;
import org.eclipse.jdt.launching.IVMInstallType;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.jdt.launching.LibraryLocation;
import org.eclipse.jdt.launching.PropertyChangeEvent;
import org.eclipse.jdt.ui.JavaUI;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JavaDocVMInstallListener
implements IVMInstallChangedListener {
    private static final String NODE_VM_ROOT = "known_vm_installs";
    private static final String NODE_VM_TYPE = "vm_type";
    private static final String NODE_VM_INSTALL = "vm_install";
    private static final String NODE_VM_ID = "id";
    private static final String NODE_VM_JAVADOCLOCATION = "javadoc_loc";
    private static final String NODE_VM_LIBRARY = "library";
    private static final String NODE_VM_LIB_PATH = "path";

    public static void saveVMInstallJavadocLocations(Document document, Element root) {
        Element vmRootElement = document.createElement(NODE_VM_ROOT);
        root.appendChild(vmRootElement);
        IVMInstallType[] types = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < types.length) {
            IVMInstallType type = types[i];
            Element vmTypeElement = document.createElement(NODE_VM_TYPE);
            vmRootElement.appendChild(vmTypeElement);
            vmTypeElement.setAttribute(NODE_VM_ID, type.getId());
            IVMInstall[] installs = type.getVMInstalls();
            int j = 0;
            while (j < installs.length) {
                IVMInstall install = installs[j];
                URL url = install.getJavadocLocation();
                LibraryLocation[] libraries = JavaRuntime.getLibraryLocations((IVMInstall)install);
                if (url != null && libraries.length > 0) {
                    Element vmInstallElement = document.createElement(NODE_VM_INSTALL);
                    vmTypeElement.appendChild(vmInstallElement);
                    vmInstallElement.setAttribute(NODE_VM_ID, install.getId());
                    vmInstallElement.setAttribute(NODE_VM_JAVADOCLOCATION, url.toExternalForm());
                    int k = 0;
                    while (k < libraries.length) {
                        String path = libraries[k].getSystemLibraryPath().toString();
                        Element librariesElement = document.createElement(NODE_VM_LIBRARY);
                        vmInstallElement.appendChild(librariesElement);
                        librariesElement.setAttribute(NODE_VM_LIB_PATH, path);
                        ++k;
                    }
                }
                ++j;
            }
            ++i;
        }
    }

    public static void collectChangedVMInstallJavadocLocations(Element rootElement, List resPaths, List resURLs) {
        NodeList vmRoots;
        Node root = null;
        if (rootElement != null && (vmRoots = rootElement.getElementsByTagName(NODE_VM_ROOT)).getLength() == 1) {
            root = vmRoots.item(0);
        }
        IVMInstallType[] vmTypes = JavaRuntime.getVMInstallTypes();
        int i = 0;
        while (i < vmTypes.length) {
            IVMInstallType vmType = vmTypes[i];
            Element rememberedVmType = JavaDocVMInstallListener.findElement(root, NODE_VM_TYPE, NODE_VM_ID, vmType.getId());
            IVMInstall[] installs = vmType.getVMInstalls();
            int k = 0;
            while (k < installs.length) {
                IVMInstall vmInstall = installs[k];
                Element rememberedVmInstall = JavaDocVMInstallListener.findElement(rememberedVmType, NODE_VM_INSTALL, NODE_VM_ID, vmInstall.getId());
                JavaDocVMInstallListener.processVMInstall(vmInstall, rememberedVmInstall, resPaths, resURLs);
                ++k;
            }
            ++i;
        }
    }

    private static void processVMInstall(IVMInstall vmInstall, Element rememberedVmInstall, List resPaths, List resURLs) {
        boolean updateAll;
        URL url = vmInstall.getJavadocLocation();
        if (url == null && rememberedVmInstall == null) {
            return;
        }
        if (rememberedVmInstall != null) {
            String loc = rememberedVmInstall.getAttribute(NODE_VM_JAVADOCLOCATION);
            updateAll = url == null && loc != null || url != null && !url.toExternalForm().equals(loc);
        } else {
            updateAll = true;
        }
        LibraryLocation[] libraryLocations = JavaRuntime.getLibraryLocations((IVMInstall)vmInstall);
        int i = 0;
        while (i < libraryLocations.length) {
            IPath libPath = libraryLocations[i].getSystemLibraryPath();
            if (updateAll || JavaDocVMInstallListener.findElement(rememberedVmInstall, NODE_VM_LIBRARY, NODE_VM_LIB_PATH, libPath.toString()) == null) {
                resPaths.add(libPath);
                resURLs.add(url);
            }
            ++i;
        }
    }

    private static Element findElement(Node root, String elemName, String attribName, String attribValue) {
        if (root != null) {
            NodeList nodes = root.getChildNodes();
            int i = nodes.getLength() - 1;
            while (i >= 0) {
                Node node = nodes.item(i);
                if (node.getNodeType() == 1 && node.getNodeName().equalsIgnoreCase(elemName) && attribValue.equals(((Element)node).getAttribute(attribName))) {
                    return (Element)node;
                }
                --i;
            }
        }
        return null;
    }

    public void init() {
        JavaRuntime.addVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void remove() {
        JavaRuntime.removeVMInstallChangedListener((IVMInstallChangedListener)this);
    }

    public void defaultVMInstallChanged(IVMInstall previous, IVMInstall current) {
    }

    private static void updateJavadocLocations(IVMInstall install) {
        LibraryLocation[] locations;
        ArrayList<IPath> paths = new ArrayList<IPath>();
        ArrayList<URL> urls = new ArrayList<URL>();
        URL url = install.getJavadocLocation();
        if (url != null && (locations = JavaRuntime.getLibraryLocations((IVMInstall)install)) != null) {
            int i = 0;
            while (i < locations.length) {
                IPath path = locations[i].getSystemLibraryPath();
                if (path != null) {
                    paths.add(path);
                    urls.add(url);
                }
                ++i;
            }
        }
        if (!paths.isEmpty()) {
            IPath[] allPaths = paths.toArray(new IPath[paths.size()]);
            URL[] allURLs = urls.toArray(new URL[urls.size()]);
            JavaUI.setLibraryJavadocLocations(allPaths, allURLs);
        }
    }

    public void vmChanged(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (IVMInstallChangedListener.PROPERTY_INSTALL_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_JAVADOC_LOCATION.equals(property) || IVMInstallChangedListener.PROPERTY_LIBRARY_LOCATIONS.equals(property)) {
            JavaDocVMInstallListener.updateJavadocLocations((IVMInstall)event.getSource());
        }
    }

    public void vmAdded(IVMInstall vm) {
        JavaDocVMInstallListener.updateJavadocLocations(vm);
    }

    public void vmRemoved(IVMInstall vm) {
    }
}

