package util;

import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;

import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleStatement;
import conf.ConfigConstants;

public class SessionBuffer
{
   private static int logLevel; // maximaler Level, bis zu dem Meldungen ausgegeben werden
   private static BufferedWriter logFile;
   private static boolean traceFlag = true; // schaltet den StackTrace an oder aus; default true
   public static boolean useLog; // Benutze eine Logdatei 'session.log'.
   private static SessionBuffer sessionBuffer = null;
   public static boolean dbConnect = false;
   public static String defaultUser;
   public static String defaultUserPasswd;
   public static String dbHost;
   public static String sServiceName; // Der Service-Name fr die Oracle-Verbindung.
   static OracleConnection oracleConnection = null;
   public static oracle.jdbc.driver.OracleDriver oracleDriver = null;
   
   public void setLogLevel(int logLevel)
   {
      this.logLevel = logLevel;
   }
   
   public int getLogLevel()
   {
      return logLevel;
   }
   
   public static void initLog()
   {
      try
      {
         logFile = new BufferedWriter( new FileWriter( System.getProperty( "user.dir" ) + System.getProperty( "file.separator" ) + "session.log", false ) );
         logFile.newLine();
         logFile.write( "LOG-FILE-STARTUP: " + new java.util.Date().toString() );
         logFile.newLine();
         logFile.newLine();
         logFile.flush();
         useLog = true;
      }
      catch ( Exception any )
      {
         log(any);
      }
   }
   
   public static void log(Exception exception)
   {
      if (traceFlag) exception.printStackTrace();
      else System.err.println(exception.getClass() + ": " + exception.getMessage());
   }
   
   public static synchronized SessionBuffer getInstance()
   {
      if ( sessionBuffer == null )
      {
         sessionBuffer = new SessionBuffer();
      }
      return sessionBuffer;
   }
   
   public static SessionBuffer getInstance( boolean connect )
   {
      if ( sessionBuffer == null )
      {
         sessionBuffer = new SessionBuffer();
      }
      
      if ( !dbConnect && connect )
      {
         
         LoginDialog lDialog = new LoginDialog();
         
         if ( lDialog.isOK() )
         {
            defaultUser = lDialog.getUser();
            defaultUserPasswd = lDialog.getPassword();
            dbHost = lDialog.getHost();
            sServiceName = lDialog.getSID();
            oracleConnection = getOracleConnection();
         }
         else
         {
            defaultUser = null;
            defaultUserPasswd = null;
            dbHost = null;
            sServiceName = null;
         }
         if ( dbHost == null || !connect )
         {
            log( "DB-Connection: <none>", 2 );
            dbConnect = false;
            
         }
      }
      return sessionBuffer;
   }
   
   public static void log( String msg, int level )
   {
      if (level <= logLevel)
      {
         System.out.println( msg );
         if ( useLog )
         {
            try
            {
               logFile.write( msg );
               logFile.newLine();
               logFile.flush();
            }
            catch ( Exception any )
            {
               log(any);
               useLog = false;
            }
         }
      }
   }
   
   public void closeDB()
   {
      if ( dbConnect )
      {
         try
         {
            //dbinterface.close();
            //DBFrame.close();
            //oracleConnection.close();
            oracleConnection.close();
            log( "DB-Verbindung: " + sServiceName + ":" + dbHost + " geschlossen.", 2 );
         }
         catch ( Exception e )
         {
            log(e);
         }
      }
   }
   
   public static OracleStatement getStatement()
   {
      if (oracleConnection == null)
         return null;
      
      try
      {
         if (! oracleConnection.isClosed())
         return (OracleStatement)oracleConnection.createStatement();
         else
            return null;
      }
      catch ( Exception any )
      {
         return null;
      }
   }
   
   public static synchronized OracleConnection getOracleConnection()
   {
      OracleConnection oc = null;
      
      try
      {
         if ( oracleDriver == null )
         {
            oracleDriver = new oracle.jdbc.driver.OracleDriver();
            DriverManager.registerDriver( oracleDriver );
         }
         oc = (OracleConnection) DriverManager.getConnection(
         "jdbc:oracle:thin:@(DESCRIPTION=(ADDRESS_LIST=(ADDRESS=(PROTOCOL=TCP)(HOST=" + dbHost + ")(PORT=1521)))(CONNECT_DATA=(SERVICE_NAME=" + sServiceName + ")))",
         defaultUser,
         defaultUserPasswd
         );
         oc.setAutoCommit( false );
         oc.setExplicitCachingEnabled(false);
         oc.setDefaultRowPrefetch(10);
         oc.setImplicitCachingEnabled(false);
         log( "New Connection " + sServiceName + ":" + dbHost + " established.", 2 );
         dbConnect = true;
      }
      catch ( SQLException q )
      {
         log(q);
         dbConnect = false;
         
         q.printStackTrace();
         System.exit(1);
      }
      
      return oc;
   }
   
   
}