package util;

import java.util.Vector;

import javax.swing.table.AbstractTableModel;

/**
 *  Diese Hilfsklasse dient der Verwaltung der Tabelle fuer die DB-Anbindung.
 *
 * @author     T
 * @created    15. Juni 2001
 */
public class DBTableModel extends AbstractTableModel {

  private String[] columnNames;
  private Vector data = new Vector();


  public void setDataVector( Vector vector ) {
    this.data = vector;
    fireTableDataChanged();
  }


  public void setColumnNames( String[] columnNames ) {
    this.columnNames = columnNames;
    fireTableStructureChanged();
  }


  public void setValueAt( Object value, int row, int col ) {
    Object[] objects = (Object[]) data.elementAt( row );

    objects[col] = value;
    fireTableCellUpdated( row, col );
  }


  public Vector getDataVector() {
    return data;
  }


  public int getColumnCount() {
    return columnNames.length;
  }


  public int getRowCount() {
    return data.size();
  }


  public String getColumnName( int col ) {
    return columnNames[col];
  }


  public Object getValueAt( int row, int col ) {
    if ( row < data.size() && col < columnNames.length ) {
      Object[] objects = (Object[]) data.elementAt( row );

      return objects[col];
    } else {
      return null;
    }
  }


  public Object[] getRowAt( int index ) {
    return (Object[]) data.elementAt( index );
  }


  public Class getColumnClass( int c ) {
    try {
      return getValueAt( 0, c ).getClass();
    }
    catch ( NullPointerException npe ) {
    }
    return new String().getClass();
  }


  public boolean isCellEditable( int row, int col ) {
    return false;
  }


  public void addRow( Object[] objects ) {
    data.addElement( objects );
    fireTableRowsInserted( data.size(), data.size() );
  }


  public void insertRow( Object[] objects, int index ) {
    data.insertElementAt( objects, index );
    fireTableRowsInserted( index, data.size() );
  }


  public void removeRow( int index ) {
    data.remove( index );
    fireTableRowsDeleted( index, data.size() );
  }


  public void removeAllRows() {
    data.removeAllElements();
    fireTableDataChanged();
  }

}

