package util;
import java.awt.Frame;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

import javax.swing.JFrame;
import javax.swing.JInternalFrame;

/**
 *  Diese Hilfsklasse dient dem Schlieen von Fenstern.
 *
 * @author     Theobald
 * @created    15. Juni 2001
 */

public class CloseWindow extends WindowAdapter {
  private Object frame;


  /**
   *  Konstruiert ein neues WindowAdapter CloseWindow.
   *
   * @param  frame  Der Frame.
   */
  public CloseWindow( Object frame ) {
    this.frame = frame;
  }


  /**
   *  Schliesst einen Frame mit dispose().
   *
   * @param  e  Description of Parameter
   */
  public void windowClosing( WindowEvent e ) {
    if ( frame instanceof JInternalFrame ) {
      ( (JInternalFrame) frame ).dispose();
    } else if ( frame instanceof JFrame ) {
      ( (JFrame) frame ).dispose();
    } else if ( frame instanceof Frame ) {
      ( (Frame) frame ).dispose();
    }
  }
}

