package language;

/*
    LanguageParserHandler.java
  */
import java.util.Hashtable;

import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

/**
 * @author     kaster
 * @created    22. Juli 2003
 */

public class LanguageParserHandler extends DefaultHandler {

  private String qName = null;
  private Hashtable values = new Hashtable();

  public void startElement( String uri, String localName, String qName, Attributes attributes ) {
    this.qName = qName;
  }


  public void characters( char[] ch, int start, int length ) {
    String data = new String( ch, start, length );

    data = data.trim();
    if ( data.length() > 0 ) {
      values.put( qName, data );
    }
  }


  public Hashtable getValues() {
    return values;
  }

}
