/*
    LanguageConstants.java
    Created on 19. September 2002, 14:42
  */
package language;

import java.net.URL;
import java.util.Hashtable;

import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import conf.ConfigConstants;
import util.SessionBuffer;
/**
 * @author     kaster
 * @created    22. Juli 2003
 */
public class LanguageConstants {
  private Hashtable values;
// Konstanten dieser Klasse
  private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";

  private XMLReader reader;
  private LanguageParserHandler handler;

  private static LanguageConstants lc = null;
  private static ConfigConstants cc = ConfigConstants.getInstance();


  public static LanguageConstants getInstance() {
    if ( lc == null ) {
      lc = new LanguageConstants();
    }
    return lc;
  }


  /**
   * Creates a new instance of LanguageConstants
   */
  private LanguageConstants() {
    String CONFIG_DIRECTORY = "conf/";
    String configfile = cc.get( "langFile" ) + ".xml";
    URL u = null;

    try {
      ClassLoader cl = this.getClass().getClassLoader();

      u = cl.getResource( CONFIG_DIRECTORY + configfile );
      reader = XMLReaderFactory.createXMLReader( SAX_PARSER );
      handler = new LanguageParserHandler();
    }
    catch ( Exception e ) {
      SessionBuffer.log(e);
    }
    this.parseLanguage( u );
  }


  public String get( String key ) {
    return ( (String) values.get( key ) );
  }


  private void parseLanguage( URL destination ) {
    try {
      reader.setContentHandler( handler );
      reader.parse( destination.toString() );
      values = handler.getValues();
    }
    catch ( Exception e ) {
      SessionBuffer.log(e);
    }

  }
}
