/*
    LanguageConstants.java
    Created on 19. September 2002, 14:42
 */
package conf;

import java.io.FileWriter;
import java.net.URL;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;

import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLReaderFactory;

import util.SessionBuffer;

/**
 * @author     kaster
 * @created    22. Juli 2003
 */
public class ConfigConstants {
    private Hashtable values;
    // Konstanten dieser Klasse
    private static final String SAX_PARSER = "org.apache.xerces.parsers.SAXParser";
    
    private XMLReader reader;
    private ConfigParserHandler handler;
    
    private static ConfigConstants cc = null;
    
    public static ConfigConstants getInstance() {
        if ( cc == null ) {
            cc = new ConfigConstants();
        }
        return cc;
    }
    
    
    /**
     * Creates a new instance of LanguageConstants
     */
    private ConfigConstants() {
        String CONFIG_DIRECTORY = "conf/";
        String configfile = "config.xml";
        URL u = null;
        
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            
            u = cl.getResource( CONFIG_DIRECTORY + configfile );
            reader = XMLReaderFactory.createXMLReader( SAX_PARSER );
            handler = new ConfigParserHandler();
        }
        catch ( Exception e ) {
            SessionBuffer.log(e);
        }
        this.parseConfig( u );
        
    }
    
    
    private void parseConfig( URL destination ) {
        try {
            reader.setContentHandler( handler );
            reader.parse( destination.toString() );
            values = handler.getValues();
            
        }
        catch ( Exception e ) {
            SessionBuffer.log(e);
        }
    }
    
    
    public String get( String key ) {
        return ( (String) values.get( key ) );
    }
    
    
    public void set( String key, String value ) {
        values.put( key, value );
    }
    
    
    public void saveConfig() {
        Enumeration keys;
        String s = System.getProperty( "file.separator" );
        String userDir = System.getProperty( "user.dir" );
        Date date = new Date( System.currentTimeMillis() );
        StringBuffer buf = new StringBuffer( 2000 );
        
        // XML-Header
        buf.append( "<?xml version=\"1.0\" encoding=\"UTF-8\"?>" );
        buf.append( "<!--\n"
        + "Document   : config.xml\n"
        + "Created on : " + date + "\n"
        + "Author     : BINGO!\n"
        + "Description: Configuration Settings BINGO - Bookmark Induced Gathering Of Information\n"
        + "-->\n" );
        
        buf.append( "<config>" );
        
        // Config-data
        keys = values.keys();
        
        while ( keys.hasMoreElements() ) {
            String key = (String) keys.nextElement();
            
            buf.append( "<" + key + ">" + (String) cc.values.get( key ) + "</" + key + ">\n" );
        }
        
        // footer
        buf.append( "</config>" );
        
        try {
            FileWriter writer = new FileWriter( userDir + s + "conf" + s + "config.xml" );
            writer.write( buf.toString() );
            writer.flush();
        }
        catch ( Exception e ) {
            System.err.println( "Cannot write to file: " + userDir + s + "conf" + s + "config.xml" );
            SessionBuffer.log(e);
        }
    }
    
    
    public void restoreDefault() {
        String DEFAULT_FILE = "bingo/data/config.def";
        URL u = null;
        
        values.clear();
        
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            
            u = cl.getResource( DEFAULT_FILE );
            reader = XMLReaderFactory.createXMLReader( SAX_PARSER );
            handler = new ConfigParserHandler();
        }
        catch ( Exception e ) {
            SessionBuffer.log(e);
        }
        this.parseConfig( u );
        this.saveConfig();
    }
    
    public Hashtable getValues() {
        return values;
    }
    
    /** gebraucht fuer Test-Suite */
    public void destroy() {
        this.cc = null;
    }
}
