/* VetoSwitch.java */

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.beans.*;

public class VetoSwitch
extends Canvas
implements Serializable, VetoableChangeListener
{
  //---Instanzvariablen----------------------------------------
  protected Color   linecolor;
  protected boolean vetoallchanges;

  //---Methoden------------------------------------------------
  public VetoSwitch()
  {
    this.linecolor = Color.black;
    this.vetoallchanges = false;
    initTransientState();
  }

  //---Konturenfarbe---
  public void setLineColor(Color color)
  {
    this.linecolor = color;
  }

  public Color getLineColor()
  {
    return this.linecolor;
  }

  //---Zustandsumschaltung Licht an/aus---
  public void setVetoAllChanges(boolean b)
  {
    if (this.vetoallchanges != b) {
      this.vetoallchanges = b;
      repaint();
    }
  }

  public boolean getVetoAllChanges()
  {
    return this.vetoallchanges;
  }

  //---Veto---
  public void vetoableChange(PropertyChangeEvent e)
  throws PropertyVetoException
  {
    if (this.vetoallchanges) {
      throw new PropertyVetoException("!!!VETO!!!", e);
    }
  }

  //---Implementierung der Oberflche---
  public void paint(Graphics g)
  {
    int width = getSize().width;
    int height = getSize().height;
    g.setColor(linecolor);
    g.drawRect(0, 0, width - 1, height - 1);
    g.drawLine(width * 1 / 8, height / 2, width * 3 / 8, height / 2);
    g.drawLine(width * 5 / 8, height / 2, width * 7 / 8, height / 2);
    g.fillRect(width * 3 / 8 - 1, height / 2 - 1, 3, 3);
    g.fillRect(width * 5 / 8 - 1, height / 2 - 1, 3, 3);
    if (this.vetoallchanges) {
      //draw open connection
      g.drawLine(width * 3 / 8, height / 2, width * 5 / 8, height / 4);
    } else {
      //draw short-cutted connection
      g.drawLine(width * 3 / 8, height / 2, width * 5 / 8, height / 2);
    }
  }

  public Dimension getPreferredSize()
  {
    return new Dimension(60, 20);
  }

  public Dimension getMinimumSize()
  {
    return new Dimension(28, 10);
  }

  //---Private Klassen----------------------------------------
  private void initTransientState()
  {
    addMouseListener(new MouseClickAdapter());
  }

  /**
   * Wird berlagert, um nach dem Deserialisieren den transienten
   * Zustand zu initialisieren.
   */
  private void readObject(ObjectInputStream stream)
  throws IOException, ClassNotFoundException
  {
    stream.defaultReadObject();
    initTransientState();
  }

  //---Lokale Klassen----------------------------------------
  class MouseClickAdapter
  extends MouseAdapter
  {
    public void mouseClicked(MouseEvent event)
    {
      setVetoAllChanges(!getVetoAllChanges());
    }
  }
}