/* VerifySignature.java */

import java.io.*;
import java.security.cert.Certificate;
import java.security.*;

public class VerifySignature
{
  static final String KEYSTORE = "c:\\windows\\.keystore";
  static final char[] KSPASS   = {'h','j','p','3','k','s'};
  static final String ALIAS    = "hjp3";

  public static void main(String[] args)
  {
    try {
      //Laden der Schlsseldatenbank
      KeyStore ks = KeyStore.getInstance("JKS");
      FileInputStream ksin = new FileInputStream(KEYSTORE);
      ks.load(ksin, KSPASS);
      ksin.close();
      //Zertifikat "hjp3" lesen
      Certificate cert = ks.getCertificate(ALIAS);
      //Signature-Objekt erstellen
      Signature signature = Signature.getInstance("SHA/DSA");
      signature.initVerify(cert.getPublicKey());
      //Eingabedatei lesen
      FileInputStream in = new FileInputStream(args[0]);
      int len;
      byte[] data = new byte[1024];
      while ((len = in.read(data)) > 0) {
        //Signatur updaten
        signature.update(data, 0, len);
      }
      in.close();
      //Signaturdatei einlesen
      in = new FileInputStream(args[1]);
      len = in.read(data);
      in.close();
      byte[] sign = new byte[len];
      System.arraycopy(data, 0, sign, 0, len);
      //Signatur ausgeben
      boolean result = signature.verify(sign);
      System.out.println("verification result: " + result);
    } catch (Exception e) {
      System.err.println(e.toString());
      System.exit(1);
    }
  }
}