/* URLLaden.java */

import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import java.net.*;

class URLButton
extends Button
{
  private URL url;

  public URLButton(String label, URL url)
  {
    super(label);
    this.url = url;
  }

  public URL getURL()
  {
    return url;
  }
}

public class URLLaden
extends Applet
implements ActionListener
{
  Vector buttons;

  public void init()
  {
    super.init();
    setLayout(new FlowLayout());
    addNotify();
    buttons = new Vector();
    for (int i=1; ; ++i) {
      String s = getParameter("button"+i);
      if (s == null) {
        break;
      }
      try {
        StringTokenizer st = new StringTokenizer(s,",");
        String label = st.nextToken();
        String urlstring = st.nextToken();
        URL url;
        if (urlstring.charAt(0) == '=') {
          urlstring = urlstring.substring(1);
          url = new URL(getDocumentBase(),urlstring);
        } else {
          url = new URL(urlstring);
        }
        URLButton button = new URLButton(label,url);
        button.addActionListener(this);
        add(button);
        buttons.addElement(button);
      } catch (NoSuchElementException e) {
        System.out.println("Button"+i+": "+e.toString());
        break;
      } catch (MalformedURLException e) {
        System.out.println("Button"+i+": "+e.toString());
        break;
      }
    }
  }

  public void actionPerformed(ActionEvent event)
  {
    URLButton source = (URLButton)event.getSource();
    Enumeration en = buttons.elements();
    while (en.hasMoreElements()) {
      URLButton button = (URLButton)en.nextElement();
      if (button == source) {
        System.out.println(
          "showDocument("+button.getURL().toString()+")"
        );
        getAppletContext().showDocument(button.getURL());
      }
    }
  }
}